/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import com.mojang.logging.LogUtils;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.Set;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.event.MoreClientEntityEvents;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.features.SuggestionsHook;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.minecraft.class_1299;
import net.minecraft.class_2604;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;

public abstract class ItemThrowTask
extends SimpleTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Object> MUTEX_KEYS = Set.of(ItemThrowTask.class);
    public static final int FLAG_URGENT = 1;
    public static final int FLAG_WAIT_FOR_ITEMS = 2;
    private static WeakReference<ItemThrowTask> currentThrowTask = null;
    private final int totalItemsToThrow;
    private final int flags;
    private int confirmedItemThrows;
    private int sentItemThrows;
    private float itemThrowsAllowedThisTick;
    private boolean waitingFence = false;
    private boolean failed = false;
    private boolean isThrowingItem = false;
    private boolean hadUnexpectedRNGCall = false;
    private final Set<PlayerRandCracker.ThrowItemsResult.Type> errorTypesHappened = EnumSet.noneOf(PlayerRandCracker.ThrowItemsResult.Type.class);

    public ItemThrowTask(int itemsToThrow) {
        this(itemsToThrow, 0);
    }

    public ItemThrowTask(int itemsToThrow, int flags) {
        this.totalItemsToThrow = itemsToThrow;
        this.flags = flags;
    }

    @Override
    public boolean condition() {
        return this.waitingFence || this.sentItemThrows != this.totalItemsToThrow || this.sentItemThrows > this.confirmedItemThrows;
    }

    @Override
    protected void onTick() {
        this.itemThrowsAllowedThisTick += Configs.itemThrowsPerTick;
        while (((this.flags & 1) != 0 || this.itemThrowsAllowedThisTick >= 1.0f) && this.sentItemThrows < this.totalItemsToThrow) {
            this.itemThrowsAllowedThisTick -= 1.0f;
            this.isThrowingItem = true;
            PlayerRandCracker.ThrowItemsResult throwItemsResult = PlayerRandCracker.throwItem();
            this.isThrowingItem = false;
            if (this.hadUnexpectedRNGCall) {
                return;
            }
            if (!throwItemsResult.isSuccess()) {
                this.onFailedToThrowItem(throwItemsResult);
                if ((this.flags & 2) != 0) {
                    return;
                }
                this.failed = true;
                this._break();
                return;
            }
            this.onItemThrown(++this.sentItemThrows, this.totalItemsToThrow);
        }
        if (!this.waitingFence && this.sentItemThrows == this.totalItemsToThrow && this.confirmedItemThrows < this.sentItemThrows) {
            this.waitingFence = true;
            SuggestionsHook.fence().thenAccept(v -> {
                if (this.sentItemThrows > this.confirmedItemThrows) {
                    LOGGER.info("Server rejected {} item throws. Rethrowing them.", (Object)(this.sentItemThrows - this.confirmedItemThrows));
                    while (this.sentItemThrows > this.confirmedItemThrows) {
                        PlayerRandCracker.unthrowItem();
                        --this.sentItemThrows;
                    }
                }
                this.waitingFence = false;
            });
        }
    }

    @Override
    public void initialize() {
        currentThrowTask = new WeakReference<ItemThrowTask>(this);
    }

    @Override
    public void onCompleted() {
        if (!this.failed) {
            this.onSuccess();
        }
        currentThrowTask = null;
    }

    @Override
    public Set<Object> getMutexKeys() {
        return MUTEX_KEYS;
    }

    protected void onFailedToThrowItem(PlayerRandCracker.ThrowItemsResult throwItemsResult) {
        if ((throwItemsResult.getType() != PlayerRandCracker.ThrowItemsResult.Type.NOT_ENOUGH_ITEMS || (this.flags & 2) == 0) && this.errorTypesHappened.add(throwItemsResult.getType())) {
            throwItemsResult.sendErrorMessage();
        }
    }

    protected void onSuccess() {
    }

    protected abstract void onUnexpectedRNGCall(PlayerRandCracker.RNGCallType var1);

    protected void onItemSpawn(class_2604 packet) {
    }

    protected void onItemThrown(int current, int total) {
    }

    protected boolean requireCrackedRNG() {
        return true;
    }

    private static void handleItemSpawn(class_2604 packet) {
        ItemThrowTask task;
        if (packet.method_11169() != class_1299.field_6052) {
            return;
        }
        ItemThrowTask itemThrowTask = task = currentThrowTask == null ? null : (ItemThrowTask)currentThrowTask.get();
        if (task == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (player.method_33571().method_1028(packet.method_11175(), packet.method_11174(), packet.method_11176()) > 1.0) {
            return;
        }
        ++task.confirmedItemThrows;
        task.onItemSpawn(packet);
    }

    private static void handleRNGCallEvent(PlayerRandCracker.RNGCallEvent event) {
        ItemThrowTask task;
        ItemThrowTask itemThrowTask = task = currentThrowTask == null ? null : (ItemThrowTask)currentThrowTask.get();
        if (task != null) {
            if (task.isThrowingItem && event.getType() == PlayerRandCracker.RNGCallType.DROP_ITEM) {
                if (task.requireCrackedRNG()) {
                    event.setMaintained();
                } else {
                    event.setMaintainedEvenIfSeedUnknown();
                }
                task.isThrowingItem = false;
            } else {
                task.onUnexpectedRNGCall(event.getType());
                task.hadUnexpectedRNGCall = true;
                task.failed = true;
                task._break();
            }
        }
    }

    public String toString() {
        return "ItemThrowTask[totalItemsToThrow=" + this.totalItemsToThrow + ",flags=" + this.flags + "]";
    }

    static {
        MoreClientEntityEvents.POST_ADD.register(ItemThrowTask::handleItemSpawn);
        PlayerRandCracker.RNG_CALLED_EVENT.register(ItemThrowTask::handleRNGCallEvent);
    }
}

