/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.earthcomputer.clientcommands.event.MoreWorldRenderEvents;
import net.earthcomputer.clientcommands.render.Cuboid;
import net.earthcomputer.clientcommands.render.Line;
import net.earthcomputer.clientcommands.render.Shape;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.minecraft.class_10799;
import net.minecraft.class_11658;
import net.minecraft.class_12245;
import net.minecraft.class_12246;
import net.minecraft.class_12247;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class RenderQueue {
    private static int tickCounter = 0;
    private static final List<AddQueueEntry> addQueue = new ArrayList<AddQueueEntry>();
    private static final List<RemoveQueueEntry> removeQueue = new ArrayList<RemoveQueueEntry>();
    private static final EnumMap<Layer, Map<Object, Shape>> queue = new EnumMap(Layer.class);
    private static final RenderStateDataKey<EnumMap<Layer, List<Line>>> LINES_KEY = RenderStateDataKey.create(() -> "clientcommands render queue");
    private static final RenderPipeline LINES_NO_DEPTH_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56859}).withLocation(class_2960.method_60655((String)"clientcommands", (String)"pipeline/lines_no_depth")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build());
    public static final class_1921 LINES_NO_DEPTH_LAYER = class_1921.method_75940((String)"clientcommands_no_depth", (class_12247)class_12247.method_75927((RenderPipeline)LINES_NO_DEPTH_PIPELINE).method_75930(class_12245.field_63976).method_75931(class_12246.field_63983).method_75938());

    public static void register() {
    }

    public static void add(Layer layer, Object key, Shape shape, int life) {
        addQueue.add(new AddQueueEntry(layer, key, shape, life));
    }

    public static void addCuboid(Layer layer, Object key, class_243 from, class_243 to, int color, int life) {
        RenderQueue.add(layer, key, new Cuboid(from, to, color), life);
    }

    public static void addCuboid(Layer layer, Object key, class_238 cuboid, int color, int life) {
        RenderQueue.add(layer, key, new Cuboid(cuboid, color), life);
    }

    public static void addLine(Layer layer, Object key, class_243 from, class_243 to, int color, int life) {
        RenderQueue.add(layer, key, new Line(from, to, color), life);
    }

    public static void remove(Layer layer, Object key) {
        removeQueue.add(new RemoveQueueEntry(layer, key));
    }

    private static void doAdd(AddQueueEntry entry) {
        Map shapes = queue.computeIfAbsent(entry.layer(), k -> new LinkedHashMap());
        Shape oldShape = (Shape)shapes.get(entry.key());
        entry.shape().prevPos = oldShape != null ? oldShape.prevPos : entry.shape().getPos();
        entry.shape().deathTime = tickCounter + entry.life();
        shapes.put(entry.key(), entry.shape());
    }

    private static void tick(class_310 mc) {
        for (RemoveQueueEntry removeQueueEntry : removeQueue) {
            Map<Object, Shape> shapes2 = queue.get((Object)removeQueueEntry.layer());
            if (shapes2 == null) continue;
            shapes2.remove(removeQueueEntry.key());
        }
        removeQueue.clear();
        queue.values().forEach(shapes -> shapes.values().forEach(shape -> {
            shape.prevPos = shape.getPos();
        }));
        ++tickCounter;
        for (AddQueueEntry addQueueEntry : addQueue) {
            RenderQueue.doAdd(addQueueEntry);
        }
        addQueue.clear();
        for (Map map : queue.values()) {
            Iterator itr = map.values().iterator();
            while (itr.hasNext()) {
                Shape shape = (Shape)itr.next();
                if (tickCounter == shape.deathTime) {
                    itr.remove();
                }
                shape.tick();
            }
        }
    }

    private static void render(Layer layer, class_4588 vertexConsumer, class_4587 poseStack, class_11658 state) {
        EnumMap lines = (EnumMap)state.getData(LINES_KEY);
        if (lines == null) {
            return;
        }
        List linesToRender = (List)lines.get((Object)layer);
        if (linesToRender == null) {
            return;
        }
        for (Line line : linesToRender) {
            line.draw(vertexConsumer, poseStack);
        }
    }

    static {
        ClientTickEvents.START_CLIENT_TICK.register(RenderQueue::tick);
        MoreWorldRenderEvents.EXTRACT_STATE.register((state, camera, deltaTracker) -> {
            EnumMap lines = new EnumMap(Layer.class);
            queue.forEach((layer, shapes) -> {
                ArrayList linesToRender = new ArrayList();
                shapes.values().forEach(shape -> shape.addLines(linesToRender::add, camera, deltaTracker));
                lines.put((Layer)((Object)((Object)layer)), linesToRender);
            });
            state.setData(LINES_KEY, lines);
        });
        MoreWorldRenderEvents.END_MAIN_PASS.register((bufferSource, poseStack, state) -> RenderQueue.render(Layer.ON_TOP, bufferSource.method_73477(LINES_NO_DEPTH_LAYER), poseStack, state));
    }

    private record AddQueueEntry(Layer layer, Object key, Shape shape, int life) {
    }

    public static enum Layer {
        ON_TOP;

    }

    private record RemoveQueueEntry(Layer layer, Object key) {
    }
}

