/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import org.jspecify.annotations.Nullable;

public class WikiRetriever {
    private static final String WIKI_HOST = "https://minecraft.wiki/";
    private static final String PAGE_SUMMARY_QUERY = "https://minecraft.wiki/api.php?action=query&prop=extracts&exintro=true&format=json&titles=%s";
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<\\s*(/)?\\s*(\\w+).*?>|<!--.*?-->|\n", 32);
    private static final class_124 CODE_COLOR = class_124.field_1077;
    private static final Gson GSON = new Gson();

    public static String decode(String html) {
        Matcher matcher = HTML_TAG_PATTERN.matcher(html);
        StringBuilder raw = new StringBuilder();
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean code = false;
        int listIndex = -1;
        while (matcher.find()) {
            matcher.appendReplacement(raw, "");
            boolean endTag = matcher.group(1) != null;
            String tagName = matcher.group(2);
            if (tagName == null) continue;
            tagName = tagName.toLowerCase(Locale.ROOT);
            if (!endTag) {
                switch (tagName) {
                    case "b": {
                        raw.append(class_124.field_1067);
                        bold = true;
                        break;
                    }
                    case "i": {
                        raw.append(class_124.field_1056);
                        italic = true;
                        break;
                    }
                    case "u": 
                    case "dt": {
                        raw.append(class_124.field_1073);
                        underline = true;
                        break;
                    }
                    case "code": {
                        raw.append(CODE_COLOR);
                        if (bold) {
                            raw.append(class_124.field_1067);
                        }
                        if (italic) {
                            raw.append(class_124.field_1056);
                        }
                        if (underline) {
                            raw.append(class_124.field_1073);
                        }
                        code = true;
                        break;
                    }
                    case "dd": {
                        raw.append("  ");
                        break;
                    }
                    case "ul": {
                        listIndex = 0;
                        break;
                    }
                    case "ol": {
                        listIndex = 1;
                        break;
                    }
                    case "li": {
                        if (listIndex >= 1) {
                            raw.append("  ").append(listIndex).append(". ");
                            ++listIndex;
                            break;
                        }
                        raw.append("  \u2022");
                        break;
                    }
                    case "br": {
                        raw.append("\n");
                    }
                }
                continue;
            }
            switch (tagName) {
                case "b": {
                    if (code) {
                        raw.append(CODE_COLOR);
                    } else {
                        raw.append(class_124.field_1070);
                    }
                    if (italic) {
                        raw.append(class_124.field_1056);
                    }
                    if (underline) {
                        raw.append(class_124.field_1073);
                    }
                    bold = false;
                    break;
                }
                case "i": {
                    if (code) {
                        raw.append(CODE_COLOR);
                    } else {
                        raw.append(class_124.field_1070);
                    }
                    if (bold) {
                        raw.append(class_124.field_1067);
                    }
                    if (underline) {
                        raw.append(class_124.field_1073);
                    }
                    italic = false;
                    break;
                }
                case "dt": {
                    raw.append("\n");
                }
                case "u": {
                    if (code) {
                        raw.append(CODE_COLOR);
                    } else {
                        raw.append(class_124.field_1070);
                    }
                    if (bold) {
                        raw.append(class_124.field_1067);
                    }
                    if (italic) {
                        raw.append(class_124.field_1056);
                    }
                    underline = false;
                    break;
                }
                case "code": {
                    raw.append(class_124.field_1070);
                    if (bold) {
                        raw.append(class_124.field_1067);
                    }
                    if (italic) {
                        raw.append(class_124.field_1056);
                    }
                    if (underline) {
                        raw.append(class_124.field_1073);
                    }
                    code = false;
                    break;
                }
                case "ul": 
                case "ol": {
                    listIndex = -1;
                    break;
                }
                case "dd": 
                case "li": 
                case "br": 
                case "p": {
                    raw.append("\n");
                }
            }
        }
        matcher.appendTail(raw);
        if (raw.isEmpty()) {
            return String.valueOf(class_124.field_1056) + class_1074.method_4662((String)"commands.cwiki.noContent", (Object[])new Object[0]);
        }
        String rawStr = raw.toString();
        rawStr = rawStr.replace("&quot;", "\"");
        rawStr = rawStr.replace("&#39;", "'");
        rawStr = rawStr.replace("&lt;", "<");
        rawStr = rawStr.replace("&gt;", ">");
        rawStr = rawStr.replace("&amp;", "&");
        return rawStr;
    }

    public static @Nullable String getWikiSummary(String pageName) {
        QueryResult result;
        URL url;
        try {
            String encodedPage = URLEncoder.encode(pageName, StandardCharsets.UTF_8);
            url = URI.create(String.format(PAGE_SUMMARY_QUERY, encodedPage)).toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        try (InputStream in = url.openConnection().getInputStream();){
            result = (QueryResult)GSON.fromJson((Reader)new InputStreamReader(in), QueryResult.class);
        }
        catch (IOException e) {
            return null;
        }
        if (result.query == null || result.query.pages == null || result.query.pages.isEmpty()) {
            return null;
        }
        QueryResult.Query.Page page = result.query.pages.values().iterator().next();
        if (page.missing != null || page.extract == null) {
            return null;
        }
        String html = page.extract;
        return WikiRetriever.decode(html);
    }

    private static class QueryResult {
        public @Nullable String batchcomplete;
        public @Nullable Query query;

        private QueryResult() {
        }

        private static class Query {
            private @Nullable Map<String, Page> pages;

            private Query() {
            }

            private static class Page {
                public int pageid;
                public @Nullable String title;
                public @Nullable String extract;
                public @Nullable String missing;

                private Page() {
                }
            }
        }
    }
}

