/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.mojang.logging.LogUtils;
import dev.xpple.simplewaypoints.SimpleWaypoints;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.earthcomputer.clientcommands.ClientCommands;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import org.slf4j.Logger;

public final class Waypoints {
    private static final Logger LOGGER = LogUtils.getLogger();

    private Waypoints() {
    }

    public static void migrateWaypoints() {
        boolean deleteOld;
        Path clientcommandsWaypointsPath = ClientCommands.CONFIG_DIR.resolve("waypoints.dat");
        if (!Files.isRegularFile(clientcommandsWaypointsPath, new LinkOption[0])) {
            return;
        }
        LOGGER.info("clientcommands' waypoints.dat file detected, will be migrated to SimpleWaypoints");
        Path clientcommandsOldWaypointsPath = ClientCommands.CONFIG_DIR.resolve("waypoints.dat_old");
        try {
            Files.copy(clientcommandsWaypointsPath, clientcommandsOldWaypointsPath, StandardCopyOption.REPLACE_EXISTING);
            deleteOld = true;
        }
        catch (IOException e) {
            LOGGER.error("Could not back up waypoints.dat file", (Throwable)e);
            deleteOld = false;
        }
        Path simplewaypointsWaypointsPath = SimpleWaypoints.MOD_CONFIG_PATH.resolve("waypoints.dat");
        if (Files.isRegularFile(simplewaypointsWaypointsPath, new LinkOption[0])) {
            LOGGER.info("SimpleWaypoints' waypoints.dat file already exists, clientcommands' waypoints.dat file will be merged");
            try {
                class_2487 clientcommandsCompoundTag = class_2507.method_10633((Path)clientcommandsWaypointsPath);
                class_2487 simplewaypointsCompoundTag = class_2507.method_10633((Path)simplewaypointsWaypointsPath);
                if (clientcommandsCompoundTag == null || simplewaypointsCompoundTag == null) {
                    throw new IOException("Could not parse clientcommands' or SimpleWaypoints' waypoint.dat file");
                }
                simplewaypointsCompoundTag.method_10543(clientcommandsCompoundTag);
                class_2507.method_10630((class_2487)simplewaypointsCompoundTag, (Path)simplewaypointsWaypointsPath);
            }
            catch (IOException e) {
                LOGGER.error("Could not merge waypoints.dat file", (Throwable)e);
            }
        } else {
            LOGGER.info("SimpleWaypoints' waypoints.dat does not exist yet, clientcommands' waypoints.dat file will be copied");
            try {
                Files.copy(clientcommandsWaypointsPath, simplewaypointsWaypointsPath, new CopyOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Could not migrate waypoints.dat file", (Throwable)e);
            }
        }
        if (deleteOld) {
            LOGGER.info("clientcommands's waypoint.dat will be deleted, waypoints.dat_old is kept");
            try {
                Files.delete(clientcommandsWaypointsPath);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete waypoints.dat file during migration", (Throwable)e);
            }
        }
    }
}

