/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalLong;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.event.ClientLevelEvents;
import net.earthcomputer.clientcommands.features.ChorusManipulation;
import net.earthcomputer.clientcommands.interfaces.ICreativeSlot;
import net.earthcomputer.clientcommands.util.CComponentUtil;
import net.earthcomputer.clientcommands.util.CUtil;
import net.earthcomputer.clientcommands.util.MultiVersionCompat;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_10124;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jspecify.annotations.Nullable;

public class PlayerRandCracker {
    public static final long MULTIPLIER = 25214903917L;
    public static final long ADDEND = 11L;
    public static final long MASK = 0xFFFFFFFFFFFFL;
    private static long seed;
    public static final Event<RNGCallListener> RNG_CALLED_EVENT;
    public static boolean isPredictingBlockBreaking;
    private static @Nullable Runnable postBlockBreakPredictAction;
    private static boolean isThrowItemsUntilThrowingItem;
    private static final @Nullable Field RANDOM_SEED;

    private static int next(int bits) {
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(seed >>> 48 - bits);
    }

    public static int nextInt() {
        return PlayerRandCracker.next(32);
    }

    public static int nextInt(int bound) {
        int val;
        int bits;
        if ((bound & -bound) == bound) {
            return (int)((long)bound * (long)PlayerRandCracker.next(31) >> 31);
        }
        while ((bits = PlayerRandCracker.next(31)) - (val = bits % bound) + (bound - 1) < 0) {
        }
        return val;
    }

    public static float nextFloat() {
        return (float)PlayerRandCracker.next(24) / 1.6777216E7f;
    }

    public static void setSeed(long seed) {
        PlayerRandCracker.seed = seed;
    }

    public static long getSeed() {
        return seed;
    }

    public static void registerEvents() {
        ClientLevelEvents.LOAD_LEVEL.register(level -> PlayerRandCracker.resetCracker(RNGCallType.RECREATED));
        RNG_CALLED_EVENT.register(PlayerRandCracker::throwItemsUntilOnRNGCallEvent);
    }

    public static void postSendBlockBreakingPredictionPacket() {
        if (postBlockBreakPredictAction != null) {
            postBlockBreakPredictAction.run();
            postBlockBreakPredictAction = null;
        }
    }

    public static void resetCracker(RNGCallType reason) {
        PlayerRandCracker.resetCracker(reason, true);
    }

    private static void resetCracker(RNGCallType reason, boolean isResettingUnconditionally) {
        if (isResettingUnconditionally) {
            ((RNGCallListener)RNG_CALLED_EVENT.invoker()).onCall(new RNGCallEvent(reason, false));
        }
        if (Configs.playerCrackState != CrackState.UNCRACKED) {
            ClientCommandHelper.sendError((class_2561)class_2561.method_43469((String)"playerManip.reset", (Object[])new Object[]{reason.resetMessage}));
            Configs.playerCrackState = CrackState.UNCRACKED;
        }
    }

    public static void onDropItem() {
        if (PlayerRandCracker.canMaintainPlayerRNG(RNGCallType.DROP_ITEM)) {
            for (int i = 0; i < 4; ++i) {
                PlayerRandCracker.nextInt();
            }
        } else {
            PlayerRandCracker.resetCracker(RNGCallType.DROP_ITEM, false);
        }
    }

    public static void onConsume(class_1799 stack, class_243 pos, int particleCount, int itemUseTimeLeft, class_10124 consumable) {
        RNGCallType callType;
        if (consumable.comp_3086() != class_1839.field_8950 && MultiVersionCompat.INSTANCE.getProtocolVersion() < 768) {
            return;
        }
        switch (consumable.comp_3086()) {
            case field_8950: {
                RNGCallType rNGCallType = RNGCallType.FOOD;
                break;
            }
            case field_8946: {
                RNGCallType rNGCallType = RNGCallType.DRINK;
                break;
            }
            default: {
                RNGCallType rNGCallType = callType = RNGCallType.CONSUME;
            }
        }
        if (PlayerRandCracker.canMaintainPlayerRNG(callType)) {
            int i;
            if (itemUseTimeLeft < 0 && particleCount != 16) {
                return;
            }
            for (i = 0; i < 3; ++i) {
                PlayerRandCracker.nextInt();
            }
            if (consumable.comp_3088()) {
                for (i = 0; i < particleCount * 3; ++i) {
                    PlayerRandCracker.nextInt();
                }
            }
            if (Configs.chorusManipulation && stack.method_7909() == class_1802.field_8233) {
                ChorusManipulation.onEat(pos, particleCount, itemUseTimeLeft);
                if (particleCount == 16) {
                    for (i = 0; i < 5; ++i) {
                        PlayerRandCracker.nextInt();
                    }
                }
            }
        } else {
            PlayerRandCracker.resetCracker(callType, false);
        }
    }

    public static void onEquipItem() {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() >= 766) {
            if (PlayerRandCracker.canMaintainPlayerRNG(RNGCallType.EQUIP_ITEM)) {
                PlayerRandCracker.nextInt();
                PlayerRandCracker.nextInt();
            } else {
                PlayerRandCracker.resetCracker(RNGCallType.EQUIP_ITEM, false);
            }
        }
    }

    public static void onAnvilUse() {
        if (PlayerRandCracker.canMaintainPlayerRNG(RNGCallType.ANVIL)) {
            PlayerRandCracker.nextInt();
        } else {
            PlayerRandCracker.resetCracker(RNGCallType.ANVIL, false);
        }
    }

    public static void onCrossbowUse() {
        if (PlayerRandCracker.canMaintainPlayerRNG(RNGCallType.CROSSBOW)) {
            if (MultiVersionCompat.INSTANCE.getProtocolVersion() <= 758) {
                PlayerRandCracker.nextInt();
            }
            PlayerRandCracker.nextInt();
        } else {
            PlayerRandCracker.resetCracker(RNGCallType.CROSSBOW, false);
        }
    }

    public static void onXpOrb() {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() >= 755) {
            PlayerRandCracker.resetCracker(RNGCallType.XP);
        }
    }

    public static void onBaneOfArthropods() {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() < 767) {
            if (PlayerRandCracker.canMaintainPlayerRNG(RNGCallType.BANE_OF_ARTHROPODS)) {
                PlayerRandCracker.nextInt();
            } else {
                PlayerRandCracker.resetCracker(RNGCallType.BANE_OF_ARTHROPODS, false);
            }
        }
    }

    private static void onUnbreaking(class_1799 stack, int amount, int unbreakingLevel) {
        if (PlayerRandCracker.canMaintainPlayerRNG(RNGCallType.UNBREAKING)) {
            for (int i = 0; i < amount; ++i) {
                boolean isArmor;
                class_10192 equippableComponent = (class_10192)stack.method_58694(class_9334.field_54196);
                boolean bl = isArmor = equippableComponent != null && equippableComponent.comp_3214();
                if (!isArmor || (double)PlayerRandCracker.nextFloat() >= 0.6) {
                    PlayerRandCracker.nextInt(unbreakingLevel + 1);
                    continue;
                }
                PlayerRandCracker.resetCracker(RNGCallType.UNBREAKING, false);
            }
        } else {
            PlayerRandCracker.resetCracker(RNGCallType.UNBREAKING, false);
        }
    }

    public static void onItemDamage(int amount, class_1309 holder, class_1799 stack) {
        boolean unbreakingCallsRandom;
        boolean bl = unbreakingCallsRandom = MultiVersionCompat.INSTANCE.getProtocolVersion() < 767;
        if (holder instanceof class_746) {
            class_746 player = (class_746)holder;
            if (!player.method_31549().field_7477 && stack.method_7963() && amount > 0) {
                int unbreakingLevel = CUtil.getEnchantmentLevel(holder.method_56673(), (class_5321<class_1887>)class_1893.field_9119, stack);
                if (unbreakingCallsRandom && unbreakingLevel > 0) {
                    PlayerRandCracker.onUnbreaking(stack, amount, unbreakingLevel);
                }
                PlayerRandCracker.handleToolBreakWarning(amount, stack, player);
                if (unbreakingCallsRandom && Configs.infiniteTools && Configs.playerCrackState.knowsSeed()) {
                    Runnable action = () -> {
                        ThrowItemsResult result = PlayerRandCracker.throwItemsUntil(rand -> {
                            for (int i = 0; i < amount; ++i) {
                                boolean isArmor;
                                class_10192 equippableComponent = (class_10192)stack.method_58694(class_9334.field_54196);
                                boolean bl = isArmor = equippableComponent != null && equippableComponent.comp_3214();
                                if (isArmor && (double)rand.nextFloat() < 0.6) {
                                    return false;
                                }
                                if (rand.nextInt(unbreakingLevel + 1) != 0) continue;
                                return false;
                            }
                            return true;
                        }, 64);
                        if (!result.isSuccess()) {
                            result.sendErrorMessage();
                        }
                    };
                    if (isPredictingBlockBreaking) {
                        postBlockBreakPredictAction = action;
                    } else {
                        action.run();
                    }
                }
            }
        }
    }

    public static void onItemDamageUncertain(int minAmount, int maxAmount, class_1309 holder, class_1799 stack) {
        boolean unbreakingCallsRandom;
        boolean bl = unbreakingCallsRandom = MultiVersionCompat.INSTANCE.getProtocolVersion() < 767;
        if (holder instanceof class_746) {
            class_746 player = (class_746)holder;
            if (!player.method_31549().field_7477 && stack.method_7963() && maxAmount > 0) {
                int unbreakingLevel = CUtil.getEnchantmentLevel(holder.method_56673(), (class_5321<class_1887>)class_1893.field_9119, stack);
                if (unbreakingCallsRandom && unbreakingLevel > 0) {
                    PlayerRandCracker.resetCracker(RNGCallType.UNBREAKING);
                }
                PlayerRandCracker.handleToolBreakWarning(maxAmount, stack, player);
            }
        }
    }

    private static void handleToolBreakWarning(int amount, class_1799 stack, class_746 player) {
        if (Configs.toolBreakWarning && stack.method_7919() + amount >= stack.method_7936() - 30) {
            if (stack.method_7919() + amount >= stack.method_7936() - 15) {
                player.method_5783(class_3417.field_14627, 10.0f, 0.1f);
            }
            class_5250 durability = class_2561.method_43470((String)String.valueOf(stack.method_7936() - stack.method_7919() - 1)).method_27692(class_124.field_1061);
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"playerManip.toolBreakWarning", (Object[])new Object[]{durability}).method_27692(class_124.field_1065), false);
        }
    }

    public static void onEnchantedItem() {
        if (PlayerRandCracker.canMaintainPlayerRNG(RNGCallType.ENCHANTING)) {
            PlayerRandCracker.nextInt();
        } else {
            PlayerRandCracker.resetCracker(RNGCallType.ENCHANTING, false);
        }
    }

    private static boolean canMaintainPlayerRNG(RNGCallType callType) {
        RNGCallEvent event = new RNGCallEvent(callType, Configs.playerRNGMaintenance && Configs.playerCrackState.knowsSeed());
        ((RNGCallListener)RNG_CALLED_EVENT.invoker()).onCall(event);
        if (event.isMaintained && Configs.playerCrackState.knowsSeed()) {
            Configs.playerCrackState = CrackState.CRACKED;
            return true;
        }
        return event.isMaintainedEvenIfSeedUnknown;
    }

    private static void throwItemsUntilOnRNGCallEvent(RNGCallEvent event) {
        if (isThrowItemsUntilThrowingItem && event.type == RNGCallType.DROP_ITEM) {
            event.setMaintained();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThrowItemsResult throwItemsUntil(Predicate<Random> condition, int max) {
        int i;
        int itemsNeeded;
        if (!Configs.playerCrackState.knowsSeed()) {
            return new ThrowItemsResult(ThrowItemsResult.Type.UNKNOWN_SEED, new Object[0]);
        }
        Configs.playerCrackState = CrackState.CRACKED;
        long seed = PlayerRandCracker.seed;
        Random rand = new Random(seed ^ 0x5DEECE66DL);
        for (itemsNeeded = 0; itemsNeeded <= max && !condition.test(rand); ++itemsNeeded) {
            for (i = 0; i < 4; ++i) {
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            }
            rand.setSeed(seed ^ 0x5DEECE66DL);
        }
        if (itemsNeeded > max) {
            return new ThrowItemsResult(ThrowItemsResult.Type.NOT_POSSIBLE, itemsNeeded);
        }
        for (i = 0; i < itemsNeeded; ++i) {
            ThrowItemsResult result;
            isThrowItemsUntilThrowingItem = true;
            try {
                result = PlayerRandCracker.throwItem();
            }
            finally {
                isThrowItemsUntilThrowingItem = false;
            }
            if (result.isSuccess()) continue;
            return result;
        }
        return new ThrowItemsResult(ThrowItemsResult.Type.SUCCESS, new Object[0]);
    }

    public static ThrowItemsResult throwItem() {
        boolean useCreativeThrow;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_636 interactionManager = mc.field_1761;
        assert (player != null && interactionManager != null);
        boolean isInContainer = mc.field_1755 instanceof class_465 && !(mc.field_1755 instanceof class_481);
        boolean bl = useCreativeThrow = player.method_56992() && !isInContainer;
        if (useCreativeThrow) {
            if (!player.method_64271()) {
                return new ThrowItemsResult(ThrowItemsResult.Type.THROTTLED, new Object[0]);
            }
            class_1799 stackToDrop = new class_1799((class_1935)class_1802.field_20412);
            player.method_7328(stackToDrop, true);
            interactionManager.method_2915(stackToDrop);
            return new ThrowItemsResult(ThrowItemsResult.Type.SUCCESS, new Object[0]);
        }
        class_1735 matchingSlot = PlayerRandCracker.getBestItemThrowSlot((List<class_1735>)player.field_7512.field_7761);
        if (matchingSlot == null) {
            return new ThrowItemsResult(ThrowItemsResult.Type.NOT_ENOUGH_ITEMS, new Object[0]);
        }
        interactionManager.method_2906(player.field_7512.field_7763, matchingSlot.field_7874, 0, class_1713.field_7795, (class_1657)player);
        return new ThrowItemsResult(ThrowItemsResult.Type.SUCCESS, new Object[0]);
    }

    public static void unthrowItem() {
        seed = seed * 241509987545585L + 40996489149244L & 0xFFFFFFFFFFFFL;
    }

    public static @Nullable class_1735 getBestItemThrowSlot(List<class_1735> slots) {
        slots = slots.stream().filter(slot -> {
            if (!slot.method_7681()) {
                return false;
            }
            if (slot instanceof ICreativeSlot) {
                return false;
            }
            if (class_1890.method_60142((class_1799)slot.method_7677(), (class_9331)class_9701.field_51656)) {
                return false;
            }
            return slot.method_7677().method_7909() != class_1802.field_8233;
        }).collect(Collectors.toList());
        HashMap<class_1792, Integer> itemCounts = new HashMap<class_1792, Integer>();
        for (class_1735 class_17352 : slots) {
            itemCounts.put(class_17352.method_7677().method_7909(), itemCounts.getOrDefault(class_17352.method_7677().method_7909(), 0) + class_17352.method_7677().method_7947());
        }
        if (itemCounts.isEmpty()) {
            return null;
        }
        class_1792 preferredItem = itemCounts.keySet().stream().max(Comparator.comparingInt(class_1792::method_7882).thenComparing(itemCounts::get)).get();
        return slots.stream().filter(slot -> slot.method_7677().method_7909() == preferredItem).findFirst().get();
    }

    public static OptionalLong getSeed(Random rand) {
        if (RANDOM_SEED == null) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(((AtomicLong)RANDOM_SEED.get(rand)).get());
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        Field randomSeedField;
        RNG_CALLED_EVENT = EventFactory.createArrayBacked(RNGCallListener.class, listeners -> event -> {
            for (RNGCallListener listener : listeners) {
                listener.onCall(event);
            }
        });
        isPredictingBlockBreaking = false;
        postBlockBreakPredictAction = null;
        isThrowItemsUntilThrowingItem = false;
        try {
            randomSeedField = Random.class.getDeclaredField("seed");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        try {
            randomSeedField.setAccessible(true);
        }
        catch (Exception e) {
            randomSeedField = null;
        }
        RANDOM_SEED = randomSeedField;
    }

    @FunctionalInterface
    public static interface RNGCallListener {
        public void onCall(RNGCallEvent var1);
    }

    public static enum RNGCallType {
        ADVANCEMENT("advancement"),
        AMETHYST_CHIME("amethystChime"),
        ANVIL("anvil"),
        BANE_OF_ARTHROPODS("baneOfArthropods"),
        CONSUME("consume"),
        CROSSBOW("crossbow"),
        DRINK("drink"),
        DROP_ITEM("dropItem"),
        ENCHANTING("enchanting"),
        ENTER_WATER("enterWater"),
        ENTITY_CRAMMING("entityCramming"),
        EQUIP_ITEM("equipItem"),
        FALL_FLYING("fallFlying"),
        FOOD("food"),
        FROST_WALKER("frostWalker"),
        GIVE("give"),
        ITEM_BREAK("itemBreak"),
        MENDING("mending"),
        PLAYER_HURT("playerHurt"),
        POTION("potion"),
        RECREATED("recreated"),
        RESPIRATION("respiration"),
        SHIELD("shield"),
        SHOULDER_PARROT("shoulderParrot"),
        SOUL_SPEED("soulSpeed"),
        SPRINT("sprint"),
        SWIM("swim"),
        UNBREAKING("unbreaking"),
        XP("xp");

        private final class_2561 resetMessage;

        private RNGCallType(String resetMessage) {
            this.resetMessage = class_2561.method_43471((String)("playerManip.reset." + resetMessage));
        }

        public class_2561 getResetMessage() {
            return this.resetMessage;
        }
    }

    public static final class RNGCallEvent {
        private final RNGCallType type;
        private boolean isMaintained;
        private boolean isMaintainedEvenIfSeedUnknown = false;

        public RNGCallEvent(RNGCallType type, boolean isMaintained) {
            this.type = type;
            this.isMaintained = isMaintained;
        }

        public RNGCallType getType() {
            return this.type;
        }

        public void setMaintained() {
            this.isMaintained = true;
        }

        public void setMaintainedEvenIfSeedUnknown() {
            this.isMaintainedEvenIfSeedUnknown = true;
        }
    }

    public static enum CrackState implements class_3542
    {
        UNCRACKED("uncracked"),
        CRACKED("cracked", true),
        ENCH_CRACKING_1("ench_cracking_1"),
        HALF_CRACKED("half_cracked"),
        ENCH_CRACKING_2("ench_cracking_2"),
        CRACKING("cracking"),
        EATING("eating");

        private final String name;
        private final boolean knowsSeed;

        private CrackState(String name) {
            this(name, false);
        }

        private CrackState(String name, boolean knowsSeed) {
            this.name = name;
            this.knowsSeed = knowsSeed;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean knowsSeed() {
            return this.knowsSeed;
        }
    }

    public static class ThrowItemsResult {
        private final Type type;
        private final Object[] messageArgs;

        public ThrowItemsResult(Type type, Object ... messageArgs) {
            this.type = type;
            this.messageArgs = messageArgs;
        }

        public boolean isSuccess() {
            return this.type.success;
        }

        public Type getType() {
            return this.type;
        }

        public void sendErrorMessage() {
            for (class_5250 message : this.type.messageCreator.apply(this.messageArgs)) {
                ClientCommandHelper.sendFeedback((class_2561)message);
            }
        }

        public static enum Type {
            NOT_ENOUGH_ITEMS(false, args -> List.of(class_2561.method_43469((String)"playerManip.notEnoughItems", (Object[])args).method_27692(class_124.field_1061), class_2561.method_43471((String)"playerManip.notEnoughItems.help").method_27692(class_124.field_1075))),
            NOT_POSSIBLE(false, "playerManip.throwError"),
            THROTTLED(false, args -> List.of(class_2561.method_43469((String)"playerManip.throttled", (Object[])args).method_27692(class_124.field_1061), class_2561.method_43471((String)"playerManip.throttled.help").method_27692(class_124.field_1075))),
            UNKNOWN_SEED(false, args -> List.of(class_2561.method_43471((String)"playerManip.uncracked").method_27693(" ").method_10852(CComponentUtil.getCommandTextComponent("commands.client.crack", "/ccrackrng")).method_27692(class_124.field_1061))),
            SUCCESS(true, (Function<Object[], List<class_5250>>)null);

            private final boolean success;
            private final Function<Object[], List<class_5250>> messageCreator;

            private Type(boolean success, String translationKey) {
                this(success, (Object[] args) -> List.of(class_2561.method_43469((String)translationKey, (Object[])args).method_27692(class_124.field_1061)));
            }

            private Type(boolean success, Function<Object[], List<class_5250>> messageCreator) {
                this.success = success;
                this.messageCreator = messageCreator;
            }
        }
    }
}

