/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_9334;
import net.minecraft.class_9889;
import org.jspecify.annotations.Nullable;

public enum LegacyEnchantment {
    PROTECTION((class_5321<class_1887>)class_1893.field_9111, 4, Weight.COMMON, 4, (class_6862<class_1792>)class_3489.field_48303, (class_6862<class_1792>)class_3489.field_48303, l -> 1 + (l - 1) * 11, l -> 1 + l * 11, new int[0]),
    FIRE_PROTECTION((class_5321<class_1887>)class_1893.field_9095, 4, Weight.UNCOMMON, 4, (class_6862<class_1792>)class_3489.field_48303, (class_6862<class_1792>)class_3489.field_48303, l -> 10 + (l - 1) * 8, l -> 10 + l * 8, new int[0]),
    FEATHER_FALLING((class_5321<class_1887>)class_1893.field_9129, 4, Weight.UNCOMMON, 4, (class_6862<class_1792>)class_3489.field_48299, (class_6862<class_1792>)class_3489.field_48299, l -> 5 + (l - 1) * 6, l -> 5 + l * 6, new int[0]),
    BLAST_PROTECTION((class_5321<class_1887>)class_1893.field_9107, 4, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48303, (class_6862<class_1792>)class_3489.field_48303, l -> 5 + (l - 1) * 8, l -> 5 + l * 8, new int[0]),
    PROJECTILE_PROTECTION((class_5321<class_1887>)class_1893.field_9096, 4, Weight.UNCOMMON, 4, (class_6862<class_1792>)class_3489.field_48303, (class_6862<class_1792>)class_3489.field_48303, l -> 3 + (l - 1) * 6, l -> 3 + l * 6, new int[0]),
    RESPIRATION((class_5321<class_1887>)class_1893.field_9127, 3, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48302, (class_6862<class_1792>)class_3489.field_48302, l -> l * 10, l -> 30 + l * 10, new int[0]),
    AQUA_AFFINITY((class_5321<class_1887>)class_1893.field_9105, 1, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48302, (class_6862<class_1792>)class_3489.field_48302, l -> 1, l -> 41, new int[0]),
    THORNS((class_5321<class_1887>)class_1893.field_9097, 3, Weight.VERY_RARE, 4, (class_6862<class_1792>)class_3489.field_48301, (class_6862<class_1792>)class_3489.field_48303, l -> 10 + (l - 1) * 20, l -> 40 + l * 20, new int[0]),
    DEPTH_STRIDER((class_5321<class_1887>)class_1893.field_9128, 3, Weight.RARE, 47, (class_6862<class_1792>)class_3489.field_48299, (class_6862<class_1792>)class_3489.field_48299, l -> l * 10, l -> 15 + l * 10, new int[0]),
    FROST_WALKER((class_5321<class_1887>)class_1893.field_9122, 2, Weight.RARE, 107, (class_6862<class_1792>)class_3489.field_48299, (class_6862<class_1792>)class_3489.field_48299, l -> l * 10, l -> 15 + l * 10, 1),
    BINDING_CURSE((class_5321<class_1887>)class_1893.field_9113, 1, Weight.VERY_RARE, 315, (class_6862<class_1792>)class_3489.field_48312, (class_6862<class_1792>)class_3489.field_48312, l -> 25, l -> 50, 1),
    SOUL_SPEED((class_5321<class_1887>)class_1893.field_23071, 3, Weight.VERY_RARE, 735, (class_6862<class_1792>)class_3489.field_48299, (class_6862<class_1792>)class_3489.field_48299, l -> l * 10, l -> 15 + l * 10, 1, 2),
    SHARPNESS((class_5321<class_1887>)class_1893.field_9118, 5, Weight.COMMON, 4, (class_6862<class_1792>)class_3489.field_63258, (class_6862<class_1792>)class_3489.field_50108, l -> 1 + (l - 1) * 11, l -> 21 + (l - 1) * 11, new int[0]),
    SMITE((class_5321<class_1887>)class_1893.field_9123, 5, Weight.UNCOMMON, 4, (class_6862<class_1792>)class_3489.field_63258, (class_6862<class_1792>)class_3489.field_48305, l -> 5 + (l - 1) * 8, l -> 25 + (l - 1) * 8, new int[0]),
    BANE_OF_ARTHROPODS((class_5321<class_1887>)class_1893.field_9112, 5, Weight.UNCOMMON, 4, (class_6862<class_1792>)class_3489.field_63258, (class_6862<class_1792>)class_3489.field_48305, l -> 5 + (l - 1) * 8, l -> 25 + (l - 1) * 8, new int[0]),
    KNOCKBACK((class_5321<class_1887>)class_1893.field_9121, 2, Weight.UNCOMMON, 4, (class_6862<class_1792>)class_3489.field_63258, (class_6862<class_1792>)class_3489.field_63258, l -> 5 + (l - 1) * 20, l -> 55 + (l - 1) * 20, new int[0]),
    FIRE_ASPECT((class_5321<class_1887>)class_1893.field_9124, 2, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_63258, (class_6862<class_1792>)class_3489.field_50107, l -> 10 + (l - 1) * 20, l -> 40 + l * 20, new int[0]),
    LOOTING((class_5321<class_1887>)class_1893.field_9110, 3, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_63258, (class_6862<class_1792>)class_3489.field_63258, l -> 15 + (l - 1) * 9, l -> 65 + (l - 1) * 9, new int[0]),
    SWEEPING_EDGE((class_5321<class_1887>)class_1893.field_9115, 3, Weight.RARE, 316, (class_6862<class_1792>)class_3489.field_63258, (class_6862<class_1792>)class_3489.field_63258, l -> 5 + (l - 1) * 9, l -> 20 + (l - 1) * 9, new int[0]),
    EFFICIENCY((class_5321<class_1887>)class_1893.field_9131, 5, Weight.COMMON, 4, (class_6862<class_1792>)class_3489.field_48306, (class_6862<class_1792>)class_3489.field_48306, l -> 1 + (l - 1) * 10, l -> 50 + l * 10, new int[0]),
    SILK_TOUCH((class_5321<class_1887>)class_1893.field_9099, 1, Weight.VERY_RARE, 4, (class_6862<class_1792>)class_3489.field_48307, (class_6862<class_1792>)class_3489.field_48307, l -> 15, l -> 65, new int[0]),
    UNBREAKING((class_5321<class_1887>)class_1893.field_9119, 3, Weight.UNCOMMON, 4, (class_6862<class_1792>)class_3489.field_48310, (class_6862<class_1792>)class_3489.field_48310, l -> 5 + (l - 1) * 8, l -> 55 + (l - 1) * 8, new int[0]),
    FORTUNE((class_5321<class_1887>)class_1893.field_9130, 3, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48307, (class_6862<class_1792>)class_3489.field_48307, l -> 15 + (l - 1) * 9, l -> 65 + (l - 1) * 9, new int[0]),
    POWER((class_5321<class_1887>)class_1893.field_9103, 5, Weight.COMMON, 4, (class_6862<class_1792>)class_3489.field_48311, (class_6862<class_1792>)class_3489.field_48311, l -> 1 + (l - 1) * 10, l -> 16 + (l - 1) * 10, new int[0]),
    PUNCH((class_5321<class_1887>)class_1893.field_9116, 2, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48311, (class_6862<class_1792>)class_3489.field_48311, l -> 12 + (l - 1) * 20, l -> 37 + (l - 1) * 20, new int[0]),
    FLAME((class_5321<class_1887>)class_1893.field_9126, 1, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48311, (class_6862<class_1792>)class_3489.field_48311, l -> 20, l -> 50, new int[0]),
    INFINITY((class_5321<class_1887>)class_1893.field_9125, 1, Weight.VERY_RARE, 4, (class_6862<class_1792>)class_3489.field_48311, (class_6862<class_1792>)class_3489.field_48311, l -> 20, l -> 50, new int[0]),
    LUCK_OF_THE_SEA((class_5321<class_1887>)class_1893.field_9114, 3, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48308, (class_6862<class_1792>)class_3489.field_48308, l -> 15 + (l - 1) * 9, l -> 65 + (l - 1) * 9, new int[0]),
    LURE((class_5321<class_1887>)class_1893.field_9100, 3, Weight.RARE, 4, (class_6862<class_1792>)class_3489.field_48308, (class_6862<class_1792>)class_3489.field_48308, l -> 15 + (l - 1) * 9, l -> 65 + (l - 1) * 9, new int[0]),
    LOYALTY((class_5321<class_1887>)class_1893.field_9120, 3, Weight.UNCOMMON, 393, (class_6862<class_1792>)class_3489.field_48309, (class_6862<class_1792>)class_3489.field_48309, l -> 5 + l * 7, l -> 50, new int[0]),
    IMPALING((class_5321<class_1887>)class_1893.field_9106, 5, Weight.RARE, 393, (class_6862<class_1792>)class_3489.field_48309, (class_6862<class_1792>)class_3489.field_48309, l -> 1 + (l - 1) * 8, l -> 21 + (l - 1) * 8, new int[0]),
    RIPTIDE((class_5321<class_1887>)class_1893.field_9104, 3, Weight.RARE, 393, (class_6862<class_1792>)class_3489.field_48309, (class_6862<class_1792>)class_3489.field_48309, l -> 10 + l * 7, l -> 50, new int[0]),
    CHANNELING((class_5321<class_1887>)class_1893.field_9117, 1, Weight.VERY_RARE, 393, (class_6862<class_1792>)class_3489.field_48309, (class_6862<class_1792>)class_3489.field_48309, l -> 25, l -> 50, new int[0]),
    MULTISHOT((class_5321<class_1887>)class_1893.field_9108, 1, Weight.RARE, 477, (class_6862<class_1792>)class_3489.field_48313, (class_6862<class_1792>)class_3489.field_48313, l -> 20, l -> 50, new int[0]),
    QUICK_CHARGE((class_5321<class_1887>)class_1893.field_9098, 3, Weight.UNCOMMON, 477, (class_6862<class_1792>)class_3489.field_48313, (class_6862<class_1792>)class_3489.field_48313, l -> 12 + (l - 1) * 20, l -> 50, new int[0]),
    PIERCING((class_5321<class_1887>)class_1893.field_9132, 4, Weight.COMMON, 477, (class_6862<class_1792>)class_3489.field_48313, (class_6862<class_1792>)class_3489.field_48313, l -> 1 + (l - 1) * 10, l -> 50, new int[0]),
    MENDING((class_5321<class_1887>)class_1893.field_9101, 1, Weight.RARE, 107, (class_6862<class_1792>)class_3489.field_48310, (class_6862<class_1792>)class_3489.field_48310, l -> 25, l -> 75, 1),
    VANISHING_CURSE((class_5321<class_1887>)class_1893.field_9109, 1, Weight.VERY_RARE, 315, (class_6862<class_1792>)class_3489.field_48314, (class_6862<class_1792>)class_3489.field_48314, l -> 25, l -> 50, 1);

    private static final LegacyEnchantment[] VALUES;
    private static final Map<class_5321<class_1887>, LegacyEnchantment> BY_KEY;
    private static final EnumMap<LegacyEnchantment, ExclusiveSet> EXCLUSIVE_SETS;
    public final class_5321<class_1887> enchantmentKey;
    public final class_2561 displayName;
    public final int maxLevel;
    private final Weight weight;
    public final int introducedVersion;
    public final class_6862<class_1792> primaryItems;
    public final class_6862<class_1792> supportedItems;
    private final IntUnaryOperator minEnchantability;
    private final IntUnaryOperator maxEnchantability;
    private final int flags;

    private LegacyEnchantment(class_5321<class_1887> enchantmentKey, int maxLevel, Weight weight, int introducedVersion, class_6862<class_1792> primaryItems, class_6862<class_1792> supportedItems, IntUnaryOperator minEnchantability, IntUnaryOperator maxEnchantability, int ... flags) {
        this.enchantmentKey = enchantmentKey;
        this.displayName = class_2561.method_43471((String)enchantmentKey.method_29177().method_42093("enchantment"));
        this.maxLevel = maxLevel;
        this.weight = weight;
        this.introducedVersion = introducedVersion;
        this.primaryItems = primaryItems;
        this.supportedItems = supportedItems;
        this.minEnchantability = minEnchantability;
        this.maxEnchantability = maxEnchantability;
        int combinedFlags = 0;
        for (int flag : flags) {
            combinedFlags |= flag;
        }
        this.flags = combinedFlags;
    }

    public static @Nullable LegacyEnchantment byEnchantmentKey(class_5321<class_1887> enchantmentKey) {
        return BY_KEY.get(enchantmentKey);
    }

    public boolean isTreasure() {
        return (this.flags & 1) != 0;
    }

    public boolean isDiscoverable() {
        return (this.flags & 2) == 0;
    }

    public boolean inEnchantmentTable() {
        return !this.isTreasure() && this.isDiscoverable();
    }

    public boolean isCompatible(LegacyEnchantment other, int version) {
        ExclusiveSet set = EXCLUSIVE_SETS.get((Object)this);
        if (set == null) {
            return true;
        }
        if (set.ignoreOnVersions != null && set.ignoreOnVersions.method_9054(version)) {
            return true;
        }
        return !set.set.contains((Object)other);
    }

    private static List<Instance> getHighestAllowedEnchantments(int level, class_1799 item, boolean treasure, int version) {
        ArrayList<Instance> allowedEnchantments = new ArrayList<Instance>();
        block0: for (LegacyEnchantment enchantment : VALUES) {
            if (version < enchantment.introducedVersion || !treasure && enchantment.isTreasure() || !item.method_31573(enchantment.primaryItems)) continue;
            for (int enchLevel = enchantment.maxLevel; enchLevel >= 1; --enchLevel) {
                if (level < enchantment.minEnchantability.applyAsInt(enchLevel) || level > enchantment.maxEnchantability.applyAsInt(enchLevel)) continue;
                allowedEnchantments.add(new Instance(enchantment, enchLevel));
                continue block0;
            }
        }
        return allowedEnchantments;
    }

    public static List<Instance> addRandomEnchantments(class_5819 rand, class_1799 item, int level, boolean treasure, int version) {
        List<Instance> allowedEnchantments;
        class_9889 enchantable = (class_9889)item.method_58694(class_9334.field_53695);
        int enchantability = enchantable == null ? 0 : enchantable.comp_2938();
        ArrayList<Instance> enchantments = new ArrayList<Instance>();
        if (enchantability <= 0) {
            return enchantments;
        }
        level = level + 1 + rand.method_43048(enchantability / 4 + 1) + rand.method_43048(enchantability / 4 + 1);
        float percentChange = (rand.method_43057() + rand.method_43057() - 1.0f) * 0.15f;
        if ((level += Math.round((float)level * percentChange)) < 1) {
            level = 1;
        }
        if ((allowedEnchantments = LegacyEnchantment.getHighestAllowedEnchantments(level, item, treasure, version)).isEmpty()) {
            return enchantments;
        }
        Instance enchantmentInstance = LegacyEnchantment.getRandomEnchantment(rand, allowedEnchantments, version);
        if (enchantmentInstance == null) {
            return enchantments;
        }
        enchantments.add(enchantmentInstance);
        while (rand.method_43048(50) <= level) {
            if (version >= 477 && version <= 485) {
                level = level * 4 / 5 + 1;
                allowedEnchantments = LegacyEnchantment.getHighestAllowedEnchantments(level, item, treasure, version);
                for (Instance ench : enchantments) {
                    allowedEnchantments.removeIf(it -> !it.ench.isCompatible(ench.ench, version));
                }
            } else {
                allowedEnchantments.removeIf(it -> !it.ench.isCompatible(((Instance)enchantments.getLast()).ench, version));
            }
            if (allowedEnchantments.isEmpty() || (enchantmentInstance = LegacyEnchantment.getRandomEnchantment(rand, allowedEnchantments, version)) == null) break;
            enchantments.add(enchantmentInstance);
            level /= 2;
        }
        return enchantments;
    }

    private static @Nullable Instance getRandomEnchantment(class_5819 rand, List<Instance> list, int version) {
        int weight = list.stream().mapToInt(ench -> ench.ench.weight.getValue(version)).sum();
        if (weight <= 0) {
            return null;
        }
        weight = rand.method_43048(weight);
        for (Instance ench2 : list) {
            if ((weight -= ench2.ench.weight.getValue(version)) >= 0) continue;
            return ench2;
        }
        return null;
    }

    static {
        VALUES = LegacyEnchantment.values();
        BY_KEY = (Map)class_156.method_654(new HashMap(VALUES.length), map -> {
            for (LegacyEnchantment ench : VALUES) {
                map.put(ench.enchantmentKey, ench);
            }
        });
        EXCLUSIVE_SETS = (EnumMap)class_156.method_654(new EnumMap(LegacyEnchantment.class), map -> {
            map.put(INFINITY, new ExclusiveSet(EnumSet.of(MENDING), class_2096.class_2100.method_35289((int)315)));
            map.put(MENDING, new ExclusiveSet(EnumSet.of(INFINITY), class_2096.class_2100.method_35289((int)315)));
            map.put(SHARPNESS, new ExclusiveSet(EnumSet.of(SMITE, BANE_OF_ARTHROPODS), null));
            map.put(SMITE, new ExclusiveSet(EnumSet.of(SHARPNESS, BANE_OF_ARTHROPODS), null));
            map.put(BANE_OF_ARTHROPODS, new ExclusiveSet(EnumSet.of(SHARPNESS, SMITE), null));
            map.put(DEPTH_STRIDER, new ExclusiveSet(EnumSet.of(FROST_WALKER), null));
            map.put(FROST_WALKER, new ExclusiveSet(EnumSet.of(DEPTH_STRIDER), null));
            map.put(SILK_TOUCH, new ExclusiveSet(EnumSet.of(LOOTING, FORTUNE, LUCK_OF_THE_SEA), null));
            map.put(LOOTING, new ExclusiveSet(EnumSet.of(SILK_TOUCH), null));
            map.put(FORTUNE, new ExclusiveSet(EnumSet.of(SILK_TOUCH), null));
            map.put(LUCK_OF_THE_SEA, new ExclusiveSet(EnumSet.of(SILK_TOUCH), null));
            map.put(RIPTIDE, new ExclusiveSet(EnumSet.of(LOYALTY, CHANNELING), null));
            map.put(LOYALTY, new ExclusiveSet(EnumSet.of(RIPTIDE), null));
            map.put(CHANNELING, new ExclusiveSet(EnumSet.of(RIPTIDE), null));
            map.put(MULTISHOT, new ExclusiveSet(EnumSet.of(PIERCING), null));
            map.put(PIERCING, new ExclusiveSet(EnumSet.of(MULTISHOT), null));
            map.put(PROTECTION, new ExclusiveSet(EnumSet.of(BLAST_PROTECTION, FIRE_PROTECTION, PROJECTILE_PROTECTION), class_2096.class_2100.method_35287((int)477, (int)485)));
            map.put(BLAST_PROTECTION, new ExclusiveSet(EnumSet.of(PROTECTION, FIRE_PROTECTION, PROJECTILE_PROTECTION), class_2096.class_2100.method_35287((int)477, (int)485)));
            map.put(FIRE_PROTECTION, new ExclusiveSet(EnumSet.of(PROTECTION, BLAST_PROTECTION, PROJECTILE_PROTECTION), class_2096.class_2100.method_35287((int)477, (int)485)));
            map.put(PROJECTILE_PROTECTION, new ExclusiveSet(EnumSet.of(PROTECTION, BLAST_PROTECTION, FIRE_PROTECTION), class_2096.class_2100.method_35287((int)477, (int)485)));
        });
    }

    private static enum Weight {
        COMMON(10, 30),
        UNCOMMON(5, 10),
        RARE(2, 3),
        VERY_RARE(1, 1);

        private final int value;
        private final int value114;

        private Weight(int value, int value114) {
            this.value = value;
            this.value114 = value114;
        }

        int getValue(int version) {
            return version >= 477 && version <= 485 ? this.value114 : this.value;
        }
    }

    private static class Flags {
        static final int TREASURE = 1;
        static final int NON_DISCOVERABLE = 2;

        private Flags() {
        }
    }

    private record ExclusiveSet(EnumSet<LegacyEnchantment> set, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_2096.class_2100 ignoreOnVersions) {
    }

    public record Instance(LegacyEnchantment ench, int level) {
    }
}

