/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.seedfinding.mcfeature.loot.LootContext;
import com.seedfinding.mcfeature.loot.LootGenerator;
import com.seedfinding.mcfeature.loot.LootPool;
import com.seedfinding.mcfeature.loot.LootTable;
import com.seedfinding.mcfeature.loot.MCLootTables;
import com.seedfinding.mcfeature.loot.condition.BiomeCondition;
import com.seedfinding.mcfeature.loot.condition.LootCondition;
import com.seedfinding.mcfeature.loot.condition.OpenWaterCondition;
import com.seedfinding.mcfeature.loot.entry.ItemEntry;
import com.seedfinding.mcfeature.loot.entry.LootEntry;
import com.seedfinding.mcfeature.loot.entry.TableEntry;
import com.seedfinding.mcfeature.loot.item.ItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.PingCommand;
import net.earthcomputer.clientcommands.command.arguments.ClientItemPredicateArgument;
import net.earthcomputer.clientcommands.command.arguments.WithStringArgument;
import net.earthcomputer.clientcommands.event.MoreClientEntityEvents;
import net.earthcomputer.clientcommands.event.MoreClientEvents;
import net.earthcomputer.clientcommands.render.RenderQueue;
import net.earthcomputer.clientcommands.task.LongTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.earthcomputer.clientcommands.util.CUtil;
import net.earthcomputer.clientcommands.util.SeedfindingUtil;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2886;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.jspecify.annotations.Nullable;

public class FishingCracker {
    public static final List<WithStringArgument.Result<ClientItemPredicateArgument.ClientItemPredicate>> goals = new ArrayList<WithStringArgument.Result<ClientItemPredicateArgument.ClientItemPredicate>>();
    private static boolean hasWarnedMultipleEnchants = false;
    private static class_1799 actualLoot;
    private static final Catch[] expectedCatches;
    private static class_1799 tool;
    private static class_243 bobberDestPos;
    private static int bobberNumTicks;
    public static final int RETHROW_COOLDOWN = 20;
    private static volatile long throwTime;
    private static long bobberStartTime;
    private static int totalTicksToWait;
    private static int estimatedTicksElapsed;
    private static final long[] timeSyncTimes;
    private static int serverMspt;
    private static volatile int averageTimeToEndOfTick;
    private static volatile int magicMillisecondsCorrection;
    private static final ScheduledExecutorService DELAY_EXECUTOR;
    public static volatile State state;
    private static final Object STATE_LOCK;
    private static int expectedFishingRodUses;

    private static boolean isMatchingLoot(class_1799 loot, ClientItemPredicateArgument.ClientItemPredicate goal) {
        return goal.getPossibleItems().contains(loot.method_7909());
    }

    private static List<ItemStack> generateAllMatchingLoot(class_5455 registryAccess, LootTable table, @Nullable LootContext context, ClientItemPredicateArgument.ClientItemPredicate goal, Consumer<LootCondition> failedConditions) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (LootPool lootPool : table.lootPools) {
            result.addAll(FishingCracker.generateAllMatchingLootForPool(registryAccess, lootPool, context, goal, failedConditions));
        }
        if (!result.isEmpty() && !FishingCracker.checkConditions(table, context, failedConditions)) {
            return Collections.emptyList();
        }
        return result;
    }

    private static List<ItemStack> generateAllMatchingLootForPool(class_5455 registryAccess, LootPool pool, @Nullable LootContext context, ClientItemPredicateArgument.ClientItemPredicate goal, Consumer<LootCondition> failedConditions) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (LootEntry lootEntry : pool.lootEntries) {
            result.addAll(FishingCracker.generateAllMatchingLootForEntry(registryAccess, lootEntry, context, goal, failedConditions));
        }
        if (!result.isEmpty() && !FishingCracker.checkConditions(pool, context, failedConditions)) {
            return Collections.emptyList();
        }
        return result;
    }

    private static List<ItemStack> generateAllMatchingLootForEntry(class_5455 registryAccess, LootEntry entry, @Nullable LootContext context, ClientItemPredicateArgument.ClientItemPredicate goal, Consumer<LootCondition> failedConditions) {
        List<ItemStack> result = Collections.emptyList();
        if (entry instanceof ItemEntry) {
            ItemEntry itemEntry = (ItemEntry)entry;
            if (FishingCracker.isMatchingLoot(SeedfindingUtil.fromSeedfindingItem(itemEntry.item, registryAccess), goal)) {
                result = Collections.singletonList(new ItemStack(itemEntry.item));
            }
        } else if (entry instanceof TableEntry) {
            TableEntry tableEntry = (TableEntry)entry;
            result = FishingCracker.generateAllMatchingLoot(registryAccess, tableEntry.table.get().apply(SeedfindingUtil.getMCVersion()), context, goal, failedConditions);
        }
        if (!result.isEmpty() && !FishingCracker.checkConditions(entry, context, failedConditions)) {
            return Collections.emptyList();
        }
        return result;
    }

    private static boolean checkConditions(LootGenerator generator, @Nullable LootContext context, Consumer<LootCondition> failedConditions) {
        if (context == null || generator.lootConditions == null) {
            return true;
        }
        boolean result = true;
        for (LootCondition condition : generator.lootConditions) {
            if (condition.is_valid(context)) continue;
            result = false;
            failedConditions.accept(condition);
        }
        return result;
    }

    private static OptionalLong getSeed(UUID uuid) {
        long uuidLower = uuid.getLeastSignificantBits();
        long hi = 0L;
        do {
            class_5819 rand;
            long b;
            long lowerBits;
            long nextLongOutput;
            long upperBits;
            long a;
            long seed;
            if (((seed = 7847617L * (a = 24667315L * (upperBits = (nextLongOutput = hi | uuidLower & 0x3FFFFFFFFFFFFFFFL) >>> 32) + 18218081L * (lowerBits = nextLongOutput & 0xFFFFFFFFL) + 67552711L >> 32) - 18218081L * (b = -4824621L * upperBits + 7847617L * lowerBits + 7847617L >> 32)) >>> 16 << 32) + (long)((int)((seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) >>> 16)) != nextLongOutput || !class_3532.method_15378((class_5819)(rand = class_5819.method_43049((long)((seed = seed * 21586261248413L + 164331561754775L & 0xFFFFFFFFFFFFL) ^ 0x5DEECE66DL)))).equals(uuid)) continue;
            return OptionalLong.of(seed);
        } while ((hi += 0x4000000000000000L) != 0L);
        return OptionalLong.empty();
    }

    private static boolean internalInteractFishingBobber() {
        class_1799 stack;
        class_746 player = class_310.method_1551().field_1724;
        class_636 gameMode = class_310.method_1551().field_1761;
        if (player != null && gameMode != null && (stack = player.method_6047()).method_7909() == class_1802.field_8378) {
            ++expectedFishingRodUses;
            gameMode.method_2919((class_1657)player, class_1268.field_5808);
            return true;
        }
        return false;
    }

    public static boolean retractFishingBobber() {
        return FishingCracker.internalInteractFishingBobber();
    }

    public static boolean throwFishingBobber() {
        if (FishingCracker.internalInteractFishingBobber()) {
            class_746 player = class_310.method_1551().field_1724;
            assert (player != null);
            class_1799 stack = player.method_6047();
            FishingCracker.handleFishingRodThrow(stack);
            return true;
        }
        return false;
    }

    public static boolean canManipulateFishing() {
        return Configs.fishingManipulation.isEnabled() && !goals.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleFishingRodThrow(class_1799 stack) {
        long time = System.nanoTime();
        Object object = STATE_LOCK;
        synchronized (object) {
            throwTime = time;
            estimatedTicksElapsed = 0;
            state = State.WAITING_FOR_BOBBER;
        }
        tool = stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = STATE_LOCK;
        synchronized (object) {
            state = State.NOT_MANIPULATING;
            if (FishingCracker.canManipulateFishing() && Configs.fishingManipulation == Configs.FishingManipulation.AFK) {
                state = State.WAITING_FOR_RETRHOW;
                TaskManager.addNonConflictingTask("cfishRethrow", new LongTask(){
                    private int counter;

                    @Override
                    public void initialize() {
                        this.counter = 20;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean condition() {
                        Object object = STATE_LOCK;
                        synchronized (object) {
                            return this.counter > 0 && state == State.WAITING_FOR_RETRHOW;
                        }
                    }

                    @Override
                    public void increment() {
                        --this.counter;
                    }

                    @Override
                    public void body() {
                        this.scheduleDelay();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCompleted() {
                        Object object = STATE_LOCK;
                        synchronized (object) {
                            state = FishingCracker.throwFishingBobber() ? State.WAITING_FOR_BOBBER : State.NOT_MANIPULATING;
                        }
                    }
                });
            }
        }
    }

    public static void registerEvents() {
        MoreClientEntityEvents.POST_ADD.register(packet -> {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && FishingCracker.canManipulateFishing() && packet.method_11166() == player.method_5628() && packet.method_11169() == class_1299.field_6103) {
                FishingCracker.processBobberSpawn(packet.method_11164(), new class_243(packet.method_11175(), packet.method_11174(), packet.method_11176()), packet.method_73084());
            }
        });
        MoreClientEntityEvents.PRE_ADD_MAYBE_ON_NETWORK_THREAD.register(packet -> {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            if (!FishingCracker.canManipulateFishing() || packet.method_11166() != player.method_5628() || packet.method_11169() != class_1299.field_6103) {
                return;
            }
            FishingCracker.onFishingBobberEntity();
        });
        MoreClientEntityEvents.POST_SET_INITIAL_XP_ORB_VALUE.register(orb -> {
            if (FishingCracker.canManipulateFishing()) {
                FishingCracker.processExperienceOrbSpawn(orb.method_23317(), orb.method_23318(), orb.method_23321(), orb.method_5919());
            }
        });
        MoreClientEvents.TIME_SYNC_ON_NETWORK_THREAD.register(packet -> {
            if (Configs.fishingManipulation.isEnabled()) {
                FishingCracker.onTimeSync();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processBobberSpawn(UUID fishingBobberUUID, class_243 pos, class_243 velocity) {
        record ErrorEntry(int tick, boolean isBox) {
        }
        Object object = STATE_LOCK;
        synchronized (object) {
            if (state != State.WAITING_FOR_FIRST_BOBBER_TICK) {
                return;
            }
            state = State.WAITING_FOR_FISH;
        }
        class_638 level = class_310.method_1551().field_1687;
        assert (level != null);
        OptionalLong optionalSeed = FishingCracker.getSeed(fishingBobberUUID);
        if (optionalSeed.isEmpty()) {
            class_5250 error = class_2561.method_43471((String)"commands.cfish.error.crackFailed").method_27694(style -> style.method_10977(class_124.field_1061));
            ClientCommandHelper.addOverlayMessage((class_2561)error, 100);
            FishingCracker.reset();
            return;
        }
        for (int tick = 0; tick <= bobberNumTicks; ++tick) {
            RenderQueue.remove(RenderQueue.Layer.ON_TOP, new ErrorEntry(tick, false));
            RenderQueue.remove(RenderQueue.Layer.ON_TOP, new ErrorEntry(tick, true));
        }
        bobberNumTicks = 0;
        long seed = optionalSeed.getAsLong();
        SimulatedFishingBobber fishingBobber = new SimulatedFishingBobber(seed, tool, pos, velocity);
        boolean wasCatchingFish = false;
        int ticksUntilOurItem = -1;
        ArrayList<Catch> possibleExpectedCatches = new ArrayList<Catch>();
        int ourExpectedCatchIndex = -1;
        ArrayList<class_243> bobberPositions = new ArrayList<class_243>();
        bobberPositions.add(pos);
        for (int ticks = 0; ticks < 10000; ++ticks) {
            fishingBobber.tick();
            bobberPositions.add(fishingBobber.pos);
            if (fishingBobber.failedReason != null) {
                bobberNumTicks = ticks;
                for (int i = 0; i < bobberPositions.size(); ++i) {
                    int color = i == bobberPositions.size() - 1 ? 0xFF0000 : 65280;
                    RenderQueue.addCuboid(RenderQueue.Layer.ON_TOP, new ErrorEntry(i, true), SimulatedFishingBobber.FISHING_BOBBER_DIMENSIONS.method_30757((class_243)bobberPositions.get(i)), color, 100);
                    if (i == 0) continue;
                    RenderQueue.addLine(RenderQueue.Layer.ON_TOP, new ErrorEntry(i, false), (class_243)bobberPositions.get(i - 1), (class_243)bobberPositions.get(i), color, 100);
                }
                class_5250 error = class_2561.method_43471((String)("commands.cfish.error." + fishingBobber.failedReason)).method_27694(style -> style.method_10977(class_124.field_1061));
                ClientCommandHelper.addOverlayMessage((class_2561)error, 100);
                FishingCracker.reset();
                return;
            }
            if (fishingBobber.canCatchFish()) {
                List<Catch> catches = fishingBobber.generateLoot();
                if (ourExpectedCatchIndex == -1 && goals.stream().anyMatch(goal -> catches.stream().anyMatch(c -> ((ClientItemPredicateArgument.ClientItemPredicate)goal.value()).test(c.loot)))) {
                    bobberDestPos = fishingBobber.pos;
                    ticksUntilOurItem = ticks;
                    ourExpectedCatchIndex = possibleExpectedCatches.size();
                }
                possibleExpectedCatches.add(catches.getFirst());
                wasCatchingFish = true;
                continue;
            }
            if (!wasCatchingFish) continue;
            bobberNumTicks = ticks;
            break;
        }
        if (ticksUntilOurItem == -1) {
            class_5250 error;
            HashSet failedConditions = new HashSet();
            boolean impossible = true;
            LootTable fishingLootTable = MCLootTables.FISHING.get().apply(SeedfindingUtil.getMCVersion());
            for (WithStringArgument.Result<ClientItemPredicateArgument.ClientItemPredicate> goal2 : goals) {
                ClientItemPredicateArgument.EnchantedItemPredicate predicate;
                ClientItemPredicateArgument.ClientItemPredicate clientItemPredicate = goal2.value();
                if (clientItemPredicate instanceof ClientItemPredicateArgument.EnchantedItemPredicate && (predicate = (ClientItemPredicateArgument.EnchantedItemPredicate)clientItemPredicate).isEnchantedBook() && predicate.predicate.numEnchantments() >= 2 && !hasWarnedMultipleEnchants) {
                    ClientCommandHelper.sendHelp((class_2561)class_2561.method_43471((String)"commands.cfish.help.tooManyEnchants"));
                    hasWarnedMultipleEnchants = true;
                }
                impossible &= FishingCracker.generateAllMatchingLoot(level.method_30349(), fishingLootTable, fishingBobber.getLootContext(), goal2.value(), failedConditions::add).isEmpty();
            }
            if (impossible && failedConditions.isEmpty()) {
                error = class_2561.method_43471((String)"commands.cfish.error.impossibleLoot").method_27694(style -> style.method_10977(class_124.field_1061));
                ClientCommandHelper.addOverlayMessage((class_2561)error, 100);
                FishingCracker.reset();
                return;
            }
            if (!failedConditions.isEmpty()) {
                if (failedConditions.stream().anyMatch(it -> it instanceof OpenWaterCondition)) {
                    error = class_2561.method_43471((String)"commands.cfish.error.openWater").method_27694(style -> style.method_10977(class_124.field_1061));
                    ClientCommandHelper.addOverlayMessage((class_2561)error, 100);
                    if (!fishingBobber.level.method_8320(class_2338.method_49638((class_2374)fishingBobber.pos).method_10084()).method_27852(class_2246.field_10588)) {
                        ClientCommandHelper.sendHelp((class_2561)class_2561.method_43471((String)"commands.cfish.error.openWater.lilyPad"));
                    }
                    boolean foundFlowingWater = false;
                    for (class_2338 openWaterViolation : fishingBobber.openWaterViolations) {
                        if (!foundFlowingWater && fishingBobber.level.method_8320(openWaterViolation).method_27852(class_2246.field_10382) && !fishingBobber.level.method_8316(openWaterViolation).method_15771()) {
                            foundFlowingWater = true;
                        }
                        RenderQueue.addCuboid(RenderQueue.Layer.ON_TOP, UUID.randomUUID(), class_243.method_24954((class_2382)openWaterViolation), class_243.method_24954((class_2382)openWaterViolation.method_10069(1, 1, 1)), 0xFF0000, 100);
                    }
                    ClientCommandHelper.sendHelp((class_2561)class_2561.method_43471((String)"commands.cfish.error.openWater.help"));
                    if (foundFlowingWater) {
                        ClientCommandHelper.sendHelp((class_2561)class_2561.method_43471((String)"commands.cfish.error.openWater.flowingWater"));
                    }
                    FishingCracker.reset();
                    return;
                }
                BiomeCondition biomeCondition = failedConditions.stream().filter(it -> it instanceof BiomeCondition).findFirst().orElse(null);
                if (biomeCondition != null) {
                    class_5250 error2 = class_2561.method_43469((String)"commands.cfish.error.biome", (Object[])new Object[]{class_2561.method_43471((String)("biome.minecraft." + biomeCondition.biomes.getFirst().getName()))});
                    ClientCommandHelper.addOverlayMessage((class_2561)error2, 100);
                    FishingCracker.reset();
                    return;
                }
            }
            if (FishingCracker.retractFishingBobber()) {
                if (!FishingCracker.throwFishingBobber()) {
                    FishingCracker.reset();
                }
            } else {
                FishingCracker.reset();
            }
        } else {
            totalTicksToWait = ticksUntilOurItem;
            Arrays.fill(expectedCatches, null);
            int e = Math.min(possibleExpectedCatches.size(), ourExpectedCatchIndex + 1 + expectedCatches.length / 2);
            for (int i = Math.max(0, ourExpectedCatchIndex - expectedCatches.length / 2); i < e; ++i) {
                FishingCracker.expectedCatches[i - ourExpectedCatchIndex + FishingCracker.expectedCatches.length / 2] = (Catch)possibleExpectedCatches.get(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processItemSpawn(class_243 pos, class_1799 stack) {
        Object object = STATE_LOCK;
        synchronized (object) {
            if (state != State.WAITING_FOR_ITEM) {
                return;
            }
            if (Math.abs(pos.field_1352 - FishingCracker.bobberDestPos.field_1352) >= 1.0 || Math.abs(pos.field_1350 - FishingCracker.bobberDestPos.field_1350) >= 1.0 || Math.abs(pos.field_1351 - FishingCracker.bobberDestPos.field_1351) >= 5.0) {
                return;
            }
            state = State.WAITING_FOR_XP;
        }
        actualLoot = stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processExperienceOrbSpawn(double x, double y, double z, int experienceAmount) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        Object object = STATE_LOCK;
        synchronized (object) {
            if (state != State.WAITING_FOR_XP) {
                return;
            }
            if (Math.abs(x - player.method_23317()) >= 1.0 || Math.abs(z - player.method_23321()) >= 1.0 || Math.abs(y - player.method_23318()) >= 1.0) {
                return;
            }
            FishingCracker.reset();
        }
        Catch actualCatch = new Catch(actualLoot, experienceAmount);
        Catch expectedCatch = expectedCatches[expectedCatches.length / 2];
        List indices = IntStream.range(0, expectedCatches.length).filter(i -> actualCatch.equals(expectedCatches[i])).map(i -> i - expectedCatches.length / 2).boxed().collect(Collectors.toList());
        if (actualCatch.equals(expectedCatch)) {
            ClientCommandHelper.addOverlayMessage((class_2561)class_2561.method_43469((String)"commands.cfish.correctLoot", (Object[])new Object[]{magicMillisecondsCorrection}).method_27694(style -> style.method_10977(class_124.field_1060)), 100);
        } else {
            ClientCommandHelper.addOverlayMessage((class_2561)class_2561.method_43469((String)"commands.cfish.wrongLoot", (Object[])new Object[]{magicMillisecondsCorrection, indices}).method_27694(style -> style.method_10977(class_124.field_1061)), 100);
        }
        if (!indices.isEmpty()) {
            if (CombinedMedianEM.data.size() >= 10) {
                CombinedMedianEM.data.removeFirst();
            }
            ArrayList<Double> sample = new ArrayList<Double>();
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                sample.add((double)(index * serverMspt) + (double)magicMillisecondsCorrection);
            }
            CombinedMedianEM.data.add(sample);
            CombinedMedianEM.begintime = magicMillisecondsCorrection - serverMspt / 2 - expectedCatches.length / 2 * serverMspt;
            CombinedMedianEM.endtime = magicMillisecondsCorrection + serverMspt / 2 + expectedCatches.length / 2 * serverMspt;
            CombinedMedianEM.width = serverMspt;
            CombinedMedianEM.run();
            magicMillisecondsCorrection = (int)Math.round(CombinedMedianEM.mu);
        }
    }

    private static void onTimeSync() {
        long time = System.nanoTime();
        System.arraycopy(timeSyncTimes, 1, timeSyncTimes, 0, timeSyncTimes.length - 1);
        FishingCracker.timeSyncTimes[FishingCracker.timeSyncTimes.length - 1] = time;
        if (timeSyncTimes[0] != 0L) {
            serverMspt = (int)((time - timeSyncTimes[0]) / (long)((timeSyncTimes.length - 1) * 20 * 1000000));
        }
        if (state == State.WAITING_FOR_FISH) {
            estimatedTicksElapsed = estimatedTicksElapsed == 0 ? (int)Math.ceil((double)(time - bobberStartTime) / (double)(serverMspt * 1000000)) : (estimatedTicksElapsed += 20);
            int latestReasonableArriveTick = estimatedTicksElapsed + 20 + PingCommand.getLocalPing() / serverMspt;
            if (latestReasonableArriveTick >= totalTicksToWait) {
                state = State.ASYNC_WAITING_FOR_FISH;
                int timeToStartOfTick = serverMspt - averageTimeToEndOfTick;
                int delay = (totalTicksToWait - estimatedTicksElapsed) * serverMspt - magicMillisecondsCorrection - PingCommand.getLocalPing() - timeToStartOfTick + serverMspt / 2;
                long targetTime = (long)delay * 1000000L + System.nanoTime();
                DELAY_EXECUTOR.schedule(() -> {
                    if (!Configs.fishingManipulation.isEnabled() || state != State.ASYNC_WAITING_FOR_FISH) {
                        return;
                    }
                    class_746 oldPlayer = class_310.method_1551().field_1724;
                    if (oldPlayer != null) {
                        class_634 packetListener = oldPlayer.field_3944;
                        while (System.nanoTime() - targetTime < 0L) {
                            if (state == State.ASYNC_WAITING_FOR_FISH) continue;
                            return;
                        }
                        class_1536 oldFishingHook = oldPlayer.field_7513;
                        packetListener.method_52787((class_2596)new class_2886(class_1268.field_5808, 0, oldPlayer.method_36454(), oldPlayer.method_36455()));
                        Object object = STATE_LOCK;
                        synchronized (object) {
                            state = State.WAITING_FOR_ITEM;
                        }
                        class_310.method_1551().method_63588(() -> {
                            class_746 player = class_310.method_1551().field_1724;
                            if (player != null) {
                                class_1799 oldStack = player.method_6047();
                                ++expectedFishingRodUses;
                                class_1536 prevFishingHook = player.field_7513;
                                player.field_7513 = oldFishingHook;
                                class_1269 result = oldStack.method_7913(player.method_73183(), (class_1657)player, class_1268.field_5808);
                                player.field_7513 = prevFishingHook;
                                if (result instanceof class_1269.class_9860) {
                                    class_1269.class_9860 successResult = (class_1269.class_9860)result;
                                    if (oldStack != successResult.method_61396()) {
                                        player.method_6122(class_1268.field_5808, successResult.method_61396());
                                    }
                                    if (successResult.comp_2909() == class_1269.class_9861.field_52427) {
                                        player.method_6104(class_1268.field_5808);
                                    }
                                }
                            }
                        });
                    }
                }, (long)Math.max(0, delay - 100), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static void onThrownFishingRod(class_1799 stack) {
        if (expectedFishingRodUses > 0) {
            --expectedFishingRodUses;
            return;
        }
        FishingCracker.handleFishingRodThrow(stack);
    }

    public static void onRetractedFishingRod() {
        if (expectedFishingRodUses > 0) {
            --expectedFishingRodUses;
            return;
        }
        FishingCracker.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onFishingBobberEntity() {
        bobberStartTime = System.nanoTime();
        Object object = STATE_LOCK;
        synchronized (object) {
            if (state != State.WAITING_FOR_BOBBER) {
                return;
            }
            state = State.WAITING_FOR_FIRST_BOBBER_TICK;
            int thrownItemDeltaMillis = (int)((bobberStartTime - throwTime) / 1000000L);
            int localPingMillis = PingCommand.getLocalPing();
            int timeFromEndOfTick = thrownItemDeltaMillis - localPingMillis;
            averageTimeToEndOfTick = (averageTimeToEndOfTick * 3 + timeFromEndOfTick) / 4;
        }
    }

    public static void onBobOutOfWater() {
        class_5250 message = class_2561.method_43471((String)"commands.cfish.error.outOfWater").method_27694(style -> style.method_10977(class_124.field_1061));
        ClientCommandHelper.addOverlayMessage((class_2561)message, 100);
    }

    static {
        expectedCatches = new Catch[21];
        timeSyncTimes = new long[5];
        serverMspt = 50;
        averageTimeToEndOfTick = 0;
        magicMillisecondsCorrection = -100;
        DELAY_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
        state = State.NOT_MANIPULATING;
        STATE_LOCK = new Object();
        expectedFishingRodUses = 0;
    }

    public static enum State {
        NOT_MANIPULATING,
        WAITING_FOR_BOBBER,
        WAITING_FOR_FIRST_BOBBER_TICK,
        WAITING_FOR_FISH,
        ASYNC_WAITING_FOR_FISH,
        WAITING_FOR_ITEM,
        WAITING_FOR_XP,
        WAITING_FOR_RETRHOW;

    }

    private static class SimulatedFishingBobber {
        private static final class_4048 FISHING_BOBBER_DIMENSIONS = class_1299.field_6103.method_18386();
        private final class_1937 level;
        private final class_1536 fakeEntity;
        private class_243 pos;
        private class_238 boundingBox;
        private class_243 velocity;
        private boolean onGround;
        private State state;
        private int hookCountdown;
        private int fishTravelCountdown;
        private boolean inOpenWater;
        private final Set<class_2338> openWaterViolations;
        private int outOfOpenWaterTicks;
        private boolean caughtFish;
        private boolean horizontalCollision;
        private boolean verticalCollision;
        private int waitCountdown;
        private boolean touchingWater;
        private boolean firstUpdate;
        private float fishAngle;
        private final class_5819 random;
        private final class_1799 tool;
        private final int lureLevel;
        private final int luckLevel;
        private @Nullable String failedReason;

        public SimulatedFishingBobber(long seed, class_1799 tool, class_243 pos, class_243 velocity) {
            this.level = (class_1937)Objects.requireNonNull(class_310.method_1551().field_1687);
            this.state = State.FLYING;
            this.inOpenWater = true;
            this.openWaterViolations = new LinkedHashSet<class_2338>(0);
            this.random = class_5819.method_43049((long)(seed ^ 0x5DEECE66DL));
            class_3532.method_15378((class_5819)this.random);
            this.random.method_62816(0.0f, 1.0f);
            this.random.method_62816(0.0f, 1.0f);
            this.random.method_62816(0.0f, 1.0f);
            this.tool = tool;
            this.lureLevel = CUtil.getEnchantmentLevel(this.level.method_30349(), (class_5321<class_1887>)class_1893.field_9100, tool);
            this.luckLevel = CUtil.getEnchantmentLevel(this.level.method_30349(), (class_5321<class_1887>)class_1893.field_9114, tool);
            this.pos = pos;
            this.velocity = velocity;
            this.boundingBox = FISHING_BOBBER_DIMENSIONS.method_30231(pos.field_1352, pos.field_1351, pos.field_1350);
            this.fakeEntity = new class_1536((class_1657)Objects.requireNonNull(class_310.method_1551().field_1724), this.level, 0, 0);
        }

        public boolean canCatchFish() {
            return this.hookCountdown > 0;
        }

        public List<Catch> generateLoot() {
            this.fakeEntity.method_30634(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350);
            this.fakeEntity.method_18799(this.velocity);
            LootContext lootContext = this.getLootContext();
            ArrayList<Catch> catches = new ArrayList<Catch>();
            for (ItemStack loot : MCLootTables.FISHING.get().generate(lootContext)) {
                catches.add(new Catch(SeedfindingUtil.fromSeedfindingItem(loot, this.level.method_30349()), 1 + lootContext.nextInt(6)));
            }
            return catches;
        }

        private LootContext getLootContext() {
            return new LootContext(((class_5820)this.random).field_28766.get() ^ 0x5DEECE66DL, SeedfindingUtil.getMCVersion()).withBiome(SeedfindingUtil.toSeedfindingBiome(this.level, (class_6880<class_1959>)this.level.method_23753(class_2338.method_49638((class_2374)this.pos)))).withOpenWater(this.inOpenWater).withLuck(this.luckLevel);
        }

        public void tick() {
            boolean bl;
            this.onBaseTick();
            if (this.onGround) {
                this.failedReason = "onGround";
            }
            float f = 0.0f;
            class_2338 blockPos = class_2338.method_49638((class_2374)this.pos);
            class_3610 fluidState = this.level.method_8316(blockPos);
            if (fluidState.method_15767(class_3486.field_15517)) {
                f = fluidState.method_15763((class_1922)this.level, blockPos);
            }
            boolean bl2 = bl = f > 0.0f;
            if (this.state == State.FLYING) {
                if (bl) {
                    this.velocity = this.velocity.method_18805(0.3, 0.2, 0.3);
                    this.state = State.BOBBING;
                    return;
                }
                this.checkForCollision();
            } else if (this.state == State.BOBBING) {
                class_243 vec3 = this.velocity;
                double d = this.pos.field_1351 + vec3.field_1351 - (double)blockPos.method_10264() - (double)f;
                if (Math.abs(d) < 0.01) {
                    d += Math.signum(d) * 0.1;
                }
                this.velocity = new class_243(vec3.field_1352 * 0.9, vec3.field_1351 - d * (double)this.random.method_43057() * 0.2, vec3.field_1350 * 0.9);
                this.inOpenWater = this.hookCountdown <= 0 && this.fishTravelCountdown <= 0 ? true : (this.inOpenWater &= this.outOfOpenWaterTicks < 10 & this.isOpenOrWaterAround(blockPos));
                if (bl) {
                    this.outOfOpenWaterTicks = Math.max(0, this.outOfOpenWaterTicks - 1);
                    if (this.caughtFish) {
                        // empty if block
                    }
                    this.tickFishingLogic(blockPos);
                } else {
                    this.outOfOpenWaterTicks = Math.min(10, this.outOfOpenWaterTicks + 1);
                }
            }
            if (!fluidState.method_15767(class_3486.field_15517)) {
                this.velocity = this.velocity.method_1031(0.0, -0.03, 0.0);
            }
            this.move(this.velocity);
            if (this.state == State.FLYING && (this.onGround || this.horizontalCollision)) {
                this.velocity = class_243.field_1353;
            }
            double e = 0.92;
            this.velocity = this.velocity.method_1021(e);
            this.boundingBox = FISHING_BOBBER_DIMENSIONS.method_30231(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350);
        }

        private void onBaseTick() {
            this.updateWaterState();
            this.firstUpdate = false;
        }

        private void updateWaterState() {
            this.checkWaterState();
        }

        private void checkWaterState() {
            if (this.updateMovementInFluid((class_6862<class_3611>)class_3486.field_15517, 0.014)) {
                if (!this.touchingWater && !this.firstUpdate) {
                    this.onSwimmingStart();
                }
                this.touchingWater = true;
            } else {
                if (this.touchingWater) {
                    this.failedReason = "outOfWater";
                }
                this.touchingWater = false;
            }
        }

        private void onSwimmingStart() {
            double l;
            double k;
            float f = 0.2f;
            class_243 vec3 = this.velocity;
            float g = (float)Math.sqrt(vec3.field_1352 * vec3.field_1352 * (double)0.2f + vec3.field_1351 * vec3.field_1351 + vec3.field_1350 * vec3.field_1350 * (double)0.2f) * f;
            if (g > 1.0f) {
                g = 1.0f;
            }
            if ((double)g < 0.25) {
                this.random.method_43057();
                this.random.method_43057();
            } else {
                this.random.method_43057();
                this.random.method_43057();
            }
            float h = class_3532.method_15357((double)this.pos.field_1351);
            int j = 0;
            while ((float)j < 1.0f + FISHING_BOBBER_DIMENSIONS.comp_2185() * 20.0f) {
                k = (this.random.method_43058() * 2.0 - 1.0) * (double)FISHING_BOBBER_DIMENSIONS.comp_2185();
                l = (this.random.method_43058() * 2.0 - 1.0) * (double)FISHING_BOBBER_DIMENSIONS.comp_2185();
                this.random.method_43058();
                ++j;
            }
            j = 0;
            while ((float)j < 1.0f + FISHING_BOBBER_DIMENSIONS.comp_2185() * 20.0f) {
                k = (this.random.method_43058() * 2.0 - 1.0) * (double)FISHING_BOBBER_DIMENSIONS.comp_2185();
                l = (this.random.method_43058() * 2.0 - 1.0) * (double)FISHING_BOBBER_DIMENSIONS.comp_2185();
                ++j;
            }
        }

        private boolean updateMovementInFluid(class_6862<class_3611> tag, double d) {
            int n;
            class_238 aabb = this.boundingBox.method_1011(0.001);
            int i = class_3532.method_15357((double)aabb.field_1323);
            int j = class_3532.method_15384((double)aabb.field_1320);
            int k = class_3532.method_15357((double)aabb.field_1322);
            int l = class_3532.method_15384((double)aabb.field_1325);
            int m = class_3532.method_15357((double)aabb.field_1321);
            if (!this.level.method_22341(i, k, m, j, l, n = class_3532.method_15384((double)aabb.field_1324))) {
                return false;
            }
            double e = 0.0;
            boolean bl2 = false;
            class_243 vec3 = class_243.field_1353;
            int o = 0;
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int p = i; p < j; ++p) {
                for (int q = k; q < l; ++q) {
                    for (int r = m; r < n; ++r) {
                        double f;
                        mutable.method_10103(p, q, r);
                        class_3610 fluidState = this.level.method_8316((class_2338)mutable);
                        if (!fluidState.method_15767(tag) || !((f = (double)((float)q + fluidState.method_15763((class_1922)this.level, (class_2338)mutable))) >= aabb.field_1322)) continue;
                        bl2 = true;
                        e = Math.max(f - aabb.field_1322, e);
                    }
                }
            }
            if (vec3.method_1033() > 0.0) {
                if (o > 0) {
                    vec3 = vec3.method_1021(1.0 / (double)o);
                }
                vec3 = vec3.method_1029();
                class_243 vec33 = this.velocity;
                vec3 = vec3.method_1021(d);
                double g = 0.003;
                if (Math.abs(vec33.field_1352) < 0.003 && Math.abs(vec33.field_1350) < 0.003 && vec3.method_1033() < 0.0045000000000000005) {
                    vec3 = vec3.method_1029().method_1021(0.0045000000000000005);
                }
                this.velocity = this.velocity.method_1019(vec3);
            }
            return bl2;
        }

        private void checkForCollision() {
            this.fakeEntity.method_30634(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350);
            this.fakeEntity.method_18799(this.velocity);
            class_239 hitResult = class_1675.method_49997((class_1297)this.fakeEntity, arg_0 -> ((class_1536)this.fakeEntity).method_26958(arg_0));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                this.failedReason = "collision";
            }
        }

        private void move(class_243 movement) {
            assert (this.level != null);
            class_243 vec3 = this.adjustMovementForCollisions(movement);
            if (vec3.method_1027() > 1.0E-7) {
                this.boundingBox = this.boundingBox.method_997(vec3);
                this.pos = new class_243((this.boundingBox.field_1323 + this.boundingBox.field_1320) / 2.0, this.boundingBox.field_1322, (this.boundingBox.field_1321 + this.boundingBox.field_1324) / 2.0);
            }
            this.horizontalCollision = !class_3532.method_20390((double)movement.field_1352, (double)vec3.field_1352) || !class_3532.method_20390((double)movement.field_1350, (double)vec3.field_1350);
            this.verticalCollision = movement.field_1351 != vec3.field_1351;
            this.onGround = this.verticalCollision && movement.field_1351 < 0.0;
            class_243 vec32 = this.velocity;
            if (movement.field_1352 != vec3.field_1352) {
                this.velocity = new class_243(0.0, vec32.field_1351, vec32.field_1350);
            }
            if (movement.field_1350 != vec3.field_1350) {
                this.velocity = new class_243(vec32.field_1352, vec32.field_1351, 0.0);
            }
            if (movement.field_1351 != vec3.field_1351) {
                this.velocity = this.velocity.method_18805(1.0, 0.0, 1.0);
            }
            if (this.onGround) {
                // empty if block
            }
            float i = this.getVelocityMultiplier();
            this.velocity = this.velocity.method_18805((double)i, 1.0, (double)i);
            if (this.level.method_29556(this.boundingBox.method_1011(0.001)).anyMatch(blockStatex -> blockStatex.method_26164(class_3481.field_21952) || blockStatex.method_27852(class_2246.field_10164))) {
                this.failedReason = "fire";
            }
        }

        private class_243 adjustMovementForCollisions(class_243 movement) {
            class_238 aabb = this.boundingBox;
            this.fakeEntity.method_30634(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350);
            this.fakeEntity.method_18799(this.velocity);
            assert (this.level != null);
            class_265 voxelShape = this.level.method_8621().method_17903();
            ArrayList<class_265> voxelShapes = new ArrayList<class_265>();
            if (!class_259.method_1074((class_265)voxelShape, (class_265)class_259.method_1078((class_238)aabb.method_1011(1.0E-7)), (class_247)class_247.field_16896)) {
                voxelShapes.add(voxelShape);
            }
            voxelShapes.addAll(this.level.method_20743((class_1297)this.fakeEntity, aabb.method_18804(movement)));
            return movement.method_1027() == 0.0 ? movement : class_1297.method_20736((class_1297)this.fakeEntity, (class_243)movement, (class_238)aabb, (class_1937)this.level, voxelShapes);
        }

        private float getVelocityMultiplier() {
            assert (this.level != null);
            class_2248 block = this.level.method_8320(class_2338.method_49638((class_2374)this.pos)).method_26204();
            float f = block.method_23349();
            if (block != class_2246.field_10382 && block != class_2246.field_10422) {
                return (double)f == 1.0 ? this.level.method_8320(class_2338.method_49637((double)this.pos.field_1352, (double)(this.boundingBox.field_1322 - 0.5000001), (double)this.pos.field_1350)).method_26204().method_23349() : f;
            }
            return f;
        }

        private boolean isOpenOrWaterAround(class_2338 pos) {
            PositionType positionType = PositionType.INVALID;
            boolean valid = true;
            for (int i = -1; i <= 2; ++i) {
                PositionType positionType2 = this.getPositionType(pos.method_10069(-2, i, -2), pos.method_10069(2, i, 2));
                switch (positionType2.ordinal()) {
                    case 2: {
                        valid = false;
                        break;
                    }
                    case 0: {
                        if (positionType != PositionType.INVALID) break;
                        valid = false;
                        break;
                    }
                    case 1: {
                        if (positionType != PositionType.ABOVE_WATER) break;
                        valid = false;
                    }
                }
                if (!valid) {
                    ArrayList<class_2338> aboveWaterBlocks = new ArrayList<class_2338>(0);
                    boolean foundWater = false;
                    for (int dx = -2; dx <= 2; ++dx) {
                        for (int dz = -2; dz <= 2; ++dz) {
                            class_2338 pos2 = pos.method_10069(dx, i, dz);
                            PositionType positionType3 = this.getPositionType(pos2);
                            if (positionType3 == PositionType.INVALID) {
                                this.openWaterViolations.add(pos2);
                                continue;
                            }
                            if (positionType3 == PositionType.ABOVE_WATER) {
                                aboveWaterBlocks.add(pos2);
                                continue;
                            }
                            if (positionType3 != PositionType.INSIDE_WATER) continue;
                            foundWater = true;
                        }
                    }
                    if (foundWater) {
                        this.openWaterViolations.addAll(aboveWaterBlocks);
                    }
                }
                positionType = positionType2;
            }
            return valid;
        }

        private PositionType getPositionType(class_2338 start, class_2338 end) {
            return class_2338.method_20437((class_2338)start, (class_2338)end).map(this::getPositionType).reduce((positionType, positionType2) -> positionType == positionType2 ? positionType : PositionType.INVALID).orElse(PositionType.INVALID);
        }

        private PositionType getPositionType(class_2338 pos) {
            assert (this.level != null);
            class_2680 blockState = this.level.method_8320(pos);
            if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
                class_3610 fluidState = blockState.method_26227();
                return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771() && blockState.method_26220((class_1922)this.level, pos).method_1110() ? PositionType.INSIDE_WATER : PositionType.INVALID;
            }
            return PositionType.ABOVE_WATER;
        }

        private void tickFishingLogic(class_2338 pos) {
            assert (this.level != null);
            int i = 1;
            class_2338 blockPos = pos.method_10084();
            if (this.random.method_43057() < 0.25f && this.level.method_8520(blockPos)) {
                ++i;
            }
            if (this.random.method_43057() < 0.5f && !this.level.method_8311(blockPos)) {
                --i;
            }
            if (this.hookCountdown > 0) {
                --this.hookCountdown;
                if (this.hookCountdown <= 0) {
                    this.waitCountdown = 0;
                    this.fishTravelCountdown = 0;
                    this.caughtFish = false;
                }
            } else if (this.fishTravelCountdown > 0) {
                this.fishTravelCountdown -= i;
                if (this.fishTravelCountdown > 0) {
                    double s;
                    this.fishAngle = (float)((double)this.fishAngle + this.random.method_43385(0.0, 9.188));
                    float n = this.fishAngle * ((float)Math.PI / 180);
                    float o = class_3532.method_15374((double)n);
                    float p = class_3532.method_15362((double)n);
                    double q = this.pos.field_1352 + (double)(o * (float)this.fishTravelCountdown * 0.1f);
                    double r = (float)class_3532.method_15357((double)this.pos.field_1351) + 1.0f;
                    class_2680 blockState2 = this.level.method_8320(class_2338.method_49637((double)q, (double)(r - 1.0), (double)(s = this.pos.field_1350 + (double)(p * (float)this.fishTravelCountdown * 0.1f))));
                    if (blockState2.method_27852(class_2246.field_10382)) {
                        if (this.random.method_43057() < 0.15f) {
                            // empty if block
                        }
                        float k = o * 0.04f;
                        float f = p * 0.04f;
                    }
                } else {
                    this.random.method_43057();
                    this.random.method_43057();
                    double m = this.pos.field_1351 + 0.5;
                    this.hookCountdown = class_3532.method_15395((class_5819)this.random, (int)20, (int)40);
                    this.caughtFish = true;
                }
            } else if (this.waitCountdown > 0) {
                this.waitCountdown -= i;
                float n = 0.15f;
                if (this.waitCountdown < 20) {
                    n = (float)((double)n + (double)(20 - this.waitCountdown) * 0.05);
                } else if (this.waitCountdown < 40) {
                    n = (float)((double)n + (double)(40 - this.waitCountdown) * 0.02);
                } else if (this.waitCountdown < 60) {
                    n = (float)((double)n + (double)(60 - this.waitCountdown) * 0.01);
                }
                if (this.random.method_43057() < n) {
                    double s;
                    double r;
                    float o = class_3532.method_15344((class_5819)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                    float p = class_3532.method_15344((class_5819)this.random, (float)25.0f, (float)60.0f);
                    double q = this.pos.field_1352 + (double)(class_3532.method_15374((double)o) * p * 0.1f);
                    class_2680 blockState2 = this.level.method_8320(class_2338.method_49637((double)q, (double)((r = (double)((float)class_3532.method_15357((double)this.pos.field_1351) + 1.0f)) - 1.0), (double)(s = this.pos.field_1350 + (double)(class_3532.method_15362((double)o) * p * 0.1f))));
                    if (blockState2.method_27852(class_2246.field_10382)) {
                        this.random.method_43048(2);
                    }
                }
                if (this.waitCountdown <= 0) {
                    this.fishAngle = class_3532.method_15344((class_5819)this.random, (float)0.0f, (float)360.0f);
                    this.fishTravelCountdown = class_3532.method_15395((class_5819)this.random, (int)20, (int)80);
                }
            } else {
                this.waitCountdown = class_3532.method_15395((class_5819)this.random, (int)100, (int)600);
                this.waitCountdown -= this.lureLevel * 20 * 5;
            }
        }

        private static enum State {
            FLYING,
            BOBBING;

        }

        private static enum PositionType {
            ABOVE_WATER,
            INSIDE_WATER,
            INVALID;

        }
    }

    public static class Catch {
        private final class_1799 loot;
        private final int experience;

        public Catch(class_1799 loot, int experience) {
            this.loot = loot.method_7972();
            if (this.loot.method_7963()) {
                this.loot.method_7974(0);
            }
            this.experience = experience;
        }

        public int hashCode() {
            return 7 * (31 * class_1799.method_57355((class_1799)this.loot) + this.loot.method_7947()) + this.experience;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Catch)) {
                return false;
            }
            Catch that = (Catch)other;
            return class_1799.method_7973((class_1799)this.loot, (class_1799)that.loot) && this.experience == that.experience;
        }

        public String toString() {
            return String.valueOf(this.loot) + " + " + this.experience + "xp";
        }
    }

    private static class CombinedMedianEM {
        static ArrayList<ArrayList<Double>> data = new ArrayList();
        static double width = 50.0;
        static int begintime = -1000;
        static int endtime = 1000;
        static double packetlossrate = 0.2;
        static double maxpacketlossrate = 0.5;
        static double minpacketlossrate = 0.01;
        static double mu = 0.0;
        static double sigma = 500.0;
        static double maxsigma = 1000.0;
        static double minsigma = 10.0;

        private CombinedMedianEM() {
        }

        public static void run() {
            ArrayList<Double> droprate = new ArrayList<Double>();
            for (ArrayList<Double> sample : data) {
                droprate.add((double)sample.size() * width / (double)(endtime - begintime));
            }
            ArrayList<Double> times = new ArrayList<Double>();
            for (int i = begintime; i <= endtime; i += 10) {
                times.add((double)i * 1.0);
            }
            double besttime = 0.0;
            double bestscore = Double.MAX_VALUE;
            Iterator iterator = times.iterator();
            while (iterator.hasNext()) {
                double time = (Double)iterator.next();
                double score = 0.0;
                for (int i = 0; i < data.size(); ++i) {
                    ArrayList<Double> sample = data.get(i);
                    double lambda = (Double)droprate.get(i) / width;
                    double bestsubscore = Double.MAX_VALUE;
                    for (Double x : sample) {
                        double absdev = Math.abs(x - time);
                        if (!((absdev = (1.0 - Math.exp(-lambda * absdev)) / lambda) < bestsubscore)) continue;
                        bestsubscore = absdev;
                    }
                    score += bestsubscore;
                }
                if (!(score < bestscore)) continue;
                bestscore = score;
                besttime = time;
            }
            mu = besttime;
            sigma = bestscore / (double)data.size();
            sigma = Math.max(Math.min(sigma, maxsigma), minsigma);
            for (int repeat = 0; repeat < 1; ++repeat) {
                ArrayList masses = new ArrayList();
                for (int i = 0; i < data.size(); ++i) {
                    ArrayList<Double> sample = data.get(i);
                    double sum = 0.0;
                    for (double x : sample) {
                        sum += CombinedMedianEM.mass(x);
                    }
                    double pXandNorm = Math.min(sum, 1.0) * (1.0 - packetlossrate);
                    double pXandUnif = (Double)droprate.get(i) * packetlossrate;
                    double pNorm = pXandNorm / (pXandNorm + pXandUnif);
                    ArrayList<Double> mass = new ArrayList<Double>();
                    for (double x : sample) {
                        mass.add(CombinedMedianEM.mass(x) / sum * pNorm);
                    }
                    masses.add(mass);
                }
                double weightedsum = 0.0;
                double sumofweights = 0.0;
                for (int i = 0; i < data.size(); ++i) {
                    ArrayList<Double> sample = data.get(i);
                    ArrayList mass = (ArrayList)masses.get(i);
                    for (int j = 0; j < sample.size(); ++j) {
                        weightedsum += sample.get(j) * (Double)mass.get(j);
                        sumofweights += ((Double)mass.get(j)).doubleValue();
                    }
                }
                double muNext = weightedsum / sumofweights;
                double weightedsumofsquaredeviations = 0.0;
                for (int i = 0; i < data.size(); ++i) {
                    ArrayList<Double> sample = data.get(i);
                    ArrayList mass = (ArrayList)masses.get(i);
                    for (int j = 0; j < sample.size(); ++j) {
                        weightedsumofsquaredeviations += Math.pow(sample.get(j) - muNext, 2.0) * (Double)mass.get(j);
                    }
                }
                double sigmaNext = Math.sqrt(weightedsumofsquaredeviations / sumofweights);
                sigmaNext = Math.max(Math.min(sigmaNext, maxsigma), minsigma);
                double packetlossrateNext = ((double)data.size() - sumofweights) / (double)data.size();
                packetlossrateNext = Math.max(Math.min(packetlossrateNext, maxpacketlossrate), minpacketlossrate);
                mu = muNext;
                sigma = sigmaNext;
                packetlossrate = packetlossrateNext;
            }
        }

        public static double mass(double x) {
            double pdf = 1.0 / (sigma * Math.sqrt(Math.PI * 2)) * Math.exp(-Math.pow((x - mu) / sigma, 2.0) / 2.0);
            return Math.min(pdf * width, 1.0);
        }
    }
}

