/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.render.RenderQueue;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.earthcomputer.clientcommands.util.CComponentUtil;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jspecify.annotations.Nullable;

public class ChorusManipulation {
    public static boolean chorusRelativeTel;
    public static @Nullable class_243 chorusGoalFrom;
    public static @Nullable class_243 chorusGoalTo;
    private static final Object GOAL_POS_KEY;

    public static void onChorusManipEnabled() {
        TaskManager.addNonConflictingTask("chorusManipRenderer", new SimpleTask(){

            @Override
            public boolean condition() {
                return Configs.chorusManipulation && class_310.method_1551().field_1724 != null;
            }

            @Override
            protected void onTick() {
                if (chorusGoalFrom != null && chorusGoalTo != null) {
                    class_746 player = class_310.method_1551().field_1724;
                    assert (player != null);
                    class_238 targetArea = ChorusManipulation.getTargetArea(player.method_73189());
                    if (targetArea != null) {
                        RenderQueue.addCuboid(RenderQueue.Layer.ON_TOP, GOAL_POS_KEY, targetArea, 0xFF55FF, 1);
                    }
                }
            }
        });
    }

    public static int setGoal(class_243 v1, class_243 v2, boolean relative) {
        if (!Configs.chorusManipulation) {
            class_5250 component = class_2561.method_43471((String)"chorusManip.needChorusManipulation").method_27692(class_124.field_1061).method_27693(" ").method_10852(CComponentUtil.getCommandTextComponent("commands.client.enable", "/cconfig clientcommands chorusManipulation set true"));
            ClientCommandHelper.sendFeedback((class_2561)component);
            return 0;
        }
        if (!Configs.playerCrackState.knowsSeed()) {
            class_5250 component = class_2561.method_43471((String)"playerManip.uncracked").method_27692(class_124.field_1061).method_27693(" ").method_10852(CComponentUtil.getCommandTextComponent("commands.client.crack", "/ccrackrng"));
            ClientCommandHelper.sendFeedback((class_2561)component);
            return 0;
        }
        if (relative && (Math.abs(v1.method_10216()) > 8.0 || Math.abs(v1.method_10214()) > 8.0 || Math.abs(v1.method_10215()) > 8.0) && (Math.abs(v2.method_10216()) > 8.0 || Math.abs(v2.method_10214()) > 8.0 || Math.abs(v2.method_10215()) > 8.0)) {
            ClientCommandHelper.sendError((class_2561)class_2561.method_43471((String)"chorusManip.goalTooFar"));
            return -1;
        }
        if (Math.abs(v1.method_10214() - v2.method_10214()) == 0.0) {
            v2 = v2.method_1031(0.0, 1.0, 0.0);
        }
        chorusGoalFrom = v1;
        chorusGoalTo = v2;
        chorusRelativeTel = relative;
        ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"chorusManip.setGoal", (Object[])new Object[]{relative ? "relative" : "absolute", chorusGoalFrom.toString(), chorusGoalTo.toString()}));
        return 0;
    }

    public static boolean onEat(class_243 pos, int particleCount, int itemUseTimeLeft) {
        class_238 area = ChorusManipulation.getTargetArea(pos);
        if (area == null) {
            return false;
        }
        if (!area.method_1014(8.0).method_1006(pos)) {
            ClientCommandHelper.sendError((class_2561)class_2561.method_43471((String)"chorusManip.goalTooFar"));
            return false;
        }
        PlayerRandCracker.ThrowItemsResult throwItemsState = PlayerRandCracker.throwItemsUntil(rand -> {
            double z;
            if (particleCount != 16 && itemUseTimeLeft >= 0) {
                int i = 0;
                while ((double)i < 33.0 + 4.5 * (double)itemUseTimeLeft) {
                    rand.nextInt();
                    ++i;
                }
            }
            double x = (rand.nextDouble() - 0.5) * 16.0 + pos.method_10216();
            class_638 level = class_310.method_1551().field_1687;
            assert (level != null);
            double y = class_3532.method_15350((double)(pos.method_10214() + (double)(rand.nextInt(16) - 8)), (double)level.method_31607(), (double)level.method_31600());
            class_243 landingArea = ChorusManipulation.canTeleport(area, new class_243(x, y, z = (rand.nextDouble() - 0.5) * 16.0 + pos.method_10215()));
            if (landingArea != null) {
                if (itemUseTimeLeft == 24) {
                    ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"chorusManip.landing.success", (Object[])new Object[]{(double)Math.round(landingArea.method_10216() * 100.0) / 100.0, (double)Math.round(landingArea.method_10214() * 100.0) / 100.0, (double)Math.round(landingArea.method_10215() * 100.0) / 100.0}));
                }
                return true;
            }
            return false;
        }, Configs.getMaxChorusItemThrows());
        if (!throwItemsState.isSuccess()) {
            throwItemsState.sendErrorMessage();
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43471((String)"chorusManip.landing.failed").method_27692(class_124.field_1061), false);
            return false;
        }
        return true;
    }

    private static @Nullable class_238 getTargetArea(class_243 pos) {
        class_243 to;
        class_243 from;
        if (chorusGoalFrom == null || chorusGoalTo == null) {
            return null;
        }
        if (chorusRelativeTel) {
            from = chorusGoalFrom.method_1019(pos);
            to = chorusGoalTo.method_1019(pos);
        } else {
            from = chorusGoalFrom;
            to = chorusGoalTo;
        }
        return new class_238(from, to);
    }

    public static @Nullable class_243 canTeleport(class_238 goalArea, class_243 goalVec) {
        class_2338 blockPos = class_2338.method_49638((class_2374)goalVec);
        class_638 level = class_310.method_1551().field_1687;
        if (level != null && level.method_22340(blockPos)) {
            boolean blockBelowIsGround = false;
            while (!blockBelowIsGround && blockPos.method_10264() > 0) {
                class_2338 blockPos2 = blockPos.method_10074();
                class_2680 blockState = level.method_8320(blockPos2);
                if (blockState.method_51366()) {
                    blockBelowIsGround = true;
                    continue;
                }
                blockPos = blockPos2;
            }
            if (blockBelowIsGround) {
                goalVec = new class_243(goalVec.method_10216(), (double)blockPos.method_10264(), goalVec.method_10215());
                class_238 boundingBox = new class_238(goalVec.method_10216() - 0.3, goalVec.method_10214(), goalVec.method_10215() - 0.3, goalVec.method_10216() + 0.3, goalVec.method_10214() + 1.8, goalVec.method_10215() + 0.3);
                if (goalArea.method_1006(goalVec) && level.method_18026(boundingBox) && !level.method_22345(boundingBox)) {
                    return goalVec;
                }
            }
        }
        return null;
    }

    static {
        GOAL_POS_KEY = new Object();
    }
}

