/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.slf4j.Logger;

public class VarCommand {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("%([^%]+)%");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType SAVE_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cvar.saveFile.failed"));
    private static final DynamicCommandExceptionType ALREADY_EXISTS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.cvar.add.alreadyExists", (Object[])new Object[]{arg}));
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.cvar.notFound", (Object[])new Object[]{arg}));
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("clientcommands");
    private static final Map<String, String> variables = new HashMap<String, String>();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cvar").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"variable", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> VarCommand.addVariable((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"variable"), StringArgumentType.getString((CommandContext)ctx, (String)"value"))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"variable", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(variables.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> VarCommand.removeVariable((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"variable")))))).then(ClientCommandManager.literal((String)"edit").then(ClientCommandManager.argument((String)"variable", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(variables.keySet(), (SuggestionsBuilder)builder)).then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> VarCommand.editVariable((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"variable"), StringArgumentType.getString((CommandContext)ctx, (String)"value"))))))).then(ClientCommandManager.literal((String)"parse").then(ClientCommandManager.argument((String)"variable", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(variables.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> VarCommand.parseVariable((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"variable")))))).then(ClientCommandManager.literal((String)"list").executes(ctx -> VarCommand.listVariables((FabricClientCommandSource)ctx.getSource()))));
    }

    private static int addVariable(FabricClientCommandSource source, String variable, String value) throws CommandSyntaxException {
        if (variables.containsKey(variable)) {
            throw ALREADY_EXISTS_EXCEPTION.create((Object)variable);
        }
        variables.put(variable, value);
        VarCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cvar.add.success", (Object[])new Object[]{variable}));
        return 1;
    }

    private static int removeVariable(FabricClientCommandSource source, String variable) throws CommandSyntaxException {
        if (variables.remove(variable) == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)variable);
        }
        VarCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cvar.remove.success", (Object[])new Object[]{variable}));
        return 1;
    }

    private static int editVariable(FabricClientCommandSource source, String variable, String value) throws CommandSyntaxException {
        if (!variables.containsKey(variable)) {
            throw NOT_FOUND_EXCEPTION.create((Object)variable);
        }
        variables.put(variable, value);
        VarCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cvar.edit.success", (Object[])new Object[]{variable}));
        return 1;
    }

    private static int parseVariable(FabricClientCommandSource source, String variable) throws CommandSyntaxException {
        String value = variables.get(variable);
        if (value == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)variable);
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cvar.parse.success", (Object[])new Object[]{variable, value}));
        return 1;
    }

    private static int listVariables(FabricClientCommandSource source) {
        if (variables.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cvar.list.empty"));
        } else {
            String list = "%" + String.join((CharSequence)"%, %", variables.keySet()) + "%";
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cvar.list", (Object[])new Object[]{list}));
        }
        return variables.size();
    }

    private static void saveFile() throws CommandSyntaxException {
        try {
            class_2487 rootTag = new class_2487();
            variables.forEach((arg_0, arg_1) -> ((class_2487)rootTag).method_10582(arg_0, arg_1));
            Path newFile = File.createTempFile("vars", ".dat", configPath.toFile()).toPath();
            class_2507.method_10630((class_2487)rootTag, (Path)newFile);
            Path backupFile = configPath.resolve("vars.dat_old");
            Path currentFile = configPath.resolve("vars.dat");
            class_156.method_30626((Path)currentFile, (Path)newFile, (Path)backupFile);
        }
        catch (IOException e) {
            throw SAVE_FAILED_EXCEPTION.create();
        }
    }

    private static void loadFile() throws IOException {
        variables.clear();
        class_2487 rootTag = class_2507.method_10633((Path)configPath.resolve("vars.dat"));
        if (rootTag == null) {
            return;
        }
        rootTag.method_59874().forEach(entry -> variables.put((String)entry.getKey(), ((class_2520)entry.getValue()).method_68658().orElse("")));
    }

    public static String replaceVariables(String originalString) {
        Matcher matcher = VARIABLE_PATTERN.matcher(originalString);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group();
            matcher.appendReplacement(builder, variables.getOrDefault(group.substring(1, group.length() - 1), group).replace("\\", "\\\\").replace("$", "\\$"));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static boolean containsVars(String command) {
        return VARIABLE_PATTERN.matcher(command).find();
    }

    static {
        try {
            VarCommand.loadFile();
        }
        catch (IOException e) {
            LOGGER.error("Could not load vars file, hence /cvar will not work!", (Throwable)e);
        }
    }
}

