/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import net.earthcomputer.clientcommands.c2c.C2CPacketHandler;
import net.earthcomputer.clientcommands.c2c.packets.PutTicTacToeMarkC2CPacket;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.features.TwoPlayerGame;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_640;
import org.jspecify.annotations.Nullable;

public class TicTacToeCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register(TwoPlayerGame.TIC_TAC_TOE_GAME_TYPE.createCommandTree());
    }

    public static void onPutTicTacToeMarkC2CPacket(PutTicTacToeMarkC2CPacket packet) {
        String sender = packet.sender();
        UUID senderUUID = packet.senderUUID();
        if (sender == null || senderUUID == null) {
            return;
        }
        TicTacToeGame game = TwoPlayerGame.TIC_TAC_TOE_GAME_TYPE.getActiveGame(senderUUID);
        if (game == null) {
            return;
        }
        if (game.putMark(packet.x(), packet.y(), game.yourMarks.opposite())) {
            TicTacToeGame.Mark winner = game.getWinner();
            if (winner == game.yourMarks.opposite()) {
                TwoPlayerGame.TIC_TAC_TOE_GAME_TYPE.onLost(sender, senderUUID);
            } else if (game.isDrawn()) {
                TwoPlayerGame.TIC_TAC_TOE_GAME_TYPE.onDraw(sender, senderUUID);
            } else {
                TwoPlayerGame.TIC_TAC_TOE_GAME_TYPE.onMove(sender);
            }
        }
    }

    public static class TicTacToeGame {
        public final class_640 opponent;
        private final @Nullable Mark[][] board = new Mark[3][3];
        private final Mark yourMarks;
        private boolean yourTurn;

        public TicTacToeGame(class_640 opponent, Mark yourMarks) {
            this.opponent = opponent;
            this.yourMarks = yourMarks;
            this.yourTurn = yourMarks == Mark.CROSS;
        }

        public boolean putMark(byte x, byte y, Mark mark) {
            if (this.yourMarks == mark == this.yourTurn && this.board[x][y] == null) {
                this.board[x][y] = mark;
                this.yourTurn = !this.yourTurn;
                return true;
            }
            return false;
        }

        public @Nullable Mark getWinner() {
            for (int x = 0; x < 3; x = (int)((byte)(x + 1))) {
                if (this.board[x][0] == this.board[x][1] && this.board[x][1] == this.board[x][2] && this.board[x][0] != null) {
                    return this.board[x][0];
                }
                if (this.board[0][x] != this.board[1][x] || this.board[1][x] != this.board[2][x] || this.board[0][x] == null) continue;
                return this.board[0][x];
            }
            if (this.board[0][0] == this.board[1][1] && this.board[1][1] == this.board[2][2] && this.board[0][0] != null) {
                return this.board[0][0];
            }
            if (this.board[0][2] == this.board[1][1] && this.board[1][1] == this.board[2][0] && this.board[0][2] != null) {
                return this.board[0][2];
            }
            return null;
        }

        public boolean isDrawn() {
            Mark[][] markArray = this.board;
            int n = markArray.length;
            for (int i = 0; i < n; ++i) {
                Mark[] marks;
                for (Mark mark : marks = markArray[i]) {
                    if (mark == null) continue;
                    return false;
                }
            }
            return true;
        }

        public static enum Mark {
            NOUGHT((class_2561)class_2561.method_43471((String)"ticTacToeGame.noughts")),
            CROSS((class_2561)class_2561.method_43471((String)"ticTacToeGame.crosses"));

            private final class_2561 name;

            private Mark(class_2561 name) {
                this.name = name;
            }

            public Mark opposite() {
                return this == NOUGHT ? CROSS : NOUGHT;
            }
        }
    }

    public static class TicTacToeGameScreen
    extends class_437 {
        private final TicTacToeGame game;
        private static final class_2960 GRID_TEXTURE = class_2960.method_60655((String)"clientcommands", (String)"textures/tic_tac_toe/grid.png");
        private static final class_2960 MARKS_TEXTURE = class_2960.method_60655((String)"clientcommands", (String)"textures/tic_tac_toe/marks.png");
        private static final int GRID_SIZE_TEXTURE = 512;
        private static final int MARK_SIZE_TEXTURE = 152;
        private static final int GRID_SIZE = 256;
        private static final int CELL_SIZE = 80;
        private static final int BORDER_SIZE = 8;
        private static final int MARK_SIZE = 76;
        private static final int PADDING = 2;

        public TicTacToeGameScreen(TicTacToeGame game) {
            super((class_2561)class_2561.method_43469((String)"ticTacToeGame.title", (Object[])new Object[]{game.opponent.method_2966().name()}));
            this.game = game;
        }

        public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
            int startX = (this.field_22789 - 256) / 2;
            int startY = (this.field_22790 - 256) / 2;
            guiGraphics.method_27535(this.field_22793, this.field_22785, startX, startY - 20, -1);
            guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"ticTacToeGame.playingWith", (Object[])new Object[]{this.game.yourMarks.name}), startX, startY - 10, -1);
            guiGraphics.method_25302(class_10799.field_56883, GRID_TEXTURE, startX, startY, 0.0f, 0.0f, 256, 256, 512, 512, 512, 512);
            @Nullable TicTacToeGame.Mark[][] board = this.game.board;
            for (int x = 0; x < 3; x = (int)((byte)(x + 1))) {
                for (int y = 0; y < 3; y = (int)((byte)(y + 1))) {
                    TicTacToeGame.Mark mark = board[x][y];
                    if (mark == null) continue;
                    int offset = switch (mark.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> 0;
                        case 1 -> 152;
                    };
                    guiGraphics.method_25302(class_10799.field_56883, MARKS_TEXTURE, startX + 88 * x + 2, startY + 88 * y + 2, (float)offset, 0.0f, 76, 76, 152, 152, 304, 152);
                }
            }
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            byte y;
            byte x;
            int startX = (this.field_22789 - 256) / 2;
            int startY = (this.field_22790 - 256) / 2;
            if (event.comp_4798() < (double)startX || event.comp_4798() > (double)(startX + 256) || event.comp_4799() < (double)startY || event.comp_4799() > (double)(startY + 256)) {
                return super.method_25402(event, doubleClick);
            }
            if (event.method_74245() != 0) {
                return false;
            }
            double relativeX = event.comp_4798() - (double)startX;
            if (relativeX > (double)(88 * ((x = (byte)(relativeX / 88.0)) + 1) - 8)) {
                return false;
            }
            double relativeY = event.comp_4799() - (double)startY;
            if (relativeY > (double)(88 * ((y = (byte)(relativeY / 88.0)) + 1) - 8)) {
                return false;
            }
            if (this.game.putMark(x, y, this.game.yourMarks)) {
                try {
                    PutTicTacToeMarkC2CPacket packet = new PutTicTacToeMarkC2CPacket(class_310.method_1551().method_1562().method_2879().name(), class_310.method_1551().method_1562().method_2879().id(), x, y);
                    C2CPacketHandler.getInstance().sendPacket(packet, this.game.opponent);
                }
                catch (CommandSyntaxException e) {
                    ClientCommandHelper.sendFeedback(class_2561.method_54155((Message)e.getRawMessage()));
                }
                if (this.game.getWinner() == this.game.yourMarks) {
                    TwoPlayerGame.TIC_TAC_TOE_GAME_TYPE.onWon(this.game.opponent.method_2966().name(), this.game.opponent.method_2966().id());
                }
                return true;
            }
            return false;
        }
    }
}

