/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_310;
import org.jspecify.annotations.Nullable;

public final class Flag<T> {
    private final Class<T> type;
    private final String name;
    private final @Nullable Character shortName;
    private final T defaultValue;
    private final boolean repeatable;

    private Flag(Class<T> type, String name, @Nullable Character shortName, T defaultValue, boolean repeatable) {
        this.type = type;
        this.name = name;
        this.shortName = shortName;
        this.defaultValue = defaultValue;
        this.repeatable = repeatable;
    }

    public static <T> Builder<T> of(Class<T> type, String name) {
        return new Builder<T>(type, name);
    }

    public static Builder<Boolean> ofFlag(String name) {
        return new Builder<Boolean>(Boolean.class, name).withDefaultValue(false);
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getShortFlag() {
        return this.shortName == null ? null : "-" + this.shortName;
    }

    public String getFlag() {
        return "--" + this.name;
    }

    public static boolean isFlag(String argument) {
        return argument.startsWith("-") && argument.length() == 2 || argument.startsWith("--");
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void addToCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, LiteralCommandNode<FabricClientCommandSource> commandNode, Function<CommandContext<FabricClientCommandSource>, T> value) {
        dispatcher.register((LiteralArgumentBuilder)commandNode.createBuilder().then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)this.getFlag()).redirect(commandNode, ctx -> ClientCommandHelper.withFlag((FabricClientCommandSource)ctx.getSource(), this, value.apply(ctx)))).executes(commandNode.getCommand())));
        if (this.shortName != null) {
            dispatcher.register((LiteralArgumentBuilder)commandNode.createBuilder().then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)this.getShortFlag()).redirect(commandNode, ctx -> ClientCommandHelper.withFlag((FabricClientCommandSource)ctx.getSource(), this, value.apply(ctx)))).executes(commandNode.getCommand())));
        }
    }

    public void addToCommandWithArg(CommandDispatcher<FabricClientCommandSource> dispatcher, LiteralCommandNode<FabricClientCommandSource> commandNode, ArgumentType<T> argument) {
        dispatcher.register((LiteralArgumentBuilder)commandNode.createBuilder().then(ClientCommandManager.literal((String)this.getFlag()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)this.name, argument).redirect(commandNode, ctx -> ClientCommandHelper.withFlag((FabricClientCommandSource)ctx.getSource(), this, ctx.getArgument(this.name, this.type)))).executes(commandNode.getCommand()))));
        if (this.shortName != null) {
            dispatcher.register((LiteralArgumentBuilder)commandNode.createBuilder().then(ClientCommandManager.literal((String)this.getShortFlag()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)this.name, argument).redirect(commandNode, ctx -> ClientCommandHelper.withFlag((FabricClientCommandSource)ctx.getSource(), this, ctx.getArgument(this.name, this.type)))).executes(commandNode.getCommand()))));
        }
    }

    public static <S> S getActualSource(ParseResults<S> parse) {
        return Flag.getActualSource(parse.getContext().build(parse.getReader().getString()));
    }

    public static <S> S getActualSource(CommandContext<S> ctx) {
        if (ctx.getRootNode() == Objects.requireNonNull(class_310.method_1551().method_1562()).method_2886().getRoot()) {
            return Flag.getActualSource(Objects.requireNonNull(ClientCommandManager.getActiveDispatcher()).parse(StringRange.encompassing((StringRange)ctx.getRange(), (StringRange)ctx.getLastChild().getRange()).get(ctx.getInput()), (Object)((FabricClientCommandSource)ctx.getSource())));
        }
        Object source = ctx.getSource();
        do {
            RedirectModifier redirectModifier;
            if (!ctx.hasNodes() || (redirectModifier = ctx.getRedirectModifier()) == null) continue;
            try {
                Collection newSources = redirectModifier.apply(ctx.copyFor(source));
                if (newSources.size() != 1) {
                    return (S)source;
                }
                source = newSources.iterator().next();
            }
            catch (CommandSyntaxException e) {
                return (S)source;
            }
        } while ((ctx = ctx.getChild()) != null);
        return (S)source;
    }

    public static final class Builder<T> {
        private static final Pattern NAME_PATTERN = Pattern.compile("[a-z0-9][a-z0-9-]*");
        private final Class<T> type;
        private final String name;
        private @Nullable Character shortName;
        private boolean hasSetDefaultValue = false;
        private T defaultValue;
        private boolean repeatable;

        private Builder(Class<T> type, String name) {
            if (!NAME_PATTERN.matcher(name).matches()) {
                throw new IllegalArgumentException("Flag name does not match the pattern " + NAME_PATTERN.pattern());
            }
            this.type = type;
            this.name = name;
            this.shortName = Character.valueOf(name.charAt(0));
        }

        public Builder<T> withNoShortName() {
            this.shortName = null;
            return this;
        }

        public Builder<T> withShortName(char shortName) {
            this.shortName = Character.valueOf(shortName);
            return this;
        }

        public Builder<T> withDefaultValue(T defaultValue) {
            this.hasSetDefaultValue = true;
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> repeatable() {
            this.repeatable = true;
            return this;
        }

        public Flag<T> build() {
            if (!this.hasSetDefaultValue) {
                throw new IllegalStateException("Default value for flag not set");
            }
            return new Flag<T>(this.type, this.name, this.shortName, this.defaultValue, this.repeatable);
        }
    }
}

