/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.xpple.clientarguments.arguments.CItemArgument;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2290;
import net.minecraft.class_2561;
import net.minecraft.class_636;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class CGiveCommand {
    private static final SimpleCommandExceptionType NOT_CREATIVE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cgive.notCreative"));
    private static final SimpleCommandExceptionType NO_SPACE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cgive.noSpace"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cgive").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"item", (ArgumentType)CItemArgument.itemStack((class_7157)context)).executes(ctx -> CGiveCommand.give((FabricClientCommandSource)ctx.getSource(), CItemArgument.getItemStackArgument((CommandContext)ctx, (String)"item"), 1))).then(ClientCommandManager.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CGiveCommand.give((FabricClientCommandSource)ctx.getSource(), CItemArgument.getItemStackArgument((CommandContext)ctx, (String)"item"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))))));
    }

    private static int give(FabricClientCommandSource source, class_2290 itemInput, int count) throws CommandSyntaxException {
        int prevCount;
        class_746 player = source.getPlayer();
        if (!player.method_68878()) {
            throw NOT_CREATIVE_EXCEPTION.create();
        }
        class_636 interactionManager = source.getClient().field_1761;
        assert (interactionManager != null);
        class_1799 stack = itemInput.method_9781(count, false);
        IntArrayList changedSlots = new IntArrayList();
        int simulatedCount = stack.method_7947();
        do {
            prevCount = simulatedCount;
            int slot = CGiveCommand.getSlotWithRemainingSpace(player.method_31548(), stack, (IntList)changedSlots);
            if (slot == -1) {
                slot = player.method_31548().method_7376();
            }
            if (slot == -1) continue;
            class_1799 stackInSlot = player.method_31548().method_5438(slot);
            simulatedCount = Math.clamp((long)(simulatedCount - (player.method_31548().method_58350(stackInSlot) - stackInSlot.method_7947())), 0, simulatedCount);
            changedSlots.add(slot);
        } while (simulatedCount != 0 && simulatedCount != prevCount);
        if (simulatedCount != 0) {
            throw NO_SPACE_EXCEPTION.create();
        }
        for (int i = 0; i < changedSlots.size(); ++i) {
            int slot = changedSlots.getInt(i);
            stack.method_7939(player.method_31548().method_7385(slot, stack));
            interactionManager.method_2909(player.method_31548().method_5438(slot), CGiveCommand.inventoryToSlotId(slot));
        }
        player.field_7498.method_7623();
        stack = itemInput.method_9781(count, false);
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cgive.success", (Object[])new Object[]{count, stack.method_7954()}));
        return 1;
    }

    private static int getSlotWithRemainingSpace(class_1661 inventory, class_1799 stack, IntList fullSlots) {
        if (inventory.method_7393(inventory.method_5438(inventory.method_67532()), stack) && !fullSlots.contains(inventory.method_67532())) {
            return inventory.method_67532();
        }
        if (inventory.method_7393(inventory.method_5438(40), stack) && !fullSlots.contains(40)) {
            return inventory.method_67532();
        }
        for (int slot = 0; slot < 36; ++slot) {
            if (!inventory.method_7393(inventory.method_5438(slot), stack) || fullSlots.contains(slot)) continue;
            return slot;
        }
        return -1;
    }

    private static int inventoryToSlotId(int inventoryId) {
        return inventoryId < 9 ? 36 + inventoryId : 0 + inventoryId;
    }
}

