/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.c2c;

import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ConversionHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static class RsaEcb {
        public static byte @Nullable [] encrypt(byte[] bytes, PublicKey key) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(1, key);
                return cipher.doFinal(bytes);
            }
            catch (GeneralSecurityException e) {
                LOGGER.error("Error encrypting", (Throwable)e);
                return null;
            }
        }

        public static byte @Nullable [] decrypt(byte[] bytes, PrivateKey key) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(2, key);
                return cipher.doFinal(bytes);
            }
            catch (GeneralSecurityException e) {
                LOGGER.error("Error decrypting", (Throwable)e);
                return null;
            }
        }
    }

    public static class Gzip {
        public static byte @Nullable [] compress(byte @Nullable [] bytes) {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(bytes);
            }
            catch (IOException e) {
                LOGGER.error("Error compressing", (Throwable)e);
                return null;
            }
            return out.toByteArray();
        }

        public static byte @Nullable [] decompress(byte @Nullable [] bytes) {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try (GZIPInputStream ungzip = new GZIPInputStream(in);){
                int n;
                byte[] buffer = new byte[256];
                while ((n = ungzip.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error decompressing", (Throwable)e);
                return null;
            }
            return out.toByteArray();
        }
    }

    public static class BaseUTF8 {
        private static final int UNICODE_LOWER_BOUND = 34;
        private static final int UNICODE_UPPER_BOUND = 1112063;

        public static String toUnicode(byte[] b) {
            StringBuilder sb = new StringBuilder();
            int data = 0;
            int bitPtr = 0;
            for (byte b1 : b) {
                data |= Byte.toUnsignedInt(b1) << bitPtr;
                if ((bitPtr += 8) > 19) {
                    int codePoint = BaseUTF8.mapCodepoint((data & 0xFFFFF) + 34);
                    if (codePoint >= 1112063) {
                        throw new RuntimeException("WHAT?");
                    }
                    data >>= 20;
                    sb.appendCodePoint(codePoint);
                }
                bitPtr %= 20;
            }
            if (bitPtr != 0) {
                int codePoint = BaseUTF8.mapCodepoint((data & 0xFFFFF) + 34);
                if (codePoint >= 1112063) {
                    throw new RuntimeException("WHAT?");
                }
                sb.appendCodePoint(codePoint);
            }
            return sb.toString();
        }

        public static byte[] fromUnicode(String s) {
            int bitLength = s.codePointCount(0, s.length()) * 20;
            int dataLength = (bitLength + 7) / 8;
            byte[] data = new byte[dataLength];
            int dataPtr = 0;
            int i = 0;
            while (i < s.length()) {
                int codepoint = s.codePointAt(i);
                i += Character.charCount(codepoint);
                if (codepoint >= 1112063) {
                    throw new RuntimeException("WHAT?");
                }
                codepoint = BaseUTF8.unmapCodepoint(codepoint);
                int n = dataPtr / 8;
                data[n] = (byte)(data[n] | (codepoint -= 34) << dataPtr % 8);
                int n2 = dataPtr / 8 + 1;
                data[n2] = (byte)(data[n2] | (codepoint >>= 8 - dataPtr % 8));
                int n3 = dataPtr / 8 + 2;
                data[n3] = (byte)(data[n3] | codepoint >> 8);
                dataPtr += 20;
            }
            return Arrays.copyOf(data, dataLength);
        }

        private static int mapCodepoint(int codepoint) {
            if (codepoint < 55296) {
                return codepoint == 167 ? 32 : (codepoint == 127 ? 33 : codepoint);
            }
            return codepoint + 2048;
        }

        private static int unmapCodepoint(int codepoint) {
            if (codepoint < 55296) {
                return codepoint == 32 ? 167 : (codepoint == 33 ? 127 : codepoint);
            }
            return codepoint - 2048;
        }
    }
}

