/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import de.johni0702.minecraft.bobby.FakeChunkManager;
import de.johni0702.minecraft.bobby.FakeChunkStorage;
import de.johni0702.minecraft.bobby.Worlds;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class UpgradeCommand
implements Command<FabricClientCommandSource> {
    public int run(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_310 client = source.getClient();
        class_638 world = source.getWorld();
        ClientChunkManagerExt chunkManager = (ClientChunkManagerExt)world.method_2935();
        FakeChunkManager bobbyChunkManager = chunkManager.bobby_getFakeChunkManager();
        if (bobbyChunkManager == null) {
            source.sendError((class_2561)class_2561.method_43471((String)"bobby.upgrade.not_enabled"));
            return 0;
        }
        Worlds worlds = bobbyChunkManager.getWorlds();
        List<FakeChunkStorage> storages = worlds != null ? worlds.getOutdatedWorlds() : List.of(bobbyChunkManager.getStorage());
        source.sendFeedback((class_2561)class_2561.method_43471((String)"bobby.upgrade.begin"));
        new Thread(() -> {
            for (int i = 0; i < storages.size(); ++i) {
                FakeChunkStorage storage = (FakeChunkStorage)((Object)((Object)storages.get(i)));
                try {
                    storage.upgrade((class_5321<class_1937>)world.method_27983(), new ProgressReported(client, i, storages.size()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    source.sendError(class_2561.method_30163((String)e.getMessage()));
                }
                if (worlds == null) continue;
                client.execute(() -> worlds.markAsUpToDate(storage));
            }
            client.execute(() -> {
                if (worlds != null) {
                    worlds.recheckChunks((class_1937)world, chunkManager.bobby_getRealChunksTracker());
                }
                source.sendFeedback((class_2561)class_2561.method_43471((String)"bobby.upgrade.done"));
                bobbyChunkManager.loadMissingChunksFromCache();
            });
        }, "bobby-upgrade").start();
        return 0;
    }

    private static class ProgressReported
    implements BiConsumer<Integer, Integer> {
        private final class_310 client;
        private final int worldIndex;
        private final int totalWorlds;
        private Instant nextReport = Instant.MIN;
        private int done;
        private int total = Integer.MAX_VALUE;

        public ProgressReported(class_310 client, int worldIndex, int totalWorlds) {
            this.client = client;
            this.worldIndex = worldIndex;
            this.totalWorlds = totalWorlds;
        }

        @Override
        public synchronized void accept(Integer done, Integer total) {
            this.done = Math.max(this.done, done);
            this.total = Math.min(this.total, total);
            Instant now = Instant.now();
            if (now.isAfter(this.nextReport) || this.done == this.total) {
                this.nextReport = now.plus(3L, ChronoUnit.SECONDS);
                class_5250 text = class_2561.method_43469((String)"bobby.upgrade.progress", (Object[])new Object[]{this.done, this.total, this.worldIndex + 1, this.totalWorlds});
                this.client.execute(() -> this.lambda$accept$0((class_2561)text));
            }
        }

        private /* synthetic */ void lambda$accept$0(class_2561 text) {
            this.client.field_1705.method_1743().method_1812(text);
        }
    }
}

