/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.platform.config.internal;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.blay09.mods.balm.fabric.platform.config.internal.FabricConfigLoader;
import net.blay09.mods.balm.fabric.platform.config.internal.FabricConfigSaver;
import net.blay09.mods.balm.platform.config.LoadedConfig;
import net.blay09.mods.balm.platform.config.MutableLoadedConfig;
import net.blay09.mods.balm.platform.config.internal.AbstractBalmConfig;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.event.callback.ServerLifecycleCallback;
import net.blay09.mods.balm.platform.event.internal.BalmSupplementalEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class FabricBalmConfig
extends AbstractBalmConfig {
    private static final Logger logger = LogUtils.getLogger();
    private final AtomicReference<@Nullable MinecraftServer> currentServer = new AtomicReference();

    @Override
    public void registerConfig(BalmConfigSchema schema) {
        super.registerConfig(schema);
        if (!this.isServerScoped(schema)) {
            this.loadLocalConfig(schema);
        } else {
            MutableLoadedConfig defaultConfig = schema.defaults().mutable(schema);
            this.setLocalConfig(schema, defaultConfig);
            this.setActiveConfig(schema, defaultConfig);
            ServerLifecycleCallback.Starting.EVENT.register(server -> {
                this.currentServer.set(server);
                this.loadLocalConfig(schema);
            });
            ServerLifecycleCallback.Stopped.EVENT.register(server -> this.currentServer.set(null));
        }
    }

    private void loadLocalConfig(BalmConfigSchema schema) {
        LoadedConfig config = this.loadConfigFromConfigFile(schema);
        MutableLoadedConfig mutableConfig = config.mutable(schema);
        this.setLocalConfig(schema, mutableConfig);
        this.setActiveConfig(schema, config);
        this.fireConfigLoadHandlers(schema, mutableConfig);
        BalmSupplementalEvents.CONFIG_LOADED.invoker().handle(schema);
    }

    @Override
    public File getConfigDir() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    @Override
    public void saveLocalConfig(BalmConfigSchema schema, MutableLoadedConfig config) {
        super.saveLocalConfig(schema, config);
        File configFile = this.getConfigFile(schema);
        try {
            FabricConfigSaver.save(configFile, schema, config);
        }
        catch (IOException e) {
            logger.error("Failed to save config file {}", (Object)configFile, (Object)e);
        }
        BalmSupplementalEvents.CONFIG_RELOADED.invoker().handle(schema);
    }

    private LoadedConfig loadConfigFromConfigFile(BalmConfigSchema schema) {
        File configFile = this.getConfigFile(schema);
        LoadedConfig config = schema.defaults();
        if (configFile.exists()) {
            try {
                config = FabricConfigLoader.load(configFile, schema);
            }
            catch (IOException e) {
                logger.error("Failed to load config file {}", (Object)configFile, (Object)e);
            }
        } else {
            try {
                FabricConfigSaver.save(configFile, schema, schema.defaults());
            }
            catch (IOException e) {
                logger.error("Failed to generate config file {}", (Object)configFile, (Object)e);
            }
        }
        return config;
    }

    @Override
    public File getConfigDir(BalmConfigSchema schema) {
        if (this.isServerScoped(schema)) {
            MinecraftServer server = this.currentServer.get();
            if (server != null) {
                return server.method_27050(class_5218.field_24188).resolve("serverconfig").toFile();
            }
            throw new IllegalStateException("Cannot get config file for " + String.valueOf(schema) + " without a server running.");
        }
        return super.getConfigDir(schema);
    }

    private boolean isServerScoped(BalmConfigSchema schema) {
        return schema.identifier().method_12832().equals("server");
    }
}

