/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.platform.compatibility.config.internal;

import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.api.ModContext;
import com.mrcrayfish.configured.api.util.ConfigScreenHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.config.MutableLoadedConfig;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategory;
import net.blay09.mods.balm.platform.config.util.ConfigLocalization;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.lang3.ClassUtils;
import org.jspecify.annotations.Nullable;

public class ConfiguredConfigProvider
implements IModConfigProvider {
    private static @Nullable IModConfig mapConfig(final BalmConfigSchema schema, final @Nullable MutableLoadedConfig config) {
        if (config == null) {
            return null;
        }
        return new IModConfig(){

            public ActionResult update(IConfigEntry entry) {
                Balm.config().saveLocalConfig(schema, config);
                return ActionResult.success();
            }

            public IConfigEntry createRootEntry() {
                return ConfiguredConfigProvider.mapConfigSchema(schema, config);
            }

            public ConfigType getType() {
                return ConfigType.UNIVERSAL;
            }

            public String getFileName() {
                return Balm.config().getConfigFile(schema).getName();
            }

            public String getModId() {
                return schema.identifier().method_12836();
            }
        };
    }

    private static IConfigEntry mapConfigSchema(final BalmConfigSchema schema, MutableLoadedConfig config) {
        final ArrayList<IConfigEntry> children = new ArrayList<IConfigEntry>();
        for (ConfiguredProperty<?> rootProperty : schema.rootProperties()) {
            children.add(ConfiguredConfigProvider.mapConfigProperty(config, rootProperty));
        }
        for (ConfigCategory category : schema.categories()) {
            children.add(ConfiguredConfigProvider.mapConfigCategory(config, category));
        }
        return new IConfigEntry(){

            public List<IConfigEntry> getChildren() {
                return children;
            }

            public boolean isRoot() {
                return true;
            }

            public boolean isLeaf() {
                return false;
            }

            public @Nullable IConfigValue<?> getValue() {
                return null;
            }

            public String getEntryName() {
                return "";
            }

            public @Nullable class_2561 getTooltip() {
                return null;
            }

            public String getTranslationKey() {
                return ConfigLocalization.forTitle(schema);
            }
        };
    }

    private static IConfigEntry mapConfigCategory(MutableLoadedConfig config, final ConfigCategory category) {
        final List<IConfigEntry> children = category.properties().stream().map(property -> ConfiguredConfigProvider.mapConfigProperty(config, property)).toList();
        return new IConfigEntry(){

            public List<IConfigEntry> getChildren() {
                return children;
            }

            public boolean isRoot() {
                return false;
            }

            public boolean isLeaf() {
                return false;
            }

            public @Nullable IConfigValue<?> getValue() {
                return null;
            }

            public String getEntryName() {
                return category.name();
            }

            public @Nullable class_2561 getTooltip() {
                return null;
            }

            public String getTranslationKey() {
                return ConfigLocalization.forCategory(category);
            }
        };
    }

    private static <T> IConfigEntry mapConfigProperty(final MutableLoadedConfig config, final ConfiguredProperty<T> property) {
        final T initialValue = config.getRaw(property);
        return new IConfigEntry(){

            public List<IConfigEntry> getChildren() {
                return List.of();
            }

            public boolean isRoot() {
                return false;
            }

            public boolean isLeaf() {
                return true;
            }

            public IConfigValue<?> getValue() {
                return new IConfigValue<T>(){

                    public T get() {
                        return config.getRaw(property);
                    }

                    public T getDefault() {
                        return property.defaultValue();
                    }

                    public void set(T o) {
                        config.setRaw(property, o);
                    }

                    public boolean isValid(T o) {
                        return ClassUtils.isAssignable(o.getClass(), property.type(), (boolean)true);
                    }

                    public boolean isDefault() {
                        return Objects.equals(property.defaultValue(), config.getRaw(property));
                    }

                    public boolean isChanged() {
                        return !Objects.equals(config.getRaw(property), initialValue);
                    }

                    public void restore() {
                        config.setRaw(property, property.defaultValue());
                    }

                    public class_2561 getComment() {
                        return class_2561.method_43471((String)ConfigLocalization.forPropertyTooltip(property));
                    }

                    public String getTranslationKey() {
                        return ConfigLocalization.forProperty(property);
                    }

                    public @Nullable class_2561 getValidationHint() {
                        return null;
                    }

                    public String getName() {
                        return property.name();
                    }

                    public void cleanCache() {
                    }

                    public boolean requiresWorldRestart() {
                        return false;
                    }

                    public boolean requiresGameRestart() {
                        return false;
                    }
                };
            }

            public String getEntryName() {
                return property.category() + "." + property.name();
            }

            public class_2561 getTooltip() {
                return class_2561.method_43471((String)ConfigLocalization.forPropertyTooltip(property));
            }

            public String getTranslationKey() {
                return ConfigLocalization.forPropertyTooltip(property);
            }
        };
    }

    public static class_437 createConfigScreen(String modId, class_437 parent) {
        Collection<BalmConfigSchema> configs = Balm.config().getSchemasByNamespace(modId);
        HashMap configsByType = new HashMap();
        Set universalConfigs = configs.stream().filter(it -> !it.identifier().method_12832().equals("client")).map(schema -> ConfiguredConfigProvider.mapConfig(schema, Balm.config().getLocalConfig((BalmConfigSchema)schema))).filter(Objects::nonNull).collect(Collectors.toSet());
        Set clientConfigs = configs.stream().filter(it -> it.identifier().method_12832().equals("client")).map(schema -> ConfiguredConfigProvider.mapConfig(schema, Balm.config().getLocalConfig((BalmConfigSchema)schema))).filter(Objects::nonNull).collect(Collectors.toSet());
        configsByType.put(ConfigType.UNIVERSAL, universalConfigs);
        configsByType.put(ConfigType.CLIENT, clientConfigs);
        return ConfigScreenHelper.createSelectionScreen((class_437)parent, (class_2561)class_2561.method_43471((String)ConfigLocalization.forTitle(modId)), configsByType);
    }

    public Set<IModConfig> getConfigurationsForMod(ModContext modContext) {
        Collection<BalmConfigSchema> configs = Balm.config().getSchemasByNamespace(modContext.modId());
        return configs.stream().map(schema -> ConfiguredConfigProvider.mapConfig(schema, Balm.config().getLocalConfig((BalmConfigSchema)schema))).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

