/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.utils.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.audioplayer.AudioPlayerMod;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Deprecated
public class VolumeOverrideManager {
    private final Path file;
    private final Gson gson;
    private Map<UUID, Float> volumes;
    private static final float LOG_BASE = 2.0f;

    public VolumeOverrideManager(Path file) {
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
        this.volumes = new HashMap<UUID, Float>();
        this.load();
    }

    private void load() {
        if (!Files.exists(this.file, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.file);){
            Type fileNameMapType = new TypeToken<Map<UUID, Float>>(this){}.getType();
            this.volumes = (Map)this.gson.fromJson((Reader)reader, fileNameMapType);
        }
        catch (Exception e) {
            AudioPlayerMod.LOGGER.error("Failed to load volume overrides", (Throwable)e);
        }
        if (this.volumes == null) {
            this.volumes = new HashMap<UUID, Float>();
        }
    }

    public Map<UUID, Float> getVolumes() {
        return this.volumes;
    }

    public static float convertToLinearScaleFactor(float logarithmicScaleFactor) {
        if (logarithmicScaleFactor <= 0.0f) {
            return 0.0f;
        }
        return 1.0f + (float)(Math.log10(logarithmicScaleFactor) / 2.0);
    }
}

