/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.mixin;

import de.maxhenkel.audioplayer.api.ChannelReference;
import de.maxhenkel.audioplayer.api.events.AudioEvents;
import de.maxhenkel.audioplayer.audioloader.AudioData;
import de.maxhenkel.audioplayer.audioplayback.PlayerManager;
import de.maxhenkel.audioplayer.audioplayback.PlayerType;
import de.maxhenkel.audioplayer.interfaces.CustomJukeboxSongPlayer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_6880;
import net.minecraft.class_9793;
import net.minecraft.class_9794;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9794.class})
public abstract class JukeboxSongPlayerMixin
implements CustomJukeboxSongPlayer {
    @Shadow
    @Nullable
    private class_6880<class_9793> field_52034;
    @Shadow
    @Final
    private class_9794.class_9795 field_52036;
    @Shadow
    private long field_52033;
    @Shadow
    @Final
    private class_2338 field_52035;
    @Unique
    @Nullable
    private UUID channelId;

    @Override
    public boolean audioplayer$customPlay(class_3218 level, class_1799 item) {
        AudioData data = AudioData.of(item);
        if (data == null) {
            return false;
        }
        ChannelReference<?> channel = PlayerManager.instance().playType(level, null, data, PlayerType.MUSIC_DISC, AudioEvents.PLAY_MUSIC_DISC, AudioEvents.POST_PLAY_MUSIC_DISC, this.field_52035.method_46558());
        if (channel == null) {
            return false;
        }
        this.channelId = channel.getChannel().getId();
        this.field_52034 = null;
        this.field_52033 = 0L;
        this.field_52036.notifyChange();
        return true;
    }

    @Override
    public boolean audioplayer$customStop() {
        if (this.channelId == null) {
            return false;
        }
        PlayerManager.instance().stop(this.channelId);
        this.channelId = null;
        this.field_52034 = null;
        this.field_52033 = 0L;
        this.field_52036.notifyChange();
        return true;
    }

    @Inject(method={"method_60754()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isPlaying(CallbackInfoReturnable<Boolean> cir) {
        if (this.channelId == null) {
            return;
        }
        cir.setReturnValue((Object)(!PlayerManager.instance().isStopped(this.channelId) ? 1 : 0));
    }

    @Inject(method={"method_60760(Lnet/minecraft/class_1936;Lnet/minecraft/class_2680;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(class_1936 levelAccessor, class_2680 blockState, CallbackInfo ci) {
        if (this.channelId == null) {
            return;
        }
        ci.cancel();
        if (!this.method_60754()) {
            if (this.channelId != null) {
                this.audioplayer$customStop();
            }
            return;
        }
        if (this.method_60763()) {
            JukeboxSongPlayerMixin.method_60756(levelAccessor, this.field_52035);
        }
        ++this.field_52033;
    }

    @Override
    public void audioplayer$onSave(class_1799 item, class_11372 valueOutput) {
        if (this.channelId != null && !item.method_7960()) {
            valueOutput.method_71468("ChannelID", class_4844.field_25122, (Object)this.channelId);
        }
    }

    @Override
    public void audioplayer$onLoad(class_1799 item, class_11368 valueInput) {
        UUID id = valueInput.method_71426("ChannelID", class_4844.field_25122).orElse(null);
        if (id != null && !item.method_7960()) {
            this.channelId = id;
            this.field_52034 = null;
        } else {
            this.channelId = null;
        }
    }

    @Shadow
    public abstract boolean method_60754();

    @Shadow
    protected abstract boolean method_60763();

    @Shadow
    private static void method_60756(class_1936 levelAccessor, class_2338 blockPos) {
    }
}

