/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.audioloader.AudioData;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.audioloader.Metadata;
import de.maxhenkel.audioplayer.audioplayback.PlayerType;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.utils.ChatUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Command(value={"audioplayer"})
public class UtilityCommands {
    @RequiresPermission(value="audioplayer.apply")
    @Command(value={"clear"})
    public void clear(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        PlayerType playerType = PlayerType.fromItemStack(itemInHand);
        if (playerType == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.invalid_item", new Object[0]));
            return;
        }
        if (!AudioData.clearItem(((class_2168)context.getSource()).method_9211(), itemInHand)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.item_no_audio", new Object[0]));
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.item_clear_successful", new Object[0]), false);
    }

    @Command(value={"id"})
    public void id(CommandContext<class_2168> context) throws CommandSyntaxException {
        UUID id = UtilityCommands.getHeldItemId(context);
        if (id == null) {
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> ChatUtils.createApplyMessage(id, Lang.translatable("audioplayer.extract_sound_id_successful", new Object[0])), false);
    }

    @Command(value={"info"})
    public void info(CommandContext<class_2168> context, @Name(value="id") UUID id) {
        if (!AudioStorageManager.instance().checkSoundExists(id)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.no_audio_file_id_found", id.toString()));
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> ChatUtils.createInfoMessage(id), false);
    }

    @Command(value={"info"})
    public void info(CommandContext<class_2168> context) throws CommandSyntaxException {
        UUID id = UtilityCommands.getHeldItemId(context);
        if (id == null) {
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> ChatUtils.createInfoMessage(id), false);
    }

    @Command(value={"search"})
    public void search(CommandContext<class_2168> context, @Name(value="file_name") String name) throws CommandSyntaxException {
        List<Metadata> metadata = AudioStorageManager.metadataManager().getByFileName(name, false);
        if (metadata.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.no_audio_files_name_found", name));
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.search_results", metadata.size(), name), false);
        for (Metadata meta : metadata) {
            ((class_2168)context.getSource()).method_9226(() -> ChatUtils.createInfoMessage(meta.getAudioId()), false);
        }
    }

    public static UUID getHeldItemId(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        AudioData data = AudioData.of(itemInHand);
        if (data == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.item_no_audio", new Object[0]));
            return null;
        }
        UUID actualSoundId = data.getActualSoundId();
        if (actualSoundId == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.item_no_audio_id", new Object[0]));
            return null;
        }
        return actualSoundId;
    }
}

