/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Min;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.OptionalArgument;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.api.AudioPlayerModule;
import de.maxhenkel.audioplayer.audioloader.AudioData;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.audioloader.Metadata;
import de.maxhenkel.audioplayer.audioplayback.PlayerType;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.utils.ChatUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

@Command(value={"audioplayer"})
@RequiresPermission(value="audioplayer.apply")
public class ApplyCommands {
    @Command(value={"apply"})
    public void apply(CommandContext<class_2168> context, @Name(value="file_name") String fileName, @OptionalArgument @Name(value="custom_name") String customName) throws CommandSyntaxException {
        UUID id = ApplyCommands.getId(context, fileName);
        if (id == null) {
            return;
        }
        ApplyCommands.applyBulk(context, AudioData.withSoundAndRange(id, null), customName);
    }

    @Command(value={"apply"})
    public void apply(CommandContext<class_2168> context, @Name(value="sound_id") UUID sound, @OptionalArgument @Name(value="custom_name") String customName) throws CommandSyntaxException {
        ApplyCommands.applyBulk(context, AudioData.withSoundAndRange(sound, null), customName);
    }

    @Command(value={"range"})
    public void range(CommandContext<class_2168> context, @Name(value="range") @Min(value="0") float range) throws CommandSyntaxException {
        int amount = ApplyCommands.forEachHeldAudioItem(context, AudioData::of, (itemStack, data) -> {
            Optional<AudioPlayerModule> module = data.getModule(AudioPlayerModule.KEY);
            if (module.isEmpty()) {
                return false;
            }
            AudioPlayerModule oldMod = module.get();
            AudioPlayerModule mod = new AudioPlayerModule(oldMod.getSoundId(), Float.valueOf(range));
            data.setModule(AudioPlayerModule.KEY, mod);
            data.saveToItem(itemStack);
            return true;
        });
        ApplyCommands.sendUpdateFeedBack(context, amount);
    }

    @Nullable
    private static UUID getId(CommandContext<class_2168> context, String fileName) {
        try {
            return UUID.fromString(fileName);
        }
        catch (Exception exception) {
            List<Metadata> metadata = AudioStorageManager.metadataManager().getByFileName(fileName, true);
            if (metadata.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.no_audio_file_name_found", fileName));
                return null;
            }
            if (metadata.size() == 1) {
                return metadata.getFirst().getAudioId();
            }
            ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.multiple_audio_files_name_found", fileName), false);
            for (Metadata meta : metadata) {
                ((class_2168)context.getSource()).method_9226(() -> ChatUtils.createInfoMessage(meta.getAudioId()), false);
            }
            return null;
        }
    }

    private static <T> int forEachHeldAudioItem(CommandContext<class_2168> context, Function<class_1799, T> shouldProcess, ApplyFunction<T> process) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        class_9276 bundle = (class_9276)itemInHand.method_58694(class_9334.field_49650);
        if (bundle != null) {
            List bundleContents = bundle.method_59707().toList();
            int amount = 0;
            for (class_1799 itemStack : bundleContents) {
                T value = shouldProcess.apply(itemStack);
                if (value == null || !process.apply(itemStack, value)) continue;
                ++amount;
            }
            itemInHand.method_57379(class_9334.field_49650, (Object)new class_9276(bundleContents));
            return amount;
        }
        class_9288 contents = (class_9288)itemInHand.method_58694(class_9334.field_49622);
        if (contents != null) {
            class_2371 shulkerContents = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
            contents.method_57492(shulkerContents);
            int amount = 0;
            for (class_1799 itemStack : shulkerContents) {
                T value = shouldProcess.apply(itemStack);
                if (value == null || !process.apply(itemStack, value)) continue;
                ++amount;
            }
            itemInHand.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)shulkerContents));
            return amount;
        }
        T value = shouldProcess.apply(itemInHand);
        if (value == null) {
            return -1;
        }
        process.apply(itemInHand, value);
        return 1;
    }

    private static void applyBulk(CommandContext<class_2168> context, AudioData data, @Nullable String customName) throws CommandSyntaxException {
        UUID id = data.getActualSoundId();
        if (id == null || !AudioStorageManager.instance().checkSoundExists(id)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.no_audio_file_id_found", id == null ? "N/A" : id.toString()));
            return;
        }
        int amount = ApplyCommands.forEachHeldAudioItem(context, PlayerType::fromItemStack, (itemStack, playerType) -> ApplyCommands.applyToSingleItem(itemStack, playerType, data, customName));
        ApplyCommands.sendUpdateFeedBack(context, amount);
    }

    private static void sendUpdateFeedBack(CommandContext<class_2168> context, int amount) {
        if (amount < 0) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.no_valid_item_in_hand", new Object[0]));
        } else if (amount == 0) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.no_valid_items_found", new Object[0]));
        } else if (amount == 1) {
            ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.item_update_successful", new Object[0]), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.item_updates_successful", amount), false);
        }
    }

    private static boolean applyToSingleItem(class_1799 stack, PlayerType type, AudioData data, @Nullable String customName) throws CommandSyntaxException {
        ApplyCommands.checkRange(type.getMaxRange(), data.getRange());
        if (!type.isValid(stack)) {
            return false;
        }
        data.saveToItem(stack, customName);
        return true;
    }

    private static void checkRange(ConfigEntry<Float> maxRange, @Nullable Float range) throws CommandSyntaxException {
        if (range == null) {
            return;
        }
        if (range.floatValue() > maxRange.get().floatValue()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.floatTooHigh().create((Object)range, (Object)maxRange.get());
        }
    }

    private static interface ApplyFunction<T> {
        public boolean apply(class_1799 var1, T var2) throws CommandSyntaxException;
    }
}

