/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioloader.importer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.api.importer.AudioImportInfo;
import de.maxhenkel.audioplayer.api.importer.AudioImporter;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.utils.ChatUtils;
import de.maxhenkel.audioplayer.utils.ComponentException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class FilebinImporter
implements AudioImporter {
    public static final String USER_AGENT = "AudioPlayer/curl";
    private final UUID soundId;
    @Nullable
    private URL fileUrl;

    public FilebinImporter(UUID soundId) {
        this.soundId = soundId;
    }

    @Override
    public AudioImportInfo onPreprocess(@Nullable class_3222 player) throws Exception {
        URI url = FilebinImporter.getBin(this.soundId);
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(url).header("Accept", "application/json").header("User-Agent", USER_AGENT).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("%s responded with status %s".formatted(url, response.statusCode()));
            }
            JsonElement json = JsonParser.parseString((String)response.body());
            if (!(json instanceof JsonObject)) {
                throw new IOException("Invalid response");
            }
            JsonObject object = (JsonObject)json;
            JsonElement filesElement = object.get("files");
            if (filesElement == null) {
                throw new ComponentException((class_2561)Lang.translatable("audioplayer.no_files_uploaded", new Object[0]));
            }
            if (!(filesElement instanceof JsonArray)) {
                throw new ComponentException((class_2561)Lang.translatable("audioplayer.no_files_uploaded", new Object[0]));
            }
            JsonArray files = (JsonArray)filesElement;
            for (JsonElement element : files) {
                if (!(element instanceof JsonObject)) continue;
                JsonObject file = (JsonObject)element;
                String contentType = file.get("content-type").getAsString();
                if (!contentType.equals("audio/wav") && !contentType.equals("audio/mpeg")) continue;
                long size = file.get("bytes").getAsLong();
                ChatUtils.checkFileSize(size);
                String filename = file.get("filename").getAsString();
                URI uri = new URI(String.valueOf(url) + "/" + new URI(null, null, filename, null).toASCIIString());
                this.fileUrl = uri.toURL();
                AudioImportInfo audioImportInfo = new AudioImportInfo(this.soundId, filename);
                return audioImportInfo;
            }
            throw new ComponentException((class_2561)Lang.translatable("audioplayer.no_valid_audio_files_uploaded", new Object[0]));
        }
    }

    @Override
    public byte[] onProcess(@Nullable class_3222 player) throws Exception {
        if (this.fileUrl == null) {
            throw new IOException("File URL not found");
        }
        HttpURLConnection connection = (HttpURLConnection)this.fileUrl.openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.connect();
        try (InputStream is = connection.getInputStream();){
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    @Override
    public void onPostprocess(@Nullable class_3222 player) throws Exception {
        if (this.fileUrl != null) {
            FilebinImporter.deleteBin(this.fileUrl.toURI());
        }
    }

    @Override
    public String getHandlerName() {
        return "filebin";
    }

    public static void deleteBin(URI url) {
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(url).header("Accept", "application/json").header("User-Agent", USER_AGENT).DELETE().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("%s responded with status %s".formatted(url, response.statusCode()));
            }
        }
        catch (Exception e) {
            AudioPlayerMod.LOGGER.warn("Failed to delete bin '{}'", (Object)url, (Object)e);
        }
    }

    public static URI getBin(UUID sound) {
        Object filebinUrl = AudioPlayerMod.SERVER_CONFIG.filebinUrl.get();
        if (!((String)filebinUrl).endsWith("/")) {
            filebinUrl = (String)filebinUrl + "/";
        }
        return URI.create((String)filebinUrl + String.valueOf(sound));
    }

    public static void sendFilebinUploadMessage(class_2168 stack) {
        UUID uuid = UUID.randomUUID();
        URI uploadURL = FilebinImporter.getBin(uuid);
        class_5250 msg = Lang.translatable("audioplayer.upload_filebin_instructions", Lang.translatable("audioplayer.this_link", new Object[0]).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(uploadURL)).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_open", new Object[0])))).method_27692(class_124.field_1060), class_2561.method_43470((String)"mp3").method_27692(class_124.field_1080), class_2561.method_43470((String)"wav").method_27692(class_124.field_1080), Lang.translatable("audioplayer.here", new Object[0]).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer filebin " + String.valueOf(uuid))).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_confirm_upload", new Object[0])))).method_27692(class_124.field_1060));
        stack.method_9226(() -> msg, false);
    }
}

