/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.admiral.MinecraftAdmiral;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeConverter;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeSupplier;
import de.maxhenkel.admiral.permissions.PermissionManager;
import de.maxhenkel.audioplayer.api.AudioPlayerModule;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.command.ApplyCommands;
import de.maxhenkel.audioplayer.command.PlayCommands;
import de.maxhenkel.audioplayer.command.ServerFileArgument;
import de.maxhenkel.audioplayer.command.UploadCommands;
import de.maxhenkel.audioplayer.command.UtilityCommands;
import de.maxhenkel.audioplayer.command.VolumeCommands;
import de.maxhenkel.audioplayer.config.ServerConfig;
import de.maxhenkel.audioplayer.configbuilder.ConfigBuilder;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.permission.AudioPlayerPermissionManager;
import de.maxhenkel.audioplayer.webserver.WebServerEvents;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_7157;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AudioPlayerMod
implements ModInitializer {
    public static final String MODID = "audioplayer";
    public static final Logger LOGGER = LogManager.getLogger((String)"audioplayer");
    public static ServerConfig SERVER_CONFIG;

    public void onInitialize() {
        SERVER_CONFIG = ConfigBuilder.builder(ServerConfig::new).path(AudioPlayerMod.getModConfigFolder().resolve("audioplayer-server.properties")).migration(ServerConfig::migrate).build();
        Lang.onInitialize();
        WebServerEvents.onInitialize();
        AudioStorageManager.onInitialize();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MinecraftAdmiral.builder((CommandDispatcher)dispatcher, (class_7157)registryAccess).addCommandClasses(new Class[]{UploadCommands.class, ApplyCommands.class, UtilityCommands.class, VolumeCommands.class, PlayCommands.class}).setPermissionManager((PermissionManager)AudioPlayerPermissionManager.INSTANCE).addArgumentTypes(registry -> registry.register(ServerFileArgument.class, (ArgumentTypeSupplier)new ServerFileArgument.ServerFileArgumentSupplier(), (ArgumentTypeConverter)new ServerFileArgument.ServerFileArgumentTypeConverter())).build());
        AudioPlayerModule.onInitialize();
    }

    public static Path getModConfigFolder() {
        return FabricLoader.getInstance().getConfigDir().resolve(MODID);
    }
}

