/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3544;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.EmptyAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.api.callback.JadeBeforeTooltipCollectCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.BoxElementImpl;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;
import snownee.jade.track.ProgressTracker;
import snownee.jade.util.ClientProxy;

public class WailaTickHandler {
    public static final String REMOVE_ELEMENTS = "$jade:remove";
    public static final MapCodec<List<class_2960>> REMOVE_ELEMENTS_CODEC = class_2960.field_25139.listOf().fieldOf("$jade:remove");
    private String lastNarration = "";
    private long lastNarrationTime = 0L;
    public ProgressTracker progressTracker = new ProgressTracker();
    public @Nullable BoxElementImpl rootElement;
    public @Nullable State state;

    public void narrate(Element element, boolean dedupe) {
        if (System.currentTimeMillis() - this.lastNarrationTime < 500L) {
            return;
        }
        class_2561 component = element.cachedNarration();
        if (component == null) {
            return;
        }
        this.narrate(class_3544.method_15440((String)component.getString()), dedupe);
        this.lastNarrationTime = System.currentTimeMillis();
    }

    public void narrate(String message, boolean dedupe) {
        if (message.isEmpty()) {
            return;
        }
        if (dedupe && message.equals(this.lastNarration)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            class_333 narrator = class_310.method_1551().method_44713();
            narrator.method_37016(message);
            if (IWailaConfig.get().general().isDebug()) {
                Jade.LOGGER.info("Narrating: {}", (Object)message);
            }
            if (narrator.method_1791()) {
                narrator.method_1793();
                narrator.method_66522(message, true);
            }
        });
        this.lastNarration = message;
    }

    public void clearState() {
        this.lastNarration = "";
        this.state = null;
        this.rootElement = null;
        this.progressTracker.clear();
    }

    public void tickClient() {
        Accessor<class_3965> accessor;
        class_3965 blockTarget;
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            OverlayRenderer.clearLingerTooltip();
            this.clearState();
            return;
        }
        this.progressTracker.tick();
        IWailaConfig.General config = IWailaConfig.get().general();
        if (!config.shouldDisplayTooltip()) {
            this.clearState();
            return;
        }
        if (JadeUI.isPinned()) {
            return;
        }
        if (!ClientProxy.shouldShowWithGui(mc, mc.field_1755)) {
            return;
        }
        class_1297 entity = mc.method_1560();
        if (entity == null) {
            this.clearState();
            return;
        }
        RayTracing.INSTANCE.fire();
        class_239 target = RayTracing.INSTANCE.getTarget();
        if (target == null) {
            this.clearState();
            return;
        }
        boolean useRayTraceCallback = true;
        if (target instanceof class_3965 && (blockTarget = (class_3965)target).method_17783() != class_239.class_240.field_1333) {
            class_2680 state = level.method_8320(blockTarget.method_17777());
            if (state.method_26215()) {
                accessor = WailaTickHandler.createEmpty(target);
            } else {
                class_2586 tileEntity = level.method_8321(blockTarget.method_17777());
                accessor = WailaClientRegistration.instance().blockAccessor().blockState(state).blockEntity(tileEntity).hit(blockTarget).requireVerification().build();
            }
        } else if (target instanceof class_3966) {
            class_3966 entityTarget = (class_3966)target;
            accessor = WailaClientRegistration.instance().entityAccessor().hit(entityTarget).entity(entityTarget.method_17782()).requireVerification().build();
        } else if (mc.field_1755 instanceof PreviewOptionsScreen) {
            useRayTraceCallback = false;
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(class_2246.field_10219.method_9564()).hit(new class_3965(entity.method_73189(), class_2350.field_11036, entity.method_24515(), false)).build();
        } else {
            accessor = WailaTickHandler.createEmpty(target);
        }
        if (useRayTraceCallback) {
            EmptyAccessor emptyAccessor;
            Accessor<class_3965> originalAccessor = accessor;
            if (originalAccessor instanceof EmptyAccessor) {
                EmptyAccessor emptyAccessor2 = originalAccessor;
                emptyAccessor = emptyAccessor2;
            } else {
                emptyAccessor = null;
            }
            EmptyAccessor originalEmpty = emptyAccessor;
            for (JadeRayTraceCallback callback : WailaClientRegistration.instance().rayTraceCallback.callbacks()) {
                accessor = callback.onRayTrace(target, accessor, originalAccessor);
                if (accessor != null) continue;
                if (originalEmpty == null) {
                    originalEmpty = WailaTickHandler.createEmpty(originalAccessor.getHitResult());
                }
                accessor = originalEmpty;
            }
        }
        if (!accessor.verifyData(accessor.getServerData())) {
            accessor.setServerData(null);
        }
        ObjectDataCenter.set(accessor);
        AccessorClientHandler<Accessor<?>> handler = WailaClientRegistration.instance().getAccessorHandler(accessor.getAccessorType());
        if (!handler.shouldDisplay(accessor)) {
            this.clearState();
            return;
        }
        this.state = State.create(this.state, accessor, handler, this.state == null ? null : this.state.data);
        if (accessor.isServerConnected()) {
            class_2487 data = accessor.getServerData();
            accessor.setServerData(null);
            List providers = handler.shouldRequestData(accessor);
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (!providers.isEmpty()) {
                    handler.requestData(accessor, providers);
                }
            }
            if (!providers.isEmpty() && this.getData() == null) {
                return;
            }
            accessor.setServerData(data);
        }
        Theme theme = IWailaConfig.get().overlay().getTheme();
        MutableObject holder = new MutableObject((Object)theme);
        Preconditions.checkNotNull((Object)theme, (Object)"Theme cannot be null");
        Accessor<class_3965> accessor0 = accessor;
        for (JadeBeforeTooltipCollectCallback callback : WailaClientRegistration.instance().beforeTooltipCollectCallback.callbacks()) {
            if (callback.beforeCollecting((MutableObject<Theme>)holder, accessor0)) continue;
            return;
        }
        Preconditions.checkNotNull((Object)((Theme)holder.getValue()), (Object)"Theme cannot be null");
        IThemeHelper themes = IThemeHelper.get();
        if (theme != holder.getValue()) {
            theme = (Theme)holder.getValue();
            themes.setThemeOverride(theme);
        }
        Tooltip tooltip = new Tooltip();
        tooltip.setIcon(this.state.getIcon());
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            handler.gatherComponents(accessor, $ -> {
                if (Math.abs(WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            handler.gatherComponents(accessor, $ -> tooltip);
        }
        if (accessor.isServersideContent()) {
            class_9279 data = (class_9279)accessor.getServersideRep().method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            if (data.field_49306.method_10545(REMOVE_ELEMENTS)) {
                List list = data.field_49306.method_67487(REMOVE_ELEMENTS_CODEC).orElse(List.of());
                for (class_2960 tag : list) {
                    tooltip.remove(tag);
                }
            }
        }
        tooltip.setIcon(themes.theme().modifyIcon(tooltip.getIcon()));
        BoxElementImpl newElement = new BoxElementImpl(tooltip, themes.theme().tooltipStyle);
        newElement.tag(JadeIds.ROOT);
        for (JadeTooltipCollectedCallback callback : WailaClientRegistration.instance().tooltipCollectedCallback.callbacks()) {
            callback.onTooltipCollected(newElement, accessor);
        }
        if (this.rootElement == null || this.rootElement.layout.method_46426() != newElement.layout.method_46426() || this.rootElement.layout.method_46427() != newElement.layout.method_46427() || this.rootElement.layout.method_25368() != newElement.layout.method_25368() || this.rootElement.layout.method_25364() != newElement.layout.method_25364()) {
            OverlayRenderer.animation.startRect.copy(OverlayRenderer.animation.rect);
            OverlayRenderer.animation.startTime = System.currentTimeMillis();
        }
        this.rootElement = newElement;
        themes.setThemeOverride(null);
    }

    private static EmptyAccessor createEmpty(class_239 hit) {
        class_3965 miss;
        class_3965 blockHitResult;
        if (hit instanceof class_3965 && (blockHitResult = (class_3965)hit).method_17783() == class_239.class_240.field_1333) {
            miss = blockHitResult;
        } else {
            class_243 vec = hit.method_17784();
            miss = class_3965.method_17778((class_243)vec, (class_2350)class_2350.method_10142((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350), (class_2338)class_2338.method_49638((class_2374)vec));
        }
        return WailaClientRegistration.instance().emptyAccessor().hit(miss).build();
    }

    public void setData(class_2487 tag) {
        if (this.state == null) {
            return;
        }
        this.state = this.state.withData(tag);
    }

    public @Nullable class_2487 getData() {
        return this.state == null ? null : this.state.data;
    }

    public record State(Accessor<?> accessor, AccessorClientHandler<Accessor<?>> handler, @Nullable class_2487 data) {
        public static State create(@Nullable State prev, Accessor<?> accessor, AccessorClientHandler<Accessor<?>> handler, @Nullable class_2487 data) {
            return new State(accessor, handler, data != null && accessor.verifyData(data) ? data : null);
        }

        public @Nullable Element getIcon() {
            if (this.accessor == null || this.handler == null) {
                return null;
            }
            Element icon = this.handler.getIcon(this.accessor);
            if (JadeUI.isEmptyElement(icon)) {
                return null;
            }
            return icon;
        }

        public State withData(class_2487 data) {
            if (!this.verifyData(data)) {
                return this;
            }
            return new State(this.accessor, this.handler, data);
        }

        public boolean verifyData(class_2487 data) {
            if (data == null) {
                return true;
            }
            return this.accessor.verifyData(data);
        }
    }
}

