/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_10275;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_8021;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.ui.ArmorElement;
import snownee.jade.impl.ui.HealthElement;

public class EntityHealthAndArmorProvider
implements StreamServerDataProvider<EntityAccessor, Float> {
    public static final EntityHealthAndArmorProvider INSTANCE = new EntityHealthAndArmorProvider();

    @Override
    public @Nullable Float streamData(EntityAccessor accessor) {
        float absorption = ((class_1309)accessor.getEntity()).method_6067();
        return Float.valueOf(absorption > 0.0f ? absorption : 0.0f);
    }

    @Override
    public class_9139<class_9129, Float> streamCodec() {
        return class_9135.field_48552.method_56430();
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        return EntityHealthAndArmorProvider.isHealthVisible((class_1309)accessor.getEntity());
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_ENTITY_HEALTH;
    }

    @Override
    public int getDefaultPriority() {
        return -8000;
    }

    private static boolean isHealthVisible(class_1309 entity) {
        return !(entity instanceof class_1531) && !(entity instanceof class_10275);
    }

    public static class Client
    extends EntityHealthAndArmorProvider
    implements IEntityComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            boolean healthText = false;
            boolean armorText = false;
            ArrayList elements = Lists.newArrayListWithExpectedSize((int)2);
            class_1309 living = (class_1309)accessor.getEntity();
            if (config.get(JadeIds.MC_ENTITY_HEALTH) && EntityHealthAndArmorProvider.isHealthVisible(living)) {
                float health = living.method_6032();
                float maxHealth = living.method_6063();
                float absorption = this.decodeFromData(accessor).orElse(Float.valueOf(0.0f)).floatValue();
                HealthElement healthElement = new HealthElement(living.method_32314() ? class_329.class_6411.field_33949 : class_329.class_6411.field_33945, maxHealth, health, absorption);
                elements.add(healthElement.tag(JadeIds.MC_ENTITY_HEALTH));
                healthText = healthElement.showText();
            }
            if (config.get(JadeIds.MC_ENTITY_ARMOR) && living.method_6096() > 0) {
                ArmorElement armorElement = new ArmorElement(living.method_6096());
                elements.add(armorElement.tag(JadeIds.MC_ENTITY_ARMOR));
                armorText = armorElement.showText();
            }
            if (healthText && armorText) {
                tooltip.add((class_8021)elements.get(0));
                tooltip.append(JadeUI.spacer(4, 0));
                tooltip.append((class_8021)elements.get(1));
            } else {
                elements.forEach(tooltip::add);
            }
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }
}

