/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class TexturedButtonWidget
extends Button {
    public final boolean renderBackground;
    private final int u;
    private final int v;
    private final int hoveredVOffset;
    private final Identifier textureResourceLocation;
    private final int textureWidth;
    private final int textureHeight;

    public TexturedButtonWidget(int x, int y, int width, int height, int u, int v, int hoveredVOffset, Identifier textureResourceLocation, int textureWidth, int textureHeight, Button.OnPress pressAction, Component text) {
        this(x, y, width, height, u, v, hoveredVOffset, textureResourceLocation, textureWidth, textureHeight, pressAction, text, true);
    }

    public TexturedButtonWidget(int x, int y, int width, int height, int u, int v, int hoveredVOffset, Identifier textureResourceLocation, int textureWidth, int textureHeight, Button.OnPress pressAction, Component text, boolean renderBackground) {
        super(x, y, width, height, (Component)Component.empty(), pressAction, DEFAULT_NARRATION);
        this.u = u;
        this.v = v;
        this.hoveredVOffset = hoveredVOffset;
        this.textureResourceLocation = textureResourceLocation;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.renderBackground = renderBackground;
    }

    protected void renderContents(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        if (this.renderBackground) {
            matrices.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        int i = 0;
        if (!this.active) {
            i = 2;
        } else if (this.isHovered) {
            i = 1;
        }
        matrices.blit(RenderPipelines.GUI_TEXTURED, this.textureResourceLocation, this.getX(), this.getY(), (float)this.u, (float)(this.v + this.hoveredVOffset * i), this.width, this.height, this.textureWidth, this.textureHeight);
    }
}

