/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.level.DhClientServerLevel;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.EventLoop;
import com.seibel.distanthorizons.core.world.AbstractDhServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class DhClientServerWorld
extends AbstractDhServerWorld<DhClientServerLevel>
implements IDhClientWorld {
    private final Set<DhClientServerLevel> dhLevels = Collections.synchronizedSet(new HashSet());
    public ExecutorService dhTickerThread = ThreadUtil.makeSingleThreadPool("Client Server World Ticker", 2);
    public EventLoop eventLoop = new EventLoop(this.dhTickerThread, this::_clientTick);

    public DhClientServerWorld() {
        super(EWorldEnvironment.CLIENT_SERVER);
        LOGGER.info("Started DhWorld of type " + (Object)((Object)this.environment), new Object[0]);
    }

    @Override
    public DhClientServerLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (wrapper instanceof IServerLevelWrapper) {
            return this.dhLevelByLevelWrapper.computeIfAbsent(wrapper, levelWrapper -> {
                try {
                    DhClientServerLevel level = new DhClientServerLevel(this.saveStructure, (IServerLevelWrapper)levelWrapper, this.getServerPlayerStateManager());
                    this.dhLevels.add(level);
                    return level;
                }
                catch (Exception e) {
                    LOGGER.fatal("Failed to load client-server level, error: [" + e.getMessage() + "].", e);
                    ClientApi.INSTANCE.showChatMessageNextFrame("\u00a7cDistant Horizons: ClientServer level loading failed.\u00a7r \nUnable to load level [" + levelWrapper.getDhIdentifier() + "], LODs may not appear. See log for more information.");
                    return null;
                }
            });
        }
        return this.dhLevelByLevelWrapper.computeIfAbsent(wrapper, levelWrapper -> {
            DhClientServerLevel level;
            IClientLevelWrapper clientLevelWrapper = (IClientLevelWrapper)levelWrapper;
            IServerLevelWrapper serverLevelWrapper = clientLevelWrapper.tryGetServerSideWrapper();
            LodUtil.assertTrue(serverLevelWrapper != null);
            if (!clientLevelWrapper.getDimensionType().equals(serverLevelWrapper.getDimensionType())) {
                LodUtil.assertNotReach("tryGetServerSideWrapper returned a level for a different dimension. ClientLevelWrapper dim: [" + clientLevelWrapper.getDhIdentifier() + "] ServerLevelWrapper dim: [" + serverLevelWrapper.getDhIdentifier() + "].");
            }
            if ((level = (DhClientServerLevel)this.dhLevelByLevelWrapper.get(serverLevelWrapper)) == null) {
                return null;
            }
            level.startRenderer();
            clientLevelWrapper.setDhLevel(level);
            return level;
        });
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (this.dhLevelByLevelWrapper.containsKey(wrapper)) {
            if (wrapper instanceof IServerLevelWrapper) {
                LOGGER.info("Unloading level " + this.dhLevelByLevelWrapper.get(wrapper), new Object[0]);
                wrapper.onUnload();
                DhClientServerLevel clientServerLevel = (DhClientServerLevel)this.dhLevelByLevelWrapper.remove(wrapper);
                clientServerLevel.close();
                this.dhLevels.remove(clientServerLevel);
            } else {
                ((DhClientServerLevel)this.dhLevelByLevelWrapper.remove(wrapper)).stopRenderer();
            }
        }
    }

    private void _clientTick() {
        this.dhLevels.forEach(DhClientServerLevel::clientTick);
    }

    @Override
    public void clientTick() {
        this.eventLoop.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        ArrayList closeFutures = new ArrayList();
        Set<DhClientServerLevel> set = this.dhLevels;
        synchronized (set) {
            for (DhClientServerLevel level : this.dhLevels) {
                IServerLevelWrapper serverLevelWrapper = level.getServerLevelWrapper();
                if (serverLevelWrapper != null) {
                    serverLevelWrapper.onUnload();
                }
                CompletableFuture closeFuture = new CompletableFuture();
                Thread closeThread = new Thread(() -> {
                    level.close();
                    closeFuture.complete(null);
                }, "level shutdown");
                closeThread.start();
                closeFutures.add(closeFuture);
            }
        }
        for (CompletableFuture completableFuture : closeFutures) {
            completableFuture.join();
        }
        this.dhLevelByLevelWrapper.clear();
        this.eventLoop.close();
        LOGGER.info("Closed DhWorld of type " + (Object)((Object)this.environment), new Object[0]);
    }
}

