/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.dataStreams;

import DistantHorizons.libraries.jpountz.lz4.LZ4FrameInputStream;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStream;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.objects.dataStreams.LzmaArrayCache;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.ResettableArrayCache;
import org.tukaani.xz.XZInputStream;

public class DhDataInputStream
extends DataInputStream {
    private static final ThreadLocal<ResettableArrayCache> LZMA_RESETTABLE_ARRAY_CACHE_GETTER = ThreadLocal.withInitial(() -> new ResettableArrayCache(new LzmaArrayCache()));
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();

    public static DhDataInputStream create(ByteArrayList byteArrayList, EDhApiDataCompressionMode compressionMode) throws IOException {
        return DhDataInputStream.create(byteArrayList.toByteArray(), compressionMode);
    }

    public static DhDataInputStream create(byte[] byteArray, EDhApiDataCompressionMode compressionMode) throws IOException {
        ByteArrayInputStream byteArrayInputStream = compressionMode == EDhApiDataCompressionMode.Z_STD_BLOCK ? new ByteArrayInputStream(Zstd.decompress(byteArray)) : new ByteArrayInputStream(byteArray);
        return new DhDataInputStream(byteArrayInputStream, compressionMode);
    }

    private DhDataInputStream(ByteArrayInputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        super(DhDataInputStream.warpStream(stream, compressionMode));
    }

    private static InputStream warpStream(ByteArrayInputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        try {
            switch (compressionMode) {
                case UNCOMPRESSED: {
                    return stream;
                }
                case LZ4: {
                    return new LZ4FrameInputStream(stream);
                }
                case Z_STD_BLOCK: {
                    return stream;
                }
                case LZMA2: {
                    ResettableArrayCache arrayCache = LZMA_RESETTABLE_ARRAY_CACHE_GETTER.get();
                    arrayCache.reset();
                    return new XZInputStream((InputStream)stream, arrayCache);
                }
                case Z_STD_STREAM: {
                    return new ZstdInputStream(stream, RecyclingBufferPool.INSTANCE);
                }
            }
            throw new IllegalArgumentException("No compressor defined for [" + (Object)((Object)compressionMode) + "]");
        }
        catch (Error e) {
            LOGGER.error("Unexpected error when wrapping DhDataInputStream, error: [" + e.getMessage() + "].", e);
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (EOFException ignore) {
            return -1;
        }
        catch (IOException e) {
            if (e.getMessage().equals("Stream ended prematurely")) {
                return -1;
            }
            throw e;
        }
    }
}

