/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;

public class EventLoop
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private final boolean PAUSE_ON_ERROR = ModInfo.IS_DEV_BUILD;
    private final ExecutorService executorService;
    private final Runnable runnable;
    private CompletableFuture<Void> runnableFuture;
    private boolean isRunning = true;

    public EventLoop(ExecutorService executorService, Runnable runnable) {
        this.executorService = executorService;
        this.runnable = runnable;
    }

    public void tick() {
        if (this.runnableFuture != null && this.runnableFuture.isDone()) {
            try {
                this.runnableFuture.join();
            }
            catch (CompletionException ce) {
                LOGGER.error("Uncaught exception in event loop", ce.getCause());
                if (this.PAUSE_ON_ERROR) {
                    this.isRunning = false;
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception in event loop", e);
                if (this.PAUSE_ON_ERROR) {
                    this.isRunning = false;
                }
            }
            finally {
                this.runnableFuture = null;
            }
        }
        if (this.runnableFuture == null && this.isRunning) {
            this.runnableFuture = CompletableFuture.runAsync(this.runnable, this.executorService);
        }
    }

    @Override
    public void close() {
        if (this.runnableFuture != null) {
            this.runnableFuture.cancel(true);
        }
        this.runnableFuture = null;
        this.executorService.shutdown();
    }

    public boolean isRunning() {
        return this.runnableFuture != null && !this.runnableFuture.isDone();
    }
}

