/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.buffer;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL44;

public class GLBuffer
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logRendererGLEventToFile).chatLevelConfig(Config.Common.Logging.logRendererGLEventToChat).build();
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    public static final double BUFFER_EXPANSION_MULTIPLIER = 1.3;
    public static final double BUFFER_SHRINK_TRIGGER = 1.6900000000000002;
    public static AtomicInteger bufferCount = new AtomicInteger(0);
    private static final int PHANTOM_REF_CHECK_TIME_IN_MS = 5000;
    private static final ConcurrentHashMap<PhantomReference<? extends GLBuffer>, Integer> PHANTOM_TO_BUFFER_ID = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, PhantomReference<? extends GLBuffer>> BUFFER_ID_TO_PHANTOM = new ConcurrentHashMap();
    private static final ReferenceQueue<GLBuffer> PHANTOM_REFERENCE_QUEUE = new ReferenceQueue();
    private static final ThreadPoolExecutor CLEANUP_THREAD = ThreadUtil.makeSingleDaemonThreadPool("GLBuffer Cleanup");
    protected int id;
    protected int size = 0;
    protected boolean bufferStorage;
    protected boolean isMapped = false;

    public final int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public final boolean isBufferStorage() {
        return this.bufferStorage;
    }

    public GLBuffer(boolean isBufferStorage) {
        this.create(isBufferStorage);
    }

    public int getBufferBindingTarget() {
        return 36662;
    }

    public void bind() {
        GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
    }

    public void unbind() {
        GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)0);
    }

    protected void create(boolean asBufferStorage) {
        if (!GLProxy.getInstance().runningOnRenderThread()) {
            LodUtil.assertNotReach("Thread [" + Thread.currentThread() + "] tried to create a GLBuffer outside the MC render thread.");
        }
        if (this.id != 0) {
            GLBuffer.destroyBufferIdAsync(this.id);
        }
        this.id = GLMC.glGenBuffers();
        this.bufferStorage = asBufferStorage;
        bufferCount.getAndIncrement();
        PhantomReference<GLBuffer> phantom = new PhantomReference<GLBuffer>(this, PHANTOM_REFERENCE_QUEUE);
        PHANTOM_TO_BUFFER_ID.put(phantom, this.id);
        BUFFER_ID_TO_PHANTOM.put(this.id, phantom);
    }

    protected void destroyAsync() {
        if (this.id == 0) {
            return;
        }
        GLBuffer.destroyBufferIdAsync(this.id);
        this.id = 0;
        this.size = 0;
    }

    private static void destroyBufferIdAsync(int id) {
        if (BUFFER_ID_TO_PHANTOM.containsKey(id)) {
            Reference phantom = BUFFER_ID_TO_PHANTOM.get(id);
            phantom.clear();
            PHANTOM_TO_BUFFER_ID.remove(phantom);
            BUFFER_ID_TO_PHANTOM.remove(id);
        }
        GLProxy.getInstance().queueRunningOnRenderThread(() -> {
            if (GL32.glIsBuffer((int)id)) {
                GLMC.glDeleteBuffers(id);
                bufferCount.decrementAndGet();
                if (Config.Client.Advanced.Debugging.logBufferGarbageCollection.get().booleanValue()) {
                    LOGGER.info("destroyed buffer [" + id + "], remaining: [" + BUFFER_ID_TO_PHANTOM.size() + "]", new Object[0]);
                }
            }
        });
    }

    public void uploadBuffer(ByteBuffer bb, EDhApiGpuUploadMethod uploadMethod, int maxExpansionSize, int bufferHint) {
        LodUtil.assertTrue(!uploadMethod.useEarlyMapping, "UploadMethod signal that this should use Mapping instead of uploadBuffer!");
        int bbSize = bb.limit() - bb.position();
        if (bbSize > maxExpansionSize) {
            LodUtil.assertNotReach("maxExpansionSize is [" + maxExpansionSize + "] but buffer size is [" + bbSize + "]!");
        }
        if (bbSize == 0) {
            return;
        }
        this.createOrChangeBufferTypeForUpload(uploadMethod);
        switch (uploadMethod) {
            case AUTO: {
                LodUtil.assertNotReach("GpuUploadMethod AUTO must be resolved before call to uploadBuffer()!");
            }
            case BUFFER_STORAGE: {
                this.uploadBufferStorage(bb, bufferHint);
                break;
            }
            case DATA: {
                this.uploadBufferData(bb, bufferHint);
                break;
            }
            case SUB_DATA: {
                this.uploadSubData(bb, maxExpansionSize, bufferHint);
                break;
            }
            default: {
                LodUtil.assertNotReach("Unknown GpuUploadMethod!");
            }
        }
    }

    protected void uploadBufferStorage(ByteBuffer bb, int bufferStorageHint) {
        LodUtil.assertTrue(this.bufferStorage, "Buffer is not bufferStorage but its trying to use bufferStorage upload method!");
        int bbSize = bb.limit() - bb.position();
        this.destroyAsync();
        this.create(true);
        this.bind();
        GL44.glBufferStorage((int)this.getBufferBindingTarget(), (ByteBuffer)bb, (int)0);
        this.size = bbSize;
    }

    protected void uploadBufferData(ByteBuffer bb, int bufferDataHint) {
        LodUtil.assertTrue(!this.bufferStorage, "Buffer is bufferStorage but its trying to use bufferData upload method!");
        int bbSize = bb.limit() - bb.position();
        GL32.glBufferData((int)this.getBufferBindingTarget(), (ByteBuffer)bb, (int)bufferDataHint);
        this.size = bbSize;
    }

    protected void uploadSubData(ByteBuffer bb, int maxExpansionSize, int bufferDataHint) {
        LodUtil.assertTrue(!this.bufferStorage, "Buffer is bufferStorage but its trying to use subData upload method!");
        int bbSize = bb.limit() - bb.position();
        if (this.size < bbSize || (double)this.size > (double)bbSize * 1.6900000000000002) {
            int newSize = (int)((double)bbSize * 1.3);
            if (newSize > maxExpansionSize) {
                newSize = maxExpansionSize;
            }
            GL32.glBufferData((int)this.getBufferBindingTarget(), (long)newSize, (int)bufferDataHint);
            this.size = newSize;
        }
        GL32.glBufferSubData((int)this.getBufferBindingTarget(), (long)0L, (ByteBuffer)bb);
    }

    public ByteBuffer mapBuffer(int targetSize, EDhApiGpuUploadMethod uploadMethod, int maxExpansionSize, int bufferHint, int mapFlags) {
        LodUtil.assertTrue(targetSize != 0, "MapBuffer targetSize is 0");
        LodUtil.assertTrue(uploadMethod.useEarlyMapping, "Upload method must be one that use early mappings in order to call mapBuffer");
        LodUtil.assertTrue(!this.isMapped, "Buffer is already mapped");
        this.createOrChangeBufferTypeForUpload(uploadMethod);
        if (this.size < targetSize || (double)this.size > (double)targetSize * 1.6900000000000002) {
            int newSize = (int)((double)targetSize * 1.3);
            if (newSize > maxExpansionSize) {
                newSize = maxExpansionSize;
            }
            this.size = newSize;
            if (this.bufferStorage) {
                GLMC.glDeleteBuffers(this.id);
                this.id = GLMC.glGenBuffers();
                GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
                GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
                GL44.glBufferStorage((int)this.getBufferBindingTarget(), (long)newSize, (int)bufferHint);
            } else {
                GL32.glBufferData((int)34962, (long)newSize, (int)bufferHint);
            }
        }
        ByteBuffer vboBuffer = GL32.glMapBufferRange((int)34962, (long)0L, (long)targetSize, (int)mapFlags);
        this.isMapped = true;
        return vboBuffer;
    }

    public void unmapBuffer() {
        LodUtil.assertTrue(this.isMapped, "Buffer is not mapped");
        this.bind();
        GL32.glUnmapBuffer((int)this.getBufferBindingTarget());
        this.isMapped = false;
    }

    @Override
    public void close() {
        this.destroyAsync();
    }

    public String toString() {
        return (this.bufferStorage ? "" : "Static-") + this.getClass().getSimpleName() + "[id:" + this.id + ",size:" + this.size + (this.isMapped ? ",MAPPED" : "") + "]";
    }

    private void createOrChangeBufferTypeForUpload(EDhApiGpuUploadMethod uploadMethod) {
        if (uploadMethod.useBufferStorage != this.bufferStorage) {
            this.bind();
            this.destroyAsync();
            this.create(uploadMethod.useBufferStorage);
            this.bind();
        } else {
            if (this.id == 0) {
                this.create(this.bufferStorage);
            }
            this.bind();
        }
    }

    private static void runPhantomReferenceCleanupLoop() {
        while (true) {
            try {
                block5: while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Reference<GLBuffer> phantomRef = PHANTOM_REFERENCE_QUEUE.poll();
                    while (true) {
                        if (phantomRef == null) continue block5;
                        if (PHANTOM_TO_BUFFER_ID.containsKey(phantomRef)) {
                            int id = PHANTOM_TO_BUFFER_ID.get(phantomRef);
                            GLBuffer.destroyBufferIdAsync(id);
                        }
                        phantomRef = PHANTOM_REFERENCE_QUEUE.poll();
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in buffer cleanup thread: [" + e.getMessage() + "].", e);
                continue;
            }
            break;
        }
    }

    static {
        CLEANUP_THREAD.execute(() -> GLBuffer.runPhantomReferenceCleanupLoop());
    }
}

