/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.updater;

import DistantHorizons.libraries.electronwill.nightconfig.core.Config;
import com.seibel.distanthorizons.api.enums.config.EDhApiUpdateBranch;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.JarUtils;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.jar.installer.GitlabGetter;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.jar.installer.WebDownloader;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import com.seibel.distanthorizons.coreapi.util.jar.DeleteOnUnlock;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SelfUpdater {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static boolean deleteOldJarOnJvmShutdown = false;
    private static String currentJarSha = "";
    private static String mcVersion = SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion();
    public static File newFileLocation;

    public static boolean onStart() {
        LOGGER.info("Checking for Distant Horizons update", new Object[0]);
        try {
            currentJarSha = JarUtils.getFileChecksum(MessageDigest.getInstance("SHA"), JarUtils.jarFile);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get existing jar checksum, error: [" + e.getMessage() + "].", e);
            return false;
        }
        boolean returnValue = false;
        try {
            EDhApiUpdateBranch updateBranch = EDhApiUpdateBranch.convertAutoToStableOrNightly(Config.Client.Advanced.AutoUpdater.updateBranch.get());
            returnValue = updateBranch == EDhApiUpdateBranch.STABLE ? SelfUpdater.onStableStart() : SelfUpdater.onNightlyStart();
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected updater startup error: [" + e.getMessage() + "].", e);
        }
        return returnValue;
    }

    private static boolean onStableStart() {
        if (!ModrinthGetter.init()) {
            LOGGER.warn("Unable to find any nightly build pipelines, auto update will be unavailable.", new Object[0]);
            return false;
        }
        if (!ModrinthGetter.mcVersions.contains(mcVersion)) {
            LOGGER.warn("Minecraft version [" + mcVersion + "] is not findable on Modrinth, only findable versions are [" + StringUtil.join(", ", ModrinthGetter.mcVersions) + "]", new Object[0]);
            return false;
        }
        try {
            newFileLocation = JarUtils.jarFile.getParentFile().toPath().resolve("update").resolve("DistantHorizons-" + ModrinthGetter.getLatestNameForVersion(mcVersion) + "-" + mcVersion + ".jar").toFile();
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get file location to download auto updated file to.", e);
            return false;
        }
        if (currentJarSha.equals(ModrinthGetter.getLatestShaForVersion(mcVersion))) {
            LOGGER.info("Distant Horizons already up to date.", new Object[0]);
            return false;
        }
        if (JarUtils.jarFile == null) {
            LOGGER.warn("Unable to get the Distant Horizons jar file, self updating disabled.", new Object[0]);
            return false;
        }
        LOGGER.info("New version (" + ModrinthGetter.getLatestNameForVersion(mcVersion) + ") of Distant Horizons is available", new Object[0]);
        if (Config.Client.Advanced.AutoUpdater.enableSilentUpdates.get().booleanValue()) {
            SelfUpdater.updateMod(mcVersion, newFileLocation);
            return false;
        }
        LOGGER.info("Download link: " + ModrinthGetter.getLatestDownloadForVersion(mcVersion), new Object[0]);
        return true;
    }

    private static boolean onNightlyStart() {
        if (GitlabGetter.INSTANCE.projectPipelines.size() == 0) {
            LOGGER.info("Unable to find any nightly build pipelines, auto update will be unavailable.", new Object[0]);
            return false;
        }
        Config pipeline = GitlabGetter.INSTANCE.projectPipelines.get(0);
        if (!pipeline.get("ref").equals(ModJarInfo.Git_Branch)) {
            LOGGER.warn("Latest pipeline was found for branch [" + pipeline.get("ref") + "], but we are on branch [" + ModJarInfo.Git_Branch + "].", new Object[0]);
            return false;
        }
        if (!pipeline.get("status").equals("success")) {
            LOGGER.warn("Pipeline for branch [" + ModJarInfo.Git_Branch + "], pipeline ID [" + pipeline.get("id") + "], has either failed to build, or is still building.", new Object[0]);
            return false;
        }
        if (!GitlabGetter.INSTANCE.getDownloads((Number)pipeline.get("id")).containsKey(mcVersion)) {
            LOGGER.warn("Minecraft version [" + mcVersion + "] is not findable on Gitlab, findable versions are [" + StringUtil.join(",", GitlabGetter.INSTANCE.getDownloads((Number)pipeline.get("id")).keySet().toArray()) + "].", new Object[0]);
            return false;
        }
        String latestCommit = (String)pipeline.get("sha");
        try {
            newFileLocation = JarUtils.jarFile.getParentFile().toPath().resolve("update").resolve("DistantHorizons-" + latestCommit + ".jar").toFile();
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get file location to download auto updated file to.", e);
            return false;
        }
        if (ModJarInfo.Git_Commit.equals(latestCommit)) {
            LOGGER.info("Distant Horizons already up to date.", new Object[0]);
            return false;
        }
        LOGGER.info("New version [" + latestCommit + "] of Distant Horizons is available", new Object[0]);
        if (Config.Client.Advanced.AutoUpdater.enableSilentUpdates.get().booleanValue()) {
            SelfUpdater.updateMod(mcVersion, newFileLocation);
            return false;
        }
        LOGGER.info("Download link: " + GitlabGetter.getLatestForVersion(mcVersion), new Object[0]);
        return true;
    }

    public static boolean updateMod() {
        String mcVer = SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion();
        return SelfUpdater.updateMod(mcVer, newFileLocation);
    }

    public static boolean updateMod(String minecraftVersion, File file) {
        EDhApiUpdateBranch updateBranch = EDhApiUpdateBranch.convertAutoToStableOrNightly(Config.Client.Advanced.AutoUpdater.updateBranch.get());
        if (updateBranch == EDhApiUpdateBranch.STABLE) {
            return SelfUpdater.updateStableMod(minecraftVersion, file);
        }
        if (updateBranch == EDhApiUpdateBranch.NIGHTLY) {
            return SelfUpdater.updateNightlyMod(minecraftVersion, file);
        }
        LOGGER.error("Unable to update due to unimplemented update branch [" + (Object)((Object)updateBranch) + "].", new Object[0]);
        return false;
    }

    public static boolean updateStableMod(String minecraftVersion, File file) {
        try {
            LOGGER.info("Attempting to auto update Distant Horizons", new Object[0]);
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            WebDownloader.downloadAsFile(ModrinthGetter.getLatestDownloadForVersion(minecraftVersion), file);
            if (!JarUtils.getFileChecksum(MessageDigest.getInstance("SHA"), file).equals(ModrinthGetter.getLatestShaForVersion(minecraftVersion))) {
                LOGGER.warn("Distant Horizons update checksum failed, aborting install", new Object[0]);
                throw new Exception("Checksum failed");
            }
            deleteOldJarOnJvmShutdown = true;
            String successMessage = "Distant Horizons successfully updated. It will apply on game's relaunch";
            LOGGER.info(successMessage, new Object[0]);
            new Thread(() -> {
                try {
                    TinyFileDialogs.tinyfd_messageBox((CharSequence)"Distant Horizons", (CharSequence)successMessage, (CharSequence)"ok", (CharSequence)"info", (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            return true;
        }
        catch (Exception e) {
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception deleteCorruptFileException) {
                LOGGER.error("Unable to delete corrupted update file at [" + file.toPath() + "], error: [" + deleteCorruptFileException.getMessage() + "].", deleteCorruptFileException);
            }
            String failMessage = "Failed to update Distant Horizons to version [" + ModrinthGetter.getLatestNameForVersion(minecraftVersion) + "], error: [" + e.getMessage() + "].";
            LOGGER.error(failMessage, e);
            try {
                TinyFileDialogs.tinyfd_messageBox((CharSequence)"Distant Horizons", (CharSequence)failMessage, (CharSequence)"ok", (CharSequence)"error", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean updateNightlyMod(String minecraftVersion, File file) {
        if (GitlabGetter.INSTANCE.projectPipelines.isEmpty()) {
            LOGGER.warn("Failed to find any nightly builds for the minecraft version [" + minecraftVersion + "] update canceled.", new Object[0]);
            return false;
        }
        Path mergedZipPath = null;
        try {
            LOGGER.info("Attempting to auto update Distant Horizons.", new Object[0]);
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            mergedZipPath = file.getParentFile().toPath().resolve("merged.zip");
            WebDownloader.downloadAsFile(GitlabGetter.INSTANCE.getDownloads((Number)GitlabGetter.INSTANCE.projectPipelines.get(0).get("id")).get(minecraftVersion), mergedZipPath.toFile());
            try (ZipFile zipFile = new ZipFile(mergedZipPath.toFile());){
                ZipEntry zipEntry = Collections.list(zipFile.entries()).stream().max(Comparator.comparingInt(entry -> entry.getName().length())).orElseThrow(() -> new Exception("Unable to find jar in zip. Is the downloaded zip empty?"));
                long expectedCheckSum = zipEntry.getCrc();
                int expectedSize = (int)zipEntry.getSize();
                byte[] buffer = new byte[expectedSize];
                CRC32 crcCheckSumGenerator = new CRC32();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                int byteReadIndex = 0;
                try {
                    NumberFormat outputFormat = NumberFormat.getNumberInstance();
                    int nextByte = inputStream.read();
                    while (nextByte != -1) {
                        buffer[byteReadIndex] = (byte)nextByte;
                        crcCheckSumGenerator.update(nextByte);
                        nextByte = inputStream.read();
                        if (++byteReadIndex % 100000 != 0) continue;
                        LOGGER.info("Decompressing [" + outputFormat.format((double)byteReadIndex / (double)expectedSize * 100.0) + "]%", new Object[0]);
                    }
                }
                catch (EOFException outputFormat) {
                    // empty catch block
                }
                if (byteReadIndex != expectedSize) {
                    LOGGER.warn("Distant Horizons update decompression failed, aborting install", new Object[0]);
                    throw new Exception("Decompression failed");
                }
                long actualChecksum = crcCheckSumGenerator.getValue();
                if (actualChecksum != expectedCheckSum) {
                    LOGGER.warn("Distant Horizons checksum mismatch, aborting install", new Object[0]);
                    throw new Exception("Checksum Mismatch");
                }
                Files.write(file.toPath(), buffer, new OpenOption[0]);
            }
            Files.deleteIfExists(mergedZipPath);
            deleteOldJarOnJvmShutdown = true;
            String successMessage = "Distant Horizons updated, this will be applied on game restart.";
            LOGGER.info(successMessage, new Object[0]);
            new Thread(() -> {
                try {
                    TinyFileDialogs.tinyfd_messageBox((CharSequence)"Distant Horizons", (CharSequence)successMessage, (CharSequence)"ok", (CharSequence)"info", (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            return true;
        }
        catch (Exception e) {
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception deleteCorruptFileException) {
                LOGGER.error("Unable to delete corrupted update jar file at [" + file.toPath() + "], error: [" + deleteCorruptFileException.getMessage() + "].", deleteCorruptFileException);
            }
            try {
                if (mergedZipPath != null) {
                    Files.deleteIfExists(mergedZipPath);
                }
            }
            catch (Exception deleteCorruptFileException) {
                LOGGER.error("Unable to delete corrupted update zip file at [" + mergedZipPath + "], error: [" + deleteCorruptFileException.getMessage() + "].", deleteCorruptFileException);
            }
            String versionHash = (String)GitlabGetter.INSTANCE.projectPipelines.get(0).get("sha");
            String failMessage = "Failed to update [Distant Horizons] to version [" + versionHash + "], error: [" + e.getMessage() + "].";
            LOGGER.error(failMessage, e);
            try {
                TinyFileDialogs.tinyfd_messageBox((CharSequence)"Distant Horizons", (CharSequence)failMessage, (CharSequence)"ok", (CharSequence)"error", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static void onClose() {
        if (!deleteOldJarOnJvmShutdown) {
            return;
        }
        if (JarUtils.jarFile == null) {
            return;
        }
        Path newJarPath = newFileLocation.toPath();
        Path finalJarPath = JarUtils.jarFile.getParentFile().toPath().resolve(newFileLocation.getName());
        try {
            Files.deleteIfExists(finalJarPath);
            Files.move(newJarPath, finalJarPath, new CopyOption[0]);
            Files.delete(newFileLocation.getParentFile().toPath());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to move updated fire from [" + newFileLocation.getAbsolutePath() + "] to [" + JarUtils.jarFile.getParentFile().getAbsolutePath() + "], please move it manually", e);
        }
        try {
            String javaHome = System.getProperty("java.home");
            String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
            String execCommand = "\"" + javaBin + "\" -cp \"" + finalJarPath.toAbsolutePath() + "\" " + DeleteOnUnlock.class.getCanonicalName() + " " + URLEncoder.encode(JarUtils.jarFile.getAbsolutePath(), "UTF-8");
            Process deleteProcess = Runtime.getRuntime().exec(execCommand);
            if (deleteProcess.isAlive()) {
                LOGGER.info(DeleteOnUnlock.class.getSimpleName() + " process started...", new Object[0]);
            } else {
                LOGGER.error(DeleteOnUnlock.class.getSimpleName() + " process failed to start.", new Object[0]);
            }
            Thread.sleep(250L);
            if (deleteProcess.isAlive()) {
                LOGGER.info(DeleteOnUnlock.class.getSimpleName() + " running, old jar file at [" + JarUtils.jarFile.getAbsolutePath() + "] should be deleted after Minecraft's JVM shutdown has completed.", new Object[0]);
            } else {
                int processExitCode = deleteProcess.exitValue();
                if (processExitCode != DeleteOnUnlock.SUCCESS_EXIT_CODE) {
                    String failReason = processExitCode == DeleteOnUnlock.FAIL_EXIT_CODE ? "Timed out and was unable to delete the file." : "Ran into an unexpected error.";
                    LOGGER.error(DeleteOnUnlock.class.getSimpleName() + " " + failReason, new Object[0]);
                    LOGGER.error(DeleteOnUnlock.class.getSimpleName() + " Logs are listed below:", new Object[0]);
                    String normalOutput = SelfUpdater.convertInputStreamToString(deleteProcess.getInputStream());
                    LOGGER.info("process output: \n\n" + normalOutput, new Object[0]);
                    String errorOutput = SelfUpdater.convertInputStreamToString(deleteProcess.getInputStream());
                    LOGGER.error("process error output: \n\n" + errorOutput, new Object[0]);
                } else {
                    LOGGER.info(DeleteOnUnlock.class.getSimpleName() + " completed before JVM shutdown.", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete old jar using bootstrap method, doing backup 'Files.deleteOnExit()' method", e);
            JarUtils.jarFile.deleteOnExit();
            LOGGER.warn("If the old Distant Horizons file didn't delete, delete it manually at [" + JarUtils.jarFile + "]", new Object[0]);
        }
    }

    private static String convertInputStreamToString(InputStream inputStream) {
        try {
            byte[] bytes = new byte[inputStream.available()];
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(bytes);
            return new String(bytes);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

