/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar;

import com.seibel.distanthorizons.core.jar.DarkModeDetector;
import com.seibel.distanthorizons.core.jar.EPlatform;
import com.seibel.distanthorizons.core.jar.JarDependencySetup;
import com.seibel.distanthorizons.core.jar.JarUtils;
import com.seibel.distanthorizons.core.jar.gui.BaseJFrame;
import com.seibel.distanthorizons.core.jar.gui.cusomJObject.JBox;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.jar.installer.WebDownloader;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class JarMain {
    public static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static List<String> argList;
    public static final boolean isDarkTheme;
    public static boolean isOffline;

    public static void main(String[] args) {
        argList = Arrays.asList(args);
        if (!argList.contains("--no-custom-logger")) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            try {
                context.setConfigLocation(JarUtils.accessFileURI("/log4jConfig.xml"));
            }
            catch (Exception e) {
                LOGGER.error("Failed to set log4j config. Try running with the \"--no-custom-logger\" argument", new Object[0]);
                e.printStackTrace();
            }
        }
        LOGGER.debug("Running Distant Horizons standalone jar", new Object[0]);
        LOGGER.warn("The standalone jar is still a massive WIP, expect bugs", new Object[0]);
        LOGGER.debug("Java version " + System.getProperty("java.version"), new Object[0]);
        if (args.length == 0 || Arrays.asList(args).contains("--gui")) {
            if (JarUtils.accessFile("assets/lod/lang/" + Locale.getDefault().toString().toLowerCase() + ".json") == null) {
                LOGGER.warn("The language setting [" + Locale.getDefault().toString().toLowerCase() + "] isn't allowed yet. Defaulting to [" + Locale.US.toString().toLowerCase() + "].", new Object[0]);
                Locale.setDefault(Locale.US);
            }
            JarDependencySetup.createInitialBindings();
            JarMain.startGUI();
        } else if (argList.get(0).equals("--export")) {
            FullDataSourceV2Repo repo;
            Byte exportDetailLevel = null;
            Long exportPos = null;
            boolean showHelp = argList.contains("help");
            if (!showHelp) {
                String detailLevelString;
                showHelp = true;
                if (argList.size() == 1) {
                    showHelp = false;
                } else if (argList.size() == 2) {
                    detailLevelString = argList.get(1);
                    try {
                        exportDetailLevel = Byte.parseByte(detailLevelString);
                        showHelp = false;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Unable to parse detail level [" + detailLevelString + "], error: [" + e.getMessage() + "].", new Object[0]);
                    }
                } else if (argList.size() == 4) {
                    detailLevelString = argList.get(1);
                    String posXString = argList.get(2);
                    String posZString = argList.get(3);
                    try {
                        byte detailLevel = Byte.parseByte(detailLevelString);
                        int posX = Integer.parseInt(posXString);
                        int posZ = Integer.parseInt(posZString);
                        exportPos = DhSectionPos.encode(detailLevel, posX, posZ);
                        showHelp = false;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Unable to parse position [" + detailLevelString + "], [" + posXString + "], [" + posZString + "], error: [" + e.getMessage() + "].", new Object[0]);
                    }
                }
            }
            if (showHelp) {
                LOGGER.info("--export parses the 'DistantHorizons.sqlite' file next to this jar and exports the given data into a CSV file. \nUsage: \n--export [LOD position Detail Level] [LOD position X] [LOD position Z] \n\tExport the given position's data if present. \n\tThe detail level should be absolute, IE 0 = block sized, 1 = 2x2 blocks, etc. \n--export [LOD position Detail Level]\n\tExport all data for a given detail level.\n\tThe detail level should be absolute, IE 0 = block sized, 1 = 2x2 blocks, etc. \n--export\n\tExport the entire database.\n", new Object[0]);
                return;
            }
            File dbFile = new File("./DistantHorizons.sqlite");
            if (!dbFile.exists()) {
                LOGGER.error("Unable to find a database to parse at: [" + dbFile.getAbsolutePath() + "].", new Object[0]);
                return;
            }
            File exportFile = new File("DistantHorizons-export.csv");
            if (exportFile.isDirectory()) {
                LOGGER.error("Export file can't be a folder. Given path: [" + exportFile + "].", new Object[0]);
                return;
            }
            try {
                boolean ignored = exportFile.mkdirs();
                if (exportFile.exists()) {
                    LOGGER.error("Export file already exists: [" + exportFile.getAbsolutePath() + "].", new Object[0]);
                    return;
                }
                if (exportFile.createNewFile()) {
                    LOGGER.error("Failed to create file: [" + exportFile.getAbsolutePath() + "].", new Object[0]);
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to create export file: [" + exportFile.getAbsolutePath() + "].", new Object[0]);
                return;
            }
            LOGGER.info("LOD data will be exported to [" + exportFile.getAbsolutePath() + "].", new Object[0]);
            try {
                repo = new FullDataSourceV2Repo("jdbc:dh_sqlite", dbFile);
            }
            catch (IOException | SQLException e) {
                LOGGER.error("Failed to initialize connection with database: [" + exportFile.getAbsolutePath() + "], error: [" + e.getMessage() + "].", e);
                return;
            }
            if (exportPos != null) {
                JarMain.exportLodDataAtPosition(repo, exportFile, exportPos);
            } else if (exportDetailLevel != null) {
                JarMain.exportAllAtDetailLevel(repo, exportFile, exportDetailLevel);
            } else {
                JarMain.exportEntireDatabase(repo, exportFile);
            }
        }
    }

    private static void exportLodDataAtPosition(FullDataSourceV2Repo repo, File exportFile, long pos) {
        FullDataSourceV2DTO dto = (FullDataSourceV2DTO)repo.getByKey(pos);
        if (dto == null) {
            LOGGER.error("Unable to find any data at the position [" + DhSectionPos.toString(pos) + "].", new Object[0]);
            return;
        }
    }

    private static void exportAllAtDetailLevel(FullDataSourceV2Repo repo, File exportFile, byte detailLevel) {
    }

    private static void exportEntireDatabase(FullDataSourceV2Repo repo, File exportFile) {
    }

    public static void startGUI() {
        ModrinthGetter.init();
        System.out.println("WARNING: The standalone jar still work in progress");
        BaseJFrame frame = new BaseJFrame(false, true);
        frame.addExtraButtons(frame.getWidth(), 0, true, false);
        GridBagConstraints verticalLayout = new GridBagConstraints();
        verticalLayout.gridy = -1;
        verticalLayout.gridx = 0;
        verticalLayout.fill = 2;
        verticalLayout.weightx = 1.0;
        verticalLayout.anchor = 11;
        AtomicReference<String> downloadID = new AtomicReference<String>("");
        JPanel modVersionDescriptionPanel = new JPanel(new GridBagLayout());
        JScrollPane modVersionDescriptionScroll = new JScrollPane(modVersionDescriptionPanel, 20, 31);
        int modDescriptionWidth = 275;
        modVersionDescriptionScroll.setBounds(frame.getWidth() - modDescriptionWidth, 225, modDescriptionWidth, frame.getHeight() - 255);
        modVersionDescriptionScroll.setBorder(null);
        modVersionDescriptionScroll.setWheelScrollingEnabled(true);
        JLabel modVersionDescriptionLabel = new JLabel();
        modVersionDescriptionPanel.add((Component)modVersionDescriptionLabel, verticalLayout);
        frame.add(modVersionDescriptionScroll);
        JPanel modMinecraftVersionsPannel = new JPanel(new GridBagLayout());
        JScrollPane modMinecraftVersionsScroll = new JScrollPane(modMinecraftVersionsPannel, 22, 31);
        modMinecraftVersionsScroll.setBounds(0, 225, 125, frame.getHeight() - 255);
        modMinecraftVersionsScroll.setBorder(null);
        modMinecraftVersionsScroll.setWheelScrollingEnabled(true);
        ArrayList<JButton> modMinecraftReleaseButtons = new ArrayList<JButton>();
        frame.add(modMinecraftVersionsScroll);
        JPanel modVersionsPannel = new JPanel(new GridBagLayout());
        JScrollPane modVersionsScroll = new JScrollPane(modVersionsPannel, 20, 31);
        modVersionsScroll.setBounds(125, 225, 100, frame.getHeight() - 255);
        modVersionsScroll.setBorder(null);
        modVersionsScroll.setWheelScrollingEnabled(true);
        ArrayList modReleaseButtons = new ArrayList();
        frame.add(modVersionsScroll);
        for (String mcVer : ModrinthGetter.mcVersions) {
            JButton btn = new JButton(mcVer);
            btn.setBackground(UIManager.getColor("Panel.background"));
            btn.setBorderPainted(false);
            btn.addActionListener(e -> {
                for (JButton currentBtn : modMinecraftReleaseButtons) {
                    currentBtn.setBackground(UIManager.getColor("Panel.background"));
                }
                btn.setBackground(UIManager.getColor("Button.background"));
                modVersionsPannel.removeAll();
                modReleaseButtons.clear();
                for (String modID : ModrinthGetter.mcVerToReleaseID.get(mcVer)) {
                    JButton btnDownload = new JButton(ModrinthGetter.releaseNames.get(modID));
                    btnDownload.setBackground(UIManager.getColor("Panel.background"));
                    btnDownload.setBorderPainted(false);
                    btnDownload.setHorizontalAlignment(2);
                    btnDownload.addActionListener(f -> {
                        downloadID.set(modID);
                        for (JButton currentBtn : modReleaseButtons) {
                            currentBtn.setBackground(UIManager.getColor("Panel.background"));
                        }
                        btnDownload.setBackground(UIManager.getColor("Button.background"));
                        modVersionDescriptionLabel.setText(WebDownloader.formatMarkdownToHtml(ModrinthGetter.changeLogs.get(modID), modDescriptionWidth - 75));
                        modVersionDescriptionPanel.repaint();
                    });
                    modVersionsPannel.add((Component)btnDownload, verticalLayout);
                    modReleaseButtons.add(btnDownload);
                }
                modVersionsScroll.getVerticalScrollBar().setValue(0);
                modVersionsPannel.repaint();
                frame.validate();
            });
            modMinecraftVersionsPannel.add((Component)btn, verticalLayout);
            modMinecraftReleaseButtons.add(btn);
        }
        frame.add(new JBox(UIManager.getColor("Separator.foreground"), 0, 220, frame.getWidth(), 5));
        JLabel textMcVersionHeader = new JLabel("Minecraft version");
        textMcVersionHeader.setBounds(0, 200, 125, 20);
        frame.add(textMcVersionHeader);
        JLabel textVersionHeader = new JLabel("Mod version");
        textVersionHeader.setBounds(125, 200, 150, 20);
        frame.add(textVersionHeader);
        JFileChooser minecraftDirPop = new JFileChooser();
        switch (EPlatform.get()) {
            case WINDOWS: {
                minecraftDirPop.setCurrentDirectory(new File(System.getenv("APPDATA") + "/.minecraft/mods"));
            }
            case LINUX: {
                minecraftDirPop.setCurrentDirectory(new File(System.getProperty("user.home") + "/.minecraft/mods"));
            }
        }
        minecraftDirPop.setFileSelectionMode(1);
        JButton minecraftDirBtn = new JButton("Click to select install path");
        minecraftDirBtn.addActionListener(e -> {
            if (minecraftDirPop.showOpenDialog(frame) == 0) {
                minecraftDirBtn.setText(minecraftDirPop.getSelectedFile().toString());
            }
        });
        minecraftDirBtn.setBounds(230, frame.getHeight() - 100, 200, 20);
        frame.add(minecraftDirBtn);
        JButton installMod = new JButton("Install Distant Horizons");
        installMod.setBounds(230, frame.getHeight() - 70, 200, 20);
        installMod.addActionListener(e -> {
            if (minecraftDirPop.getSelectedFile() == null) {
                TinyFileDialogs.tinyfd_messageBox((CharSequence)"Distant Horizons", (CharSequence)"Please select your install directory", (CharSequence)"ok", (CharSequence)"warning", (boolean)false);
                return;
            }
            URL downloadPath = ModrinthGetter.downloadUrl.get(downloadID.get());
            try {
                WebDownloader.downloadAsFile(downloadPath, minecraftDirPop.getSelectedFile().toPath().resolve("DistantHorizons-" + ModrinthGetter.releaseNames.get(downloadID.get()) + ".jar").toFile());
                TinyFileDialogs.tinyfd_messageBox((CharSequence)"Distant Horizons", (CharSequence)"Installation done. \nYou can now close the installer", (CharSequence)"ok", (CharSequence)"info", (boolean)false);
            }
            catch (Exception f) {
                TinyFileDialogs.tinyfd_messageBox((CharSequence)"Distant Horizons", (CharSequence)("Download failed. Check your internet connection \nStacktrace: " + f.getMessage()), (CharSequence)"error", (CharSequence)"info", (boolean)false);
            }
        });
        frame.add(installMod);
        frame.addLogo();
        frame.validate();
        frame.setVisible(true);
    }

    static {
        isDarkTheme = DarkModeDetector.isDarkMode();
        isOffline = WebDownloader.netIsAvailable();
    }
}

