/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.StatsMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.lwjgl.system.MemoryUtil;

public class LodBufferContainer
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static final int QUADS_BYTE_SIZE = LodUtil.LOD_VERTEX_FORMAT.getByteSize() * 4;
    public static final int MAX_VBO_BYTE_SIZE = 0xA00000;
    public static final int MAX_QUADS_PER_BUFFER = 0xA00000 / QUADS_BYTE_SIZE;
    public static final int FULL_SIZED_BUFFER = MAX_QUADS_PER_BUFFER * QUADS_BYTE_SIZE;
    public final DhBlockPos minCornerBlockPos;
    public final long pos;
    public boolean buffersUploaded = false;
    public GLVertexBuffer[] vbos;
    public GLVertexBuffer[] vbosTransparent;
    private CompletableFuture<LodBufferContainer> uploadFuture = null;

    public LodBufferContainer(long pos, DhBlockPos minCornerBlockPos) {
        this.pos = pos;
        this.minCornerBlockPos = minCornerBlockPos;
        this.vbos = new GLVertexBuffer[0];
        this.vbosTransparent = new GLVertexBuffer[0];
    }

    public synchronized CompletableFuture<LodBufferContainer> makeAndUploadBuffersAsync(LodQuadBuilder builder) {
        CompletableFuture<LodBufferContainer> future = this.uploadFuture;
        if (future != null) {
            return future;
        }
        this.uploadFuture = future = new CompletableFuture();
        ArrayList<ByteBuffer> opaqueBuffers = builder.makeOpaqueVertexBuffers();
        ArrayList<ByteBuffer> transparentBuffers = builder.makeTransparentVertexBuffers();
        this.vbos = LodBufferContainer.resizeBuffer(this.vbos, opaqueBuffers.size());
        this.vbosTransparent = LodBufferContainer.resizeBuffer(this.vbosTransparent, transparentBuffers.size());
        GLProxy.getInstance().queueRunningOnRenderThread(() -> {
            try {
                if (Thread.interrupted() || this.uploadFuture.isCancelled()) {
                    throw new InterruptedException();
                }
                EDhApiGpuUploadMethod gpuUploadMethod = GLProxy.getInstance().getGpuUploadMethod();
                LodBufferContainer.uploadBuffersDirect(this.vbos, opaqueBuffers, gpuUploadMethod);
                LodBufferContainer.uploadBuffersDirect(this.vbosTransparent, transparentBuffers, gpuUploadMethod);
                this.buffersUploaded = true;
                this.uploadFuture.complete(this);
                this.uploadFuture = null;
            }
            catch (InterruptedException ignore) {
                this.uploadFuture.complete(this);
                this.uploadFuture = null;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected issue uploading buffer [" + this.minCornerBlockPos + "], error: [" + e.getMessage() + "].", e);
                this.uploadFuture.completeExceptionally(e);
                this.uploadFuture = null;
            }
            finally {
                for (ByteBuffer buffer : opaqueBuffers) {
                    MemoryUtil.memFree((Buffer)buffer);
                }
                for (ByteBuffer buffer : transparentBuffers) {
                    MemoryUtil.memFree((Buffer)buffer);
                }
            }
        });
        return future;
    }

    private static GLVertexBuffer[] resizeBuffer(GLVertexBuffer[] vbos, int newSize) {
        if (vbos.length == newSize) {
            return vbos;
        }
        GLVertexBuffer[] newVbos = new GLVertexBuffer[newSize];
        System.arraycopy(vbos, 0, newVbos, 0, Math.min(vbos.length, newSize));
        if (newSize < vbos.length) {
            for (int i = newSize; i < vbos.length; ++i) {
                if (vbos[i] == null) continue;
                vbos[i].close();
            }
        }
        return newVbos;
    }

    private static void uploadBuffersDirect(GLVertexBuffer[] vbos, ArrayList<ByteBuffer> byteBuffers, EDhApiGpuUploadMethod uploadMethod) throws InterruptedException {
        int vboIndex = 0;
        for (int i = 0; i < byteBuffers.size(); ++i) {
            if (vboIndex >= vbos.length) {
                throw new RuntimeException("Too many vertex buffers!!");
            }
            if (vbos[vboIndex] == null) {
                vbos[vboIndex] = new GLVertexBuffer(uploadMethod.useBufferStorage);
            }
            GLVertexBuffer vbo = vbos[vboIndex];
            ByteBuffer buffer = byteBuffers.get(i);
            int size = buffer.limit() - buffer.position();
            try {
                vbo.bind();
                vbo.uploadBuffer(buffer, size / LodUtil.LOD_VERTEX_FORMAT.getByteSize(), uploadMethod, FULL_SIZED_BUFFER);
            }
            catch (Exception e) {
                vbos[vboIndex] = null;
                vbo.close();
                LOGGER.error("Failed to upload buffer. Error: [" + e.getMessage() + "].", e);
            }
            ++vboIndex;
        }
        if (vboIndex < vbos.length) {
            throw new RuntimeException("Too few vertex buffers!!");
        }
    }

    public boolean hasNonNullVbos() {
        return this.vbos != null || this.vbosTransparent != null;
    }

    public int vboBufferCount() {
        int count = 0;
        if (this.vbos != null) {
            count += this.vbos.length;
        }
        if (this.vbosTransparent != null) {
            count += this.vbosTransparent.length;
        }
        return count;
    }

    public boolean uploadInProgress() {
        return this.uploadFuture != null;
    }

    public void debugDumpStats(StatsMap statsMap) {
        statsMap.incStat("RenderBuffers");
        statsMap.incStat("SimpleRenderBuffers");
        for (GLVertexBuffer vertexBuffer : this.vbos) {
            if (vertexBuffer == null) continue;
            statsMap.incStat("VBOs");
            if (vertexBuffer.getSize() == FULL_SIZED_BUFFER) {
                statsMap.incStat("FullsizedVBOs");
            }
            if (vertexBuffer.getSize() == 0) {
                GLProxy.LOGGER.warn("VBO with size 0", new Object[0]);
            }
            statsMap.incBytesStat("TotalUsage", vertexBuffer.getSize());
        }
    }

    @Override
    public void close() {
        this.buffersUploaded = false;
        GLProxy.getInstance().queueRunningOnRenderThread(() -> {
            for (GLVertexBuffer buffer : this.vbos) {
                if (buffer == null) continue;
                buffer.destroyAsync();
            }
            for (GLVertexBuffer buffer : this.vbosTransparent) {
                if (buffer == null) continue;
                buffer.destroyAsync();
            }
        });
    }
}

