/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.ZstdIOException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Zstd {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compress(byte[] bs, byte[] cs, int i, boolean bl) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(i);
            zstdCompressCtx.setChecksum(bl);
            long l = zstdCompressCtx.compress(bs, cs);
            return l;
        }
    }

    public static long compress(byte[] bs, byte[] cs, int i) {
        return Zstd.compress(bs, cs, i, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressByteArray(byte[] bs, int i, int j, byte[] cs, int k, int l, int m, boolean bl) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(m);
            zstdCompressCtx.setChecksum(bl);
            long l2 = zstdCompressCtx.compressByteArray(bs, i, j, cs, k, l);
            return l2;
        }
    }

    public static long compressByteArray(byte[] bs, int i, int j, byte[] cs, int k, int l, int m) {
        return Zstd.compressByteArray(bs, i, j, cs, k, l, m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressDirectByteBuffer(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l, int m, boolean bl) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(m);
            zstdCompressCtx.setChecksum(bl);
            long l2 = zstdCompressCtx.compressDirectByteBuffer(byteBuffer, i, j, byteBuffer2, k, l);
            return l2;
        }
    }

    public static long compressDirectByteBuffer(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l, int m) {
        return Zstd.compressDirectByteBuffer(byteBuffer, i, j, byteBuffer2, k, l, m, false);
    }

    public static native long compressUnsafe(long var0, long var2, long var4, long var6, int var8, boolean var9);

    public static long compressUnsafe(long l, long m, long n, long o, int i) {
        return Zstd.compressUnsafe(l, m, n, o, i, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressUsingDict(byte[] bs, int i, byte[] cs, int j, int k, byte[] ds, int l) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(l);
            zstdCompressCtx.loadDict(ds);
            long l2 = zstdCompressCtx.compressByteArray(bs, i, bs.length - i, cs, j, k);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressUsingDict(byte[] bs, int i, byte[] cs, int j, byte[] ds, int k) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(k);
            zstdCompressCtx.loadDict(ds);
            long l = zstdCompressCtx.compressByteArray(bs, i, bs.length - i, cs, j, cs.length - j);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressDirectByteBufferUsingDict(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l, byte[] bs, int m) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(m);
            zstdCompressCtx.loadDict(bs);
            long l2 = zstdCompressCtx.compressDirectByteBuffer(byteBuffer, i, j, byteBuffer2, k, l);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressFastDict(byte[] bs, int i, byte[] cs, int j, int k, ZstdDictCompress zstdDictCompress) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(zstdDictCompress);
            zstdCompressCtx.setLevel(zstdDictCompress.level());
            long l = zstdCompressCtx.compressByteArray(bs, i, bs.length - i, cs, j, k);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressFastDict(byte[] bs, int i, byte[] cs, int j, ZstdDictCompress zstdDictCompress) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(zstdDictCompress);
            zstdCompressCtx.setLevel(zstdDictCompress.level());
            long l = zstdCompressCtx.compressByteArray(bs, i, bs.length - i, cs, j, cs.length - j);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compress(byte[] bs, byte[] cs, ZstdDictCompress zstdDictCompress) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(zstdDictCompress);
            zstdCompressCtx.setLevel(zstdDictCompress.level());
            long l = zstdCompressCtx.compress(bs, cs);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressDirectByteBufferFastDict(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l, ZstdDictCompress zstdDictCompress) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(zstdDictCompress);
            zstdCompressCtx.setLevel(zstdDictCompress.level());
            long l2 = zstdCompressCtx.compressDirectByteBuffer(byteBuffer, i, j, byteBuffer2, k, l);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompress(byte[] bs, byte[] cs) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            long l = zstdDecompressCtx.decompress(bs, cs);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(byte[] bs, ByteBuffer byteBuffer) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            int n = zstdDecompressCtx.decompress(bs, byteBuffer);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressByteArray(byte[] bs, int i, int j, byte[] cs, int k, int l) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            long l2 = zstdDecompressCtx.decompressByteArray(bs, i, j, cs, k, l);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressDirectByteBuffer(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            long l2 = zstdDecompressCtx.decompressDirectByteBuffer(byteBuffer, i, j, byteBuffer2, k, l);
            return l2;
        }
    }

    public static native long decompressUnsafe(long var0, long var2, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressUsingDict(byte[] bs, int i, byte[] cs, int j, int k, byte[] ds) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(ds);
            long l = zstdDecompressCtx.decompressByteArray(bs, i, bs.length - i, cs, j, k);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressDirectByteBufferUsingDict(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l, byte[] bs) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(bs);
            long l2 = zstdDecompressCtx.decompressDirectByteBuffer(byteBuffer, i, j, byteBuffer2, k, l);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressFastDict(byte[] bs, int i, byte[] cs, int j, int k, ZstdDictDecompress zstdDictDecompress) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(zstdDictDecompress);
            long l = zstdDecompressCtx.decompressByteArray(bs, i, bs.length - i, cs, j, k);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressDirectByteBufferFastDict(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l, ZstdDictDecompress zstdDictDecompress) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(zstdDictDecompress);
            long l2 = zstdDecompressCtx.decompressDirectByteBuffer(byteBuffer, i, j, byteBuffer2, k, l);
            return l2;
        }
    }

    public static native int loadDictDecompress(long var0, byte[] var2, int var3);

    public static native int loadFastDictDecompress(long var0, ZstdDictDecompress var2);

    public static native int loadDictCompress(long var0, byte[] var2, int var3);

    public static native int loadFastDictCompress(long var0, ZstdDictCompress var2);

    public static native void registerSequenceProducer(long var0, long var2, long var4);

    static native long getBuiltinSequenceProducer();

    static native void generateSequences(long var0, long var2, long var4, long var6, long var8);

    static native long getStubSequenceProducer();

    public static native int setCompressionChecksums(long var0, boolean var2);

    public static native int setCompressionMagicless(long var0, boolean var2);

    public static native int setCompressionLevel(long var0, int var2);

    public static native int setCompressionLong(long var0, int var2);

    public static native int setCompressionWorkers(long var0, int var2);

    public static native int setCompressionOverlapLog(long var0, int var2);

    public static native int setCompressionJobSize(long var0, int var2);

    public static native int setCompressionTargetLength(long var0, int var2);

    public static native int setCompressionMinMatch(long var0, int var2);

    public static native int setCompressionSearchLog(long var0, int var2);

    public static native int setCompressionChainLog(long var0, int var2);

    public static native int setCompressionHashLog(long var0, int var2);

    public static native int setCompressionWindowLog(long var0, int var2);

    public static native int setCompressionStrategy(long var0, int var2);

    public static native int setDecompressionLongMax(long var0, int var2);

    public static native int setDecompressionMagicless(long var0, boolean var2);

    public static native int setRefMultipleDDicts(long var0, boolean var2);

    public static native int setValidateSequences(long var0, int var2);

    public static native int setSequenceProducerFallback(long var0, boolean var2);

    public static native int setSearchForExternalRepcodes(long var0, int var2);

    public static native int setEnableLongDistanceMatching(long var0, int var2);

    public static long findFrameCompressedSize(byte[] bs, int i, int j) {
        if (i >= bs.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        if (i + j > bs.length) {
            throw new ArrayIndexOutOfBoundsException(i + j);
        }
        long l = Zstd.findFrameCompressedSize0(bs, i, j);
        if (Zstd.isError(l)) {
            throw new ZstdException(l);
        }
        return l;
    }

    private static native long findFrameCompressedSize0(byte[] var0, int var1, int var2);

    public static long findFrameCompressedSize(byte[] bs, int i) {
        return Zstd.findFrameCompressedSize(bs, i, bs.length - i);
    }

    public static long findFrameCompressedSize(byte[] bs) {
        return Zstd.findFrameCompressedSize(bs, 0);
    }

    public static long findFrameCompressedSize(ByteBuffer byteBuffer) {
        return Zstd.findDirectByteBufferFrameCompressedSize(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    public static native long findDirectByteBufferFrameCompressedSize(ByteBuffer var0, int var1, int var2);

    public static long getFrameContentSize(byte[] bs, int i, int j, boolean bl) {
        if (i >= bs.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        if (i + j > bs.length) {
            throw new ArrayIndexOutOfBoundsException(i + j);
        }
        return Zstd.getFrameContentSize0(bs, i, j, bl);
    }

    private static native long getFrameContentSize0(byte[] var0, int var1, int var2, boolean var3);

    @Deprecated
    public static long decompressedSize(byte[] bs, int i, int j, boolean bl) {
        if (i >= bs.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        if (i + j > bs.length) {
            throw new ArrayIndexOutOfBoundsException(i + j);
        }
        return Zstd.decompressedSize0(bs, i, j, bl);
    }

    private static native long decompressedSize0(byte[] var0, int var1, int var2, boolean var3);

    public static long getFrameContentSize(byte[] bs, int i, int j) {
        return Zstd.getFrameContentSize(bs, i, j, false);
    }

    @Deprecated
    public static long decompressedSize(byte[] bs, int i, int j) {
        return Zstd.decompressedSize(bs, i, j, false);
    }

    public static long getFrameContentSize(byte[] bs, int i) {
        return Zstd.getFrameContentSize(bs, i, bs.length - i);
    }

    @Deprecated
    public static long decompressedSize(byte[] bs, int i) {
        return Zstd.decompressedSize(bs, i, bs.length - i);
    }

    public static long getFrameContentSize(byte[] bs) {
        return Zstd.getFrameContentSize(bs, 0);
    }

    @Deprecated
    public static long decompressedSize(byte[] bs) {
        return Zstd.decompressedSize(bs, 0);
    }

    @Deprecated
    public static native long decompressedDirectByteBufferSize(ByteBuffer var0, int var1, int var2, boolean var3);

    public static native long getDirectByteBufferFrameContentSize(ByteBuffer var0, int var1, int var2, boolean var3);

    @Deprecated
    public static long decompressedDirectByteBufferSize(ByteBuffer byteBuffer, int i, int j) {
        return Zstd.decompressedDirectByteBufferSize(byteBuffer, i, j, false);
    }

    public static long getDirectByteBufferFrameContentSize(ByteBuffer byteBuffer, int i, int j) {
        return Zstd.getDirectByteBufferFrameContentSize(byteBuffer, i, j, false);
    }

    public static native long compressBound(long var0);

    public static native boolean isError(long var0);

    public static native String getErrorName(long var0);

    public static native long getErrorCode(long var0);

    public static native long errNoError();

    public static native long errGeneric();

    public static native long errPrefixUnknown();

    public static native long errVersionUnsupported();

    public static native long errFrameParameterUnsupported();

    public static native long errFrameParameterWindowTooLarge();

    public static native long errCorruptionDetected();

    public static native long errChecksumWrong();

    public static native long errDictionaryCorrupted();

    public static native long errDictionaryWrong();

    public static native long errDictionaryCreationFailed();

    public static native long errParameterUnsupported();

    public static native long errParameterOutOfBound();

    public static native long errTableLogTooLarge();

    public static native long errMaxSymbolValueTooLarge();

    public static native long errMaxSymbolValueTooSmall();

    public static native long errStageWrong();

    public static native long errInitMissing();

    public static native long errMemoryAllocation();

    public static native long errWorkSpaceTooSmall();

    public static native long errDstSizeTooSmall();

    public static native long errSrcSizeWrong();

    public static native long errDstBufferNull();

    public static long trainFromBuffer(byte[][] bs, byte[] cs, boolean bl) {
        return Zstd.trainFromBuffer(bs, cs, bl, Zstd.defaultCompressionLevel());
    }

    public static long trainFromBuffer(byte[][] bs, byte[] cs, boolean bl, int i) {
        if (bs.length <= 10) {
            throw new ZstdException(Zstd.errGeneric(), "nb of samples too low");
        }
        return Zstd.trainFromBuffer0(bs, cs, bl, i);
    }

    private static native long trainFromBuffer0(byte[][] var0, byte[] var1, boolean var2, int var3);

    public static long trainFromBufferDirect(ByteBuffer byteBuffer, int[] is, ByteBuffer byteBuffer2, boolean bl) {
        return Zstd.trainFromBufferDirect(byteBuffer, is, byteBuffer2, bl, Zstd.defaultCompressionLevel());
    }

    public static long trainFromBufferDirect(ByteBuffer byteBuffer, int[] is, ByteBuffer byteBuffer2, boolean bl, int i) {
        if (is.length <= 10) {
            throw new ZstdException(Zstd.errGeneric(), "nb of samples too low");
        }
        return Zstd.trainFromBufferDirect0(byteBuffer, is, byteBuffer2, bl, i);
    }

    private static native long trainFromBufferDirect0(ByteBuffer var0, int[] var1, ByteBuffer var2, boolean var3, int var4);

    public static native long getDictIdFromFrame(byte[] var0);

    public static native long getDictIdFromFrameBuffer(ByteBuffer var0);

    public static native long getDictIdFromDict(byte[] var0);

    private static native long getDictIdFromDictDirect(ByteBuffer var0, int var1, int var2);

    public static long getDictIdFromDictDirect(ByteBuffer byteBuffer) {
        int n = byteBuffer.limit() - byteBuffer.position();
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dict must be a direct buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("dict cannot be empty.");
        }
        return Zstd.getDictIdFromDictDirect(byteBuffer, byteBuffer.position(), n);
    }

    public static long trainFromBuffer(byte[][] bs, byte[] cs) {
        return Zstd.trainFromBuffer(bs, cs, false);
    }

    public static long trainFromBufferDirect(ByteBuffer byteBuffer, int[] is, ByteBuffer byteBuffer2) {
        return Zstd.trainFromBufferDirect(byteBuffer, is, byteBuffer2, false);
    }

    public static native int magicNumber();

    public static native int windowLogMin();

    public static native int windowLogMax();

    public static native int chainLogMin();

    public static native int chainLogMax();

    public static native int hashLogMin();

    public static native int hashLogMax();

    public static native int searchLogMin();

    public static native int searchLogMax();

    public static native int searchLengthMin();

    public static native int searchLengthMax();

    public static native int blockSizeMax();

    public static native int defaultCompressionLevel();

    public static native int minCompressionLevel();

    public static native int maxCompressionLevel();

    public static byte[] compress(byte[] bs) {
        return Zstd.compress(bs, Zstd.defaultCompressionLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] bs, int i) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(i);
            byte[] byArray = zstdCompressCtx.compress(bs);
            return byArray;
        }
    }

    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return Zstd.compress(byteBuffer, byteBuffer2, Zstd.defaultCompressionLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int i, boolean bl) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(i);
            zstdCompressCtx.setChecksum(bl);
            int n = zstdCompressCtx.compress(byteBuffer, byteBuffer2);
            return n;
        }
    }

    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int i) {
        return Zstd.compress(byteBuffer, byteBuffer2, i, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer compress(ByteBuffer byteBuffer, int i) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.setLevel(i);
            ByteBuffer byteBuffer2 = zstdCompressCtx.compress(byteBuffer);
            return byteBuffer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] bs, ZstdDictCompress zstdDictCompress) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(zstdDictCompress);
            zstdCompressCtx.setLevel(zstdDictCompress.level());
            byte[] byArray = zstdCompressCtx.compress(bs);
            return byArray;
        }
    }

    @Deprecated
    public static long compressUsingDict(byte[] bs, byte[] cs, byte[] ds, int i) {
        return Zstd.compressUsingDict(bs, 0, cs, 0, cs.length, ds, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressUsingDict(byte[] bs, byte[] cs, int i) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(cs);
            zstdCompressCtx.setLevel(i);
            byte[] byArray = zstdCompressCtx.compress(bs);
            return byArray;
        }
    }

    public static long compress(byte[] bs, byte[] cs, byte[] ds, int i) {
        return Zstd.compressUsingDict(bs, 0, cs, 0, cs.length, ds, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, byte[] bs, int i) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(bs);
            zstdCompressCtx.setLevel(i);
            int n = zstdCompressCtx.compress(byteBuffer, byteBuffer2);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer compress(ByteBuffer byteBuffer, byte[] bs, int i) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(bs);
            zstdCompressCtx.setLevel(i);
            ByteBuffer byteBuffer2 = zstdCompressCtx.compress(byteBuffer);
            return byteBuffer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ZstdDictCompress zstdDictCompress) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(zstdDictCompress);
            zstdCompressCtx.setLevel(zstdDictCompress.level());
            int n = zstdCompressCtx.compress(byteBuffer, byteBuffer2);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer compress(ByteBuffer byteBuffer, ZstdDictCompress zstdDictCompress) {
        try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
            zstdCompressCtx.loadDict(zstdDictCompress);
            zstdCompressCtx.setLevel(zstdDictCompress.level());
            ByteBuffer byteBuffer2 = zstdCompressCtx.compress(byteBuffer);
            return byteBuffer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] bs, int i) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            byte[] byArray = zstdDecompressCtx.decompress(bs, i);
            return byArray;
        }
    }

    public static byte[] decompress(byte[] bs) {
        ArrayList<FrameData> arrayList = new ArrayList<FrameData>();
        int n = Zstd.calculateContentSizeAndFrames(bs, arrayList);
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            FrameData frameData = (FrameData)arrayList.get(i);
            long l = Zstd.decompressByteArray(byArray, n3, (int)frameData.contentSize, bs, n2, (int)frameData.compressedSize);
            if (Zstd.isError(l)) {
                throw new ZstdException(l, String.format("error %s while decompressing %d frame", Zstd.getErrorName(l), i));
            }
            if (l != frameData.contentSize) {
                throw new IllegalStateException("decompressed size mismatch");
            }
            n2 += (int)frameData.compressedSize;
            n3 += (int)frameData.contentSize;
        }
        return byArray;
    }

    private static int calculateContentSizeAndFrames(byte[] bs, List<FrameData> list) {
        int n = 0;
        int n2 = 0;
        while (n2 < bs.length) {
            FrameData frameData = new FrameData(bs, n2);
            list.add(frameData);
            n2 += (int)frameData.compressedSize;
            n += (int)frameData.contentSize;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompressFrame(byte[] bs, int i, int j, int k) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            byte[] byArray = zstdDecompressCtx.decompress(bs, i, j, k);
            return byArray;
        }
    }

    public static byte[] decompressFrame(byte[] bs, int i) {
        int n = (int)Zstd.findFrameCompressedSize(bs, i);
        long l = Zstd.getFrameContentSize(bs, i, n);
        if (Zstd.isError(l)) {
            if (l == -1L) {
                throw new ZstdException(l, "Content size is unknown");
            }
            throw new ZstdException(l);
        }
        return Zstd.decompressFrame(bs, i, n, (int)l);
    }

    public static byte[] decompressFrame(byte[] bs) {
        return Zstd.decompressFrame(bs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            int n = zstdDecompressCtx.decompress(byteBuffer, byteBuffer2);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(ByteBuffer byteBuffer, byte[] bs) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            int n = zstdDecompressCtx.decompress(byteBuffer, bs);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decompress(ByteBuffer byteBuffer, int i) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            ByteBuffer byteBuffer2 = zstdDecompressCtx.decompress(byteBuffer, i);
            return byteBuffer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] bs, ZstdDictDecompress zstdDictDecompress, int i) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(zstdDictDecompress);
            byte[] byArray = zstdDecompressCtx.decompress(bs, i);
            return byArray;
        }
    }

    @Deprecated
    public static long decompressUsingDict(byte[] bs, byte[] cs, byte[] ds) {
        return Zstd.decompressUsingDict(bs, 0, cs, 0, cs.length, ds);
    }

    public static long decompress(byte[] bs, byte[] cs, byte[] ds) {
        return Zstd.decompressUsingDict(bs, 0, cs, 0, cs.length, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] bs, byte[] cs, int i) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(cs);
            byte[] byArray = zstdDecompressCtx.decompress(bs, i);
            return byArray;
        }
    }

    @Deprecated
    public static long decompressedSize(ByteBuffer byteBuffer) {
        return Zstd.decompressedDirectByteBufferSize(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    public static long getFrameContentSize(ByteBuffer byteBuffer) {
        return Zstd.getDirectByteBufferFrameContentSize(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, byte[] bs) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(bs);
            int n = zstdDecompressCtx.decompress(byteBuffer, byteBuffer2);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decompress(ByteBuffer byteBuffer, byte[] bs, int i) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(bs);
            ByteBuffer byteBuffer2 = zstdDecompressCtx.decompress(byteBuffer, i);
            return byteBuffer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ZstdDictDecompress zstdDictDecompress) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(zstdDictDecompress);
            int n = zstdDecompressCtx.decompress(byteBuffer, byteBuffer2);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decompress(ByteBuffer byteBuffer, ZstdDictDecompress zstdDictDecompress, int i) {
        try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
            zstdDecompressCtx.loadDict(zstdDictDecompress);
            ByteBuffer byteBuffer2 = zstdDecompressCtx.decompress(byteBuffer, i);
            return byteBuffer2;
        }
    }

    static ByteBuffer getArrayBackedBuffer(BufferPool bufferPool, int i) throws ZstdIOException {
        ByteBuffer byteBuffer = bufferPool.get(i);
        if (byteBuffer == null) {
            throw new ZstdIOException(Zstd.errMemoryAllocation(), "Cannot get ByteBuffer of size " + i + " from the BufferPool");
        }
        if (!byteBuffer.hasArray() || byteBuffer.arrayOffset() != 0) {
            bufferPool.release(byteBuffer);
            throw new IllegalArgumentException("provided ByteBuffer lacks array or has non-zero arrayOffset");
        }
        return byteBuffer;
    }

    static {
        Native.load();
    }

    private static class FrameData {
        final long contentSize;
        final long compressedSize;

        FrameData(byte[] bs, int i) {
            this.compressedSize = Zstd.findFrameCompressedSize(bs, i);
            this.contentSize = Zstd.getFrameContentSize(bs, i, (int)this.compressedSize);
            if (Zstd.isError(this.contentSize)) {
                if (this.contentSize == -1L) {
                    throw new ZstdException(this.contentSize, "Content size is unknown");
                }
                throw new ZstdException(this.contentSize);
            }
        }
    }

    public static enum ParamSwitch {
        AUTO(0),
        ENABLE(1),
        DISABLE(2);

        private int val;

        private ParamSwitch(int j) {
            this.val = j;
        }

        public int getValue() {
            return this.val;
        }
    }
}

