/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPopup;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.GameItem;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;
import org.jackhuang.hmcl.util.logging.Logger;

public final class MainPage
extends StackPane
implements DecoratorPage {
    private static final String ANNOUNCEMENT = "announcement";
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final PopupMenu menu = new PopupMenu();
    private final StackPane popupWrapper = new StackPane(new Node[]{this.menu});
    private final JFXPopup popup = new JFXPopup((Region)this.popupWrapper);
    private final StringProperty currentGame = new SimpleStringProperty((Object)this, "currentGame");
    private final BooleanProperty showUpdate = new SimpleBooleanProperty((Object)this, "showUpdate");
    private final ObjectProperty<RemoteVersion> latestVersion = new SimpleObjectProperty((Object)this, "latestVersion");
    private final ObservableList<Version> versions = FXCollections.observableArrayList();
    private final ObservableList<Node> versionNodes;
    private Profile profile;
    private TransitionPane announcementPane;
    private final StackPane updatePane;
    private final JFXButton menuButton;

    public MainPage() {
        HBox titleNode = new HBox(8.0);
        titleNode.setPadding(new Insets(0.0, 0.0, 0.0, 2.0));
        titleNode.setAlignment(Pos.CENTER_LEFT);
        ImageView titleIcon = new ImageView(FXUtils.newBuiltinImage("/assets/img/icon-title.png"));
        Label titleLabel = new Label(Metadata.FULL_TITLE);
        if (I18n.isUpsideDown()) {
            titleIcon.setRotate(180.0);
            titleLabel.setRotate(180.0);
        }
        titleLabel.getStyleClass().add((Object)"jfx-decorator-title");
        titleNode.getChildren().setAll((Object[])new Node[]{titleIcon, titleLabel});
        this.state.setValue((Object)new DecoratorPage.State(null, (Node)titleNode, false, false, true));
        this.setPadding(new Insets(20.0));
        if (Metadata.isNightly() || Metadata.isDev() && !Objects.equals(Metadata.VERSION, ConfigHolder.config().getShownTips().get((Object)ANNOUNCEMENT))) {
            String content;
            String title;
            if (Metadata.isNightly()) {
                title = I18n.i18n("update.channel.nightly.title");
                content = I18n.i18n("update.channel.nightly.hint");
            } else {
                title = I18n.i18n("update.channel.dev.title");
                content = I18n.i18n("update.channel.dev.hint");
            }
            VBox announcementCard = new VBox();
            BorderPane titleBar = new BorderPane();
            titleBar.getStyleClass().add((Object)"title");
            titleBar.setLeft((Node)new Label(title));
            JFXButton btnHide = new JFXButton();
            btnHide.setOnAction(e -> {
                this.announcementPane.setContent((Node)new StackPane(), ContainerAnimations.FADE);
                if (Metadata.isDev()) {
                    ConfigHolder.config().getShownTips().put((Object)ANNOUNCEMENT, (Object)Metadata.VERSION);
                }
            });
            btnHide.getStyleClass().add((Object)"announcement-close-button");
            btnHide.setGraphic(SVG.CLOSE.createIcon((Paint)Theme.blackFill(), 20.0));
            titleBar.setRight((Node)btnHide);
            TextFlow body = FXUtils.segmentToTextFlow(content, Controllers::onHyperlinkAction);
            body.setLineSpacing(4.0);
            announcementCard.getChildren().setAll((Object[])new Node[]{titleBar, body});
            announcementCard.setSpacing(16.0);
            announcementCard.getStyleClass().addAll((Object[])new String[]{"card", ANNOUNCEMENT});
            VBox announcementBox = new VBox(16.0);
            announcementBox.getChildren().add((Object)announcementCard);
            this.announcementPane = new TransitionPane();
            this.announcementPane.setContent((Node)announcementBox, ContainerAnimations.NONE);
            this.getChildren().add((Object)this.announcementPane);
        }
        this.updatePane = new StackPane();
        this.updatePane.setVisible(false);
        this.updatePane.getStyleClass().add((Object)"bubble");
        FXUtils.setLimitWidth((Region)this.updatePane, 230.0);
        FXUtils.setLimitHeight((Region)this.updatePane, 55.0);
        StackPane.setAlignment((Node)this.updatePane, (Pos)Pos.TOP_RIGHT);
        FXUtils.onClicked((Node)this.updatePane, this::onUpgrade);
        FXUtils.onChange(this.showUpdateProperty(), this::showUpdate);
        HBox hBox = new HBox();
        hBox.setSpacing(12.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)hBox, (Pos)Pos.CENTER_LEFT);
        StackPane.setMargin((Node)hBox, (Insets)new Insets(9.0, 12.0, 9.0, 16.0));
        Label lblIcon = new Label();
        lblIcon.setGraphic(SVG.UPDATE.createIcon((Paint)Theme.whiteFill(), 20.0));
        TwoLineListItem prompt = new TwoLineListItem();
        prompt.setSubtitle(I18n.i18n("update.bubble.subtitle"));
        prompt.setPickOnBounds(false);
        prompt.titleProperty().bind(BindingMapping.of(this.latestVersionProperty()).map(latestVersion -> latestVersion == null ? "" : I18n.i18n("update.bubble.title", latestVersion.getVersion())));
        hBox.getChildren().setAll((Object[])new Node[]{lblIcon, prompt});
        JFXButton closeUpdateButton = new JFXButton();
        closeUpdateButton.setGraphic(SVG.CLOSE.createIcon((Paint)Theme.whiteFill(), 10.0));
        StackPane.setAlignment((Node)closeUpdateButton, (Pos)Pos.TOP_RIGHT);
        closeUpdateButton.getStyleClass().add((Object)"toggle-icon-tiny");
        StackPane.setMargin((Node)closeUpdateButton, (Insets)new Insets(5.0));
        closeUpdateButton.setOnAction(e -> this.closeUpdateBubble());
        this.updatePane.getChildren().setAll((Object[])new Node[]{hBox, closeUpdateButton});
        StackPane launchPane = new StackPane();
        launchPane.getStyleClass().add((Object)"launch-pane");
        launchPane.setMaxWidth(230.0);
        launchPane.setMaxHeight(55.0);
        FXUtils.onScroll((Node)launchPane, this.versions, list -> {
            String currentId = this.getCurrentGame();
            return Lang.indexWhere(list, instance -> instance.getId().equals(currentId));
        }, it -> this.profile.setSelectedVersion(it.getId()));
        StackPane.setAlignment((Node)launchPane, (Pos)Pos.BOTTOM_RIGHT);
        final JFXButton launchButton = new JFXButton();
        launchButton.setPrefWidth(230.0);
        launchButton.setPrefHeight(55.0);
        launchButton.setDefaultButton(true);
        launchButton.setClip((Node)new Rectangle(-100.0, -100.0, 310.0, 200.0));
        final VBox graphic = new VBox();
        graphic.setAlignment(Pos.CENTER);
        graphic.setTranslateX(-7.0);
        graphic.setMaxWidth(200.0);
        final Label launchLabel = new Label();
        launchLabel.setStyle("-fx-font-size: 16px;");
        final Label currentLabel = new Label();
        currentLabel.setStyle("-fx-font-size: 12px;");
        FXUtils.onChangeAndOperate(this.currentGameProperty(), new Consumer<String>(){
            private Tooltip tooltip;

            @Override
            public void accept(String currentGame) {
                if (currentGame == null) {
                    launchLabel.setText(I18n.i18n("version.launch.empty"));
                    currentLabel.setText(null);
                    graphic.getChildren().setAll((Object[])new Node[]{launchLabel});
                    launchButton.setOnAction(e -> MainPage.this.launchNoGame());
                    if (this.tooltip == null) {
                        this.tooltip = new Tooltip(I18n.i18n("version.launch.empty.tooltip"));
                    }
                    FXUtils.installFastTooltip((Node)launchButton, this.tooltip);
                } else {
                    launchLabel.setText(I18n.i18n("version.launch"));
                    currentLabel.setText(currentGame);
                    graphic.getChildren().setAll((Object[])new Node[]{launchLabel, currentLabel});
                    launchButton.setOnAction(e -> MainPage.this.launch());
                    if (this.tooltip != null) {
                        Tooltip.uninstall((Node)launchButton, (Tooltip)this.tooltip);
                    }
                }
            }
        });
        launchButton.setGraphic((Node)graphic);
        Rectangle separator = new Rectangle();
        separator.setWidth(1.0);
        separator.setHeight(57.0);
        separator.setTranslateX(95.0);
        separator.setMouseTransparent(true);
        this.menuButton = new JFXButton();
        this.menuButton.setPrefHeight(55.0);
        this.menuButton.setPrefWidth(230.0);
        this.menuButton.setStyle("-fx-font-size: 15px;");
        this.menuButton.setOnAction(e -> this.onMenu());
        this.menuButton.setClip((Node)new Rectangle(211.0, -100.0, 100.0, 200.0));
        StackPane graphic2 = new StackPane();
        Node svg = SVG.ARROW_DROP_UP.createIcon((ObservableValue<? extends Paint>)Theme.foregroundFillBinding(), 30.0);
        StackPane.setAlignment((Node)svg, (Pos)Pos.CENTER_RIGHT);
        graphic2.getChildren().setAll((Object[])new Node[]{svg});
        graphic2.setTranslateX(6.0);
        FXUtils.installFastTooltip((Node)this.menuButton, I18n.i18n("version.switch"));
        this.menuButton.setGraphic((Node)graphic2);
        EventHandler secondaryClickHandle = event -> {
            if (event.getButton() == MouseButton.SECONDARY && event.getClickCount() == 1) {
                this.menuButton.fire();
                event.consume();
            }
        };
        launchButton.addEventHandler(MouseEvent.MOUSE_CLICKED, secondaryClickHandle);
        this.menuButton.addEventHandler(MouseEvent.MOUSE_CLICKED, secondaryClickHandle);
        launchPane.getChildren().setAll((Object[])new Node[]{launchButton, separator, this.menuButton});
        this.getChildren().addAll((Object[])new Node[]{this.updatePane, launchPane});
        this.menu.setMaxHeight(365.0);
        this.menu.setMaxWidth(545.0);
        this.menu.setAlwaysShowingVBar(true);
        FXUtils.onClicked((Node)this.menu, this.popup::hide);
        this.versionNodes = MappedObservableList.create(this.versions, version -> {
            Node node = PopupMenu.wrapPopupMenuItem((Node)new GameItem(this.profile, version.getId()));
            FXUtils.onClicked(node, () -> {
                this.profile.setSelectedVersion(version.getId());
                this.popup.hide();
            });
            return node;
        });
        Bindings.bindContent(this.menu.getContent(), this.versionNodes);
    }

    private void showUpdate(boolean show) {
        this.doAnimation(show);
        if (show && this.getLatestVersion() != null && !Objects.equals(ConfigHolder.config().getPromptedVersion(), this.getLatestVersion().getVersion())) {
            Controllers.dialog((Region)new MessageDialogPane.Builder("", I18n.i18n("update.bubble.title", this.getLatestVersion().getVersion()), MessageDialogPane.MessageType.INFO).addAction(I18n.i18n("button.view"), () -> {
                ConfigHolder.config().setPromptedVersion(this.getLatestVersion().getVersion());
                this.onUpgrade();
            }).addCancel(null).build());
        }
    }

    private void doAnimation(boolean show) {
        if (AnimationUtils.isAnimationEnabled()) {
            Duration duration = Duration.millis((double)320.0);
            Timeline nowAnimation = new Timeline();
            nowAnimation.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.updatePane.translateXProperty(), (Object)(show ? 260 : 0), FXUtils.SINE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.updatePane.translateXProperty(), (Object)(show ? 0 : 260), FXUtils.SINE)})});
            if (show) {
                nowAnimation.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, e -> this.updatePane.setVisible(true), new KeyValue[0]));
            } else {
                nowAnimation.getKeyFrames().add((Object)new KeyFrame(duration, e -> this.updatePane.setVisible(false), new KeyValue[0]));
            }
            nowAnimation.play();
        } else {
            this.updatePane.setVisible(show);
        }
    }

    private void launch() {
        Profile profile = Profiles.getSelectedProfile();
        Versions.launch(profile, profile.getSelectedVersion(), null);
    }

    private void launchNoGame() {
        DownloadProvider downloadProvider = DownloadProviders.getDownloadProvider();
        VersionList<?> versionList = downloadProvider.getVersionListById("game");
        Holder gameVersionHolder = new Holder();
        Task<Void> task = versionList.refreshAsync("").thenSupplyAsync(() -> versionList.getVersions("").stream().filter(it -> it.getVersionType() == RemoteVersion.Type.RELEASE).sorted().findFirst().orElseThrow(() -> new IOException("No versions found"))).thenComposeAsync(version -> {
            Profile profile = Profiles.getSelectedProfile();
            DefaultDependencyManager dependency = profile.getDependency();
            gameVersionHolder.value = version.getGameVersion();
            String gameVersion = gameVersionHolder.value;
            return dependency.gameBuilder().name(gameVersion).gameVersion(gameVersion).buildAsync();
        }).whenComplete(any -> this.profile.getRepository().refreshVersions()).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.profile.setSelectedVersion((String)gameVersionHolder.value);
                this.launch();
            } else if (exception instanceof CancellationException) {
                Controllers.showToast(I18n.i18n("message.cancelled"));
            } else {
                Logger.LOG.warning("Failed to install game", exception);
                Controllers.dialog(StringUtils.getStackTrace(exception), I18n.i18n("install.failed"), MessageDialogPane.MessageType.WARNING);
            }
        });
        Controllers.taskDialog(task, I18n.i18n("version.launch.empty.installing"), TaskCancellationAction.NORMAL);
    }

    private void onMenu() {
        PopupMenu contentNode;
        if (this.menu.getContent().isEmpty()) {
            Label placeholder = new Label(I18n.i18n("version.empty"));
            placeholder.setStyle("-fx-padding: 10px; -fx-text-fill: gray; -fx-font-style: italic;");
            contentNode = placeholder;
        } else {
            contentNode = this.menu;
        }
        this.popupWrapper.getChildren().setAll((Object[])new Node[]{contentNode});
        if (this.popup.isShowing()) {
            this.popup.hide();
        }
        this.popup.show((Node)this.menuButton, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.RIGHT, 0.0, -this.menuButton.getHeight());
    }

    private void onUpgrade() {
        RemoteVersion target = UpdateChecker.getLatestVersion();
        if (target == null) {
            return;
        }
        UpdateHandler.updateFrom(target);
    }

    private void closeUpdateBubble() {
        this.showUpdate.unbind();
        this.showUpdate.set(false);
    }

    public ReadOnlyObjectWrapper<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getCurrentGame() {
        return (String)this.currentGame.get();
    }

    public StringProperty currentGameProperty() {
        return this.currentGame;
    }

    public void setCurrentGame(String currentGame) {
        this.currentGame.set((Object)currentGame);
    }

    public ObservableList<Version> getVersions() {
        return this.versions;
    }

    public boolean isShowUpdate() {
        return this.showUpdate.get();
    }

    public BooleanProperty showUpdateProperty() {
        return this.showUpdate;
    }

    public void setShowUpdate(boolean showUpdate) {
        this.showUpdate.set(showUpdate);
    }

    public RemoteVersion getLatestVersion() {
        return (RemoteVersion)this.latestVersion.get();
    }

    public ObjectProperty<RemoteVersion> latestVersionProperty() {
        return this.latestVersion;
    }

    public void setLatestVersion(RemoteVersion latestVersion) {
        this.latestVersion.set((Object)latestVersion);
    }

    public void initVersions(Profile profile, List<Version> versions) {
        FXUtils.checkFxUserThread();
        this.profile = profile;
        this.versions.setAll(versions);
    }
}

