/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javafx.scene.Node;
import org.jackhuang.hmcl.game.ManuallyCreatedModpackException;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.MismatchedModpackTypeException;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.UnsupportedModpackException;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.download.LocalModpackPage;
import org.jackhuang.hmcl.ui.download.ModpackPage;
import org.jackhuang.hmcl.ui.download.ModpackSelectionPage;
import org.jackhuang.hmcl.ui.download.RemoteModpackPage;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class ModpackInstallWizardProvider
implements WizardProvider {
    private final Profile profile;
    private final Path file;
    private final String updateVersion;

    public ModpackInstallWizardProvider(Profile profile) {
        this(profile, null, null);
    }

    public ModpackInstallWizardProvider(Profile profile, Path modpackFile) {
        this(profile, modpackFile, null);
    }

    public ModpackInstallWizardProvider(Profile profile, String updateVersion) {
        this(profile, null, updateVersion);
    }

    public ModpackInstallWizardProvider(Profile profile, Path modpackFile, String updateVersion) {
        this.profile = profile;
        this.file = modpackFile;
        this.updateVersion = updateVersion;
    }

    @Override
    public void start(SettingsMap settings) {
        if (this.file != null) {
            settings.put(LocalModpackPage.MODPACK_FILE, this.file);
        }
        if (this.updateVersion != null) {
            settings.put(LocalModpackPage.MODPACK_NAME, this.updateVersion);
        }
        settings.put(ModpackPage.PROFILE, this.profile);
    }

    private Task<?> finishModpackInstallingAsync(SettingsMap settings) {
        Path selected = settings.get(LocalModpackPage.MODPACK_FILE);
        ServerModpackManifest serverModpackManifest = settings.get(RemoteModpackPage.MODPACK_SERVER_MANIFEST);
        Modpack modpack = settings.get(LocalModpackPage.MODPACK_MANIFEST);
        String name = settings.get(LocalModpackPage.MODPACK_NAME);
        Charset charset = settings.get(LocalModpackPage.MODPACK_CHARSET);
        boolean isManuallyCreated = settings.getOrDefault(LocalModpackPage.MODPACK_MANUALLY_CREATED, false);
        if (isManuallyCreated) {
            return ModpackHelper.getInstallManuallyCreatedModpackTask(this.profile, selected, name, charset);
        }
        if (selected == null && serverModpackManifest == null || modpack == null || name == null) {
            return null;
        }
        if (this.updateVersion != null) {
            if (selected == null) {
                Controllers.dialog(I18n.i18n("modpack.unsupported"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                return null;
            }
            try {
                if (serverModpackManifest != null) {
                    return ModpackHelper.getUpdateTask(this.profile, serverModpackManifest, modpack.getEncoding(), name, ModpackHelper.readModpackConfiguration(this.profile.getRepository().getModpackConfiguration(name)));
                }
                return ModpackHelper.getUpdateTask(this.profile, selected, modpack.getEncoding(), name, ModpackHelper.readModpackConfiguration(this.profile.getRepository().getModpackConfiguration(name)));
            }
            catch (ManuallyCreatedModpackException | UnsupportedModpackException e) {
                Controllers.dialog(I18n.i18n("modpack.unsupported"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
            catch (MismatchedModpackTypeException e) {
                Controllers.dialog(I18n.i18n("modpack.mismatched_type", e.getRequired(), e.getFound()), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
            catch (IOException e) {
                Controllers.dialog(I18n.i18n("modpack.invalid"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
            return null;
        }
        if (serverModpackManifest != null) {
            return ModpackHelper.getInstallTask(this.profile, serverModpackManifest, name, modpack).thenRunAsync(Schedulers.javafx(), () -> this.profile.setSelectedVersion(name));
        }
        return ModpackHelper.getInstallTask(this.profile, selected, name, modpack).thenRunAsync(Schedulers.javafx(), () -> this.profile.setSelectedVersion(name));
    }

    @Override
    public Object finish(SettingsMap settings) {
        settings.put("title", I18n.i18n("install.modpack.installation"));
        settings.put("success_message", I18n.i18n("install.success"));
        settings.put(WizardProvider.FailureCallback.KEY, (ignored, exception, next) -> {
            if (exception instanceof ModpackCompletionException) {
                if (exception.getCause() instanceof FileNotFoundException) {
                    Controllers.dialog(I18n.i18n("modpack.type.curse.not_found"), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
                } else {
                    Controllers.dialog(I18n.i18n("install.success"), I18n.i18n("install.success"), MessageDialogPane.MessageType.SUCCESS, next);
                }
            } else {
                UpdateInstallerWizardProvider.alertFailureMessage(exception, next);
            }
        });
        return this.finishModpackInstallingAsync(settings);
    }

    @Override
    public Node createPage(WizardController controller, int step, SettingsMap settings) {
        switch (step) {
            case 0: {
                return new ModpackSelectionPage(controller);
            }
            case 1: {
                if (controller.getSettings().containsKey(LocalModpackPage.MODPACK_FILE)) {
                    return new LocalModpackPage(controller);
                }
                if (controller.getSettings().containsKey(RemoteModpackPage.MODPACK_SERVER_MANIFEST)) {
                    return new RemoteModpackPage(controller);
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalStateException("error step " + step + ", settings: " + String.valueOf(settings) + ", pages: " + String.valueOf(controller.getPages()));
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

