/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.optifine;

import com.google.gson.annotations.SerializedName;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashSet;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class OptiFineBMCLVersionList
extends VersionList<OptiFineRemoteVersion> {
    private final String apiRoot;

    public OptiFineBMCLVersionList(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    @Override
    public boolean hasType() {
        return true;
    }

    private String fromLookupVersion(String version) {
        switch (version) {
            case "1.8.0": {
                return "1.8";
            }
            case "1.9.0": {
                return "1.9";
            }
        }
        return version;
    }

    private String toLookupVersion(String version) {
        switch (version) {
            case "1.8": {
                return "1.8.0";
            }
            case "1.9": {
                return "1.9.0";
            }
        }
        return version;
    }

    @Override
    public Task<?> refreshAsync() {
        return new GetTask(this.apiRoot + "/optifine/versionlist").thenGetJsonAsync(JsonUtils.listTypeOf(OptiFineVersion.class)).thenAcceptAsync(root -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                HashSet<CallSite> duplicates = new HashSet<CallSite>();
                for (OptiFineVersion element : root) {
                    boolean isPre;
                    String version = element.getType() + "_" + element.getPatch();
                    String mirror = "https://bmclapi2.bangbang93.com/optifine/" + this.toLookupVersion(element.getGameVersion()) + "/" + element.getType() + "/" + element.getPatch();
                    if (!duplicates.add((CallSite)((Object)mirror))) continue;
                    boolean bl = isPre = element.getPatch() != null && (element.getPatch().startsWith("pre") || element.getPatch().startsWith("alpha"));
                    if (StringUtils.isBlank(element.getGameVersion())) continue;
                    String gameVersion = VersionNumber.normalize(this.fromLookupVersion(element.getGameVersion()));
                    this.versions.put(gameVersion, new OptiFineRemoteVersion(gameVersion, version, Collections.singletonList(mirror), isPre));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private static final class OptiFineVersion {
        @SerializedName(value="dl")
        private final String downloadLink;
        @SerializedName(value="ver")
        private final String version;
        @SerializedName(value="date")
        private final String date;
        @SerializedName(value="type")
        private final String type;
        @SerializedName(value="patch")
        private final String patch;
        @SerializedName(value="mirror")
        private final String mirror;
        @SerializedName(value="mcversion")
        private final String gameVersion;

        public OptiFineVersion() {
            this(null, null, null, null, null, null, null);
        }

        public OptiFineVersion(String downloadLink, String version, String date, String type, String patch, String mirror, String gameVersion) {
            this.downloadLink = downloadLink;
            this.version = version;
            this.date = date;
            this.type = type;
            this.patch = patch;
            this.mirror = mirror;
            this.gameVersion = gameVersion;
        }

        public String getDownloadLink() {
            return this.downloadLink;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDate() {
            return this.date;
        }

        public String getType() {
            return this.type;
        }

        public String getPatch() {
            return this.patch;
        }

        public String getMirror() {
            return this.mirror;
        }

        public String getGameVersion() {
            return this.gameVersion;
        }
    }
}

