/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jetbrains.annotations.Unmodifiable;

public class AdaptedDownloadProvider
implements DownloadProvider {
    private @Unmodifiable List<DownloadProvider> downloadProviderCandidates;

    public void setDownloadProviderCandidates(List<DownloadProvider> downloadProviderCandidates) {
        this.downloadProviderCandidates = List.copyOf(downloadProviderCandidates);
    }

    public DownloadProvider getPreferredDownloadProvider() {
        List<DownloadProvider> d = this.downloadProviderCandidates;
        if (d == null || d.isEmpty()) {
            throw new IllegalStateException("No download provider candidate");
        }
        return d.get(0);
    }

    @Override
    public String getVersionListURL() {
        return this.getPreferredDownloadProvider().getVersionListURL();
    }

    @Override
    public String getAssetBaseURL() {
        return this.getPreferredDownloadProvider().getAssetBaseURL();
    }

    @Override
    public String injectURL(String baseURL) {
        return this.getPreferredDownloadProvider().injectURL(baseURL);
    }

    @Override
    public List<URI> getAssetObjectCandidates(String assetObjectLocation) {
        return this.downloadProviderCandidates.stream().flatMap(d -> d.getAssetObjectCandidates(assetObjectLocation).stream()).collect(Collectors.toList());
    }

    @Override
    public List<URI> injectURLWithCandidates(String baseURL) {
        return this.downloadProviderCandidates.stream().flatMap(d -> d.injectURLWithCandidates(baseURL).stream()).collect(Collectors.toList());
    }

    @Override
    public List<URI> injectURLsWithCandidates(List<String> urls) {
        return this.downloadProviderCandidates.stream().flatMap(d -> d.injectURLsWithCandidates(urls).stream()).collect(Collectors.toList());
    }

    @Override
    public VersionList<?> getVersionListById(String id) {
        return this.getPreferredDownloadProvider().getVersionListById(id);
    }

    @Override
    public int getConcurrency() {
        return this.getPreferredDownloadProvider().getConcurrency();
    }
}

