/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.glavo.pci.ids.internal.ArgumentValidator;
import org.glavo.pci.ids.internal.DatabaseFileParser;
import org.glavo.pci.ids.model.Device;
import org.glavo.pci.ids.model.DeviceClass;
import org.glavo.pci.ids.model.DeviceSubclass;
import org.glavo.pci.ids.model.ProgramInterface;
import org.glavo.pci.ids.model.Subsystem;
import org.glavo.pci.ids.model.Vendor;

public final class PCIIDsDatabase {
    private final SortedMap<Integer, Vendor> vendorDatabase = new TreeMap<Integer, Vendor>();
    private final SortedMap<Integer, DeviceClass> deviceClassDatabase = new TreeMap<Integer, DeviceClass>();

    public static PCIIDsDatabase load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            PCIIDsDatabase pCIIDsDatabase = PCIIDsDatabase.load(reader);
            return pCIIDsDatabase;
        }
    }

    public static PCIIDsDatabase load(InputStream inputStream) throws IOException {
        return PCIIDsDatabase.load(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
    }

    public static PCIIDsDatabase load(BufferedReader reader) throws IOException {
        ArgumentValidator.requireNonNull(reader, "PCI IDs database reader");
        PCIIDsDatabase database = new PCIIDsDatabase();
        DatabaseFileParser parser = new DatabaseFileParser();
        parser.parseDatabaseFile(reader, database.vendorDatabase, database.deviceClassDatabase);
        return database;
    }

    private PCIIDsDatabase() {
    }

    public List<Vendor> findAllVendors() {
        return new ArrayList<Vendor>(this.vendorDatabase.values());
    }

    public Vendor findVendor(int vendorId) {
        return (Vendor)this.vendorDatabase.get(vendorId);
    }

    public List<Device> findAllDevices(int vendorId) {
        Vendor v = (Vendor)this.vendorDatabase.get(vendorId);
        if (v == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Device>(v.getDevices().values());
    }

    public Device findDevice(int vendorId, int deviceId) {
        Vendor v = (Vendor)this.vendorDatabase.get(vendorId);
        if (v == null) {
            return null;
        }
        return (Device)v.getDevices().get(deviceId);
    }

    public List<Subsystem> findAllSubsystems(int vendorId, int deviceId) {
        Vendor v = (Vendor)this.vendorDatabase.get(vendorId);
        if (v == null) {
            return Collections.emptyList();
        }
        Device d = (Device)v.getDevices().get(deviceId);
        if (d == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Subsystem>(d.getSubsystems());
    }

    public List<Subsystem> findAllSubsystemsWithVendor(int vendorId, int deviceId, int subvendorId) {
        Vendor v = (Vendor)this.vendorDatabase.get(vendorId);
        if (v == null) {
            return Collections.emptyList();
        }
        Device d = (Device)v.getDevices().get(deviceId);
        if (d == null) {
            return Collections.emptyList();
        }
        return d.getSubsystems().stream().filter(s -> s.getVendorId() == subvendorId).sorted().collect(Collectors.toList());
    }

    public List<DeviceClass> findAllDeviceClasses() {
        return new ArrayList<DeviceClass>(this.deviceClassDatabase.values());
    }

    public DeviceClass findDeviceClass(int classId) {
        return (DeviceClass)this.deviceClassDatabase.get(classId);
    }

    public List<DeviceSubclass> findAllDeviceSubclasses(int classId) {
        DeviceClass d = (DeviceClass)this.deviceClassDatabase.get(classId);
        if (d == null) {
            return Collections.emptyList();
        }
        return new ArrayList<DeviceSubclass>(d.getSubclasses().values());
    }

    public DeviceSubclass findDeviceSubclass(int classId, int subclassId) {
        DeviceClass d = (DeviceClass)this.deviceClassDatabase.get(classId);
        return d != null ? d.getSubclasses().get(subclassId) : null;
    }

    public List<ProgramInterface> findAllProgramInterfaces(int classId, int subclassId) {
        DeviceClass d = (DeviceClass)this.deviceClassDatabase.get(classId);
        if (d == null) {
            return Collections.emptyList();
        }
        DeviceSubclass s = d.getSubclasses().get(subclassId);
        if (s == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ProgramInterface>(s.getProgramInterfaces().values());
    }

    public ProgramInterface findProgramInterface(int classId, int subclassId, int ifaceId) {
        DeviceClass d = (DeviceClass)this.deviceClassDatabase.get(classId);
        if (d == null) {
            return null;
        }
        DeviceSubclass s = d.getSubclasses().get(subclassId);
        if (s == null) {
            return null;
        }
        return (ProgramInterface)s.getProgramInterfaces().get(ifaceId);
    }
}

