/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.compressors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kala.compress.compressors.CompressorException;
import kala.compress.compressors.CompressorInputStream;
import kala.compress.compressors.CompressorOutputStream;
import kala.compress.compressors.CompressorStreamProvider;
import kala.compress.utils.IOUtils;
import org.jetbrains.annotations.ApiStatus;

public class CompressorStreamFactory
implements CompressorStreamProvider {
    public static final String BROTLI = "br";
    public static final String BZIP2 = "bzip2";
    public static final String GZIP = "gz";
    public static final String PACK200 = "pack200";
    public static final String XZ = "xz";
    public static final String LZMA = "lzma";
    public static final String SNAPPY_FRAMED = "snappy-framed";
    public static final String SNAPPY_RAW = "snappy-raw";
    public static final String Z = "z";
    public static final String DEFLATE = "deflate";
    public static final String DEFLATE64 = "deflate64";
    public static final String LZ4_BLOCK = "lz4-block";
    public static final String LZ4_FRAMED = "lz4-framed";
    public static final String ZSTANDARD = "zstd";
    private static final BuiltinCompressor[] BUILTIN_COMPRESSORS;
    private static final Set<String> ALL_NAMES;
    private static final Set<String> OUTPUT_NAMES;
    public static final CompressorStreamFactory DEFAULT;
    private final SortedMap<String, CompressorStreamProvider> compressorInputStreamProviders = new TreeMap<String, CompressorStreamProvider>();
    private final SortedMap<String, CompressorStreamProvider> compressorOutputStreamProviders = new TreeMap<String, CompressorStreamProvider>();
    private final Set<String> inputStreamCompressorNames = new HashSet<String>(ALL_NAMES);
    private final Set<String> outputStreamCompressorNames = new HashSet<String>(OUTPUT_NAMES);
    private final boolean decompressConcatenated;
    private final int memoryLimitInKb;

    public static String detect(InputStream inputStream) throws CompressorException {
        return CompressorStreamFactory.detect(inputStream, ALL_NAMES);
    }

    static String detect(InputStream inputStream, Set<String> compressorNames) throws CompressorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        if (compressorNames == null || compressorNames.isEmpty()) {
            throw new IllegalArgumentException("Compressor names cannot be null or empty");
        }
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Mark is not supported.");
        }
        byte[] signature = new byte[12];
        inputStream.mark(signature.length);
        int signatureLength = -1;
        try {
            signatureLength = IOUtils.readFully(inputStream, signature);
            inputStream.reset();
        }
        catch (IOException e) {
            throw new CompressorException("Failed to read signature.", e);
        }
        for (BuiltinCompressor compressor : BUILTIN_COMPRESSORS) {
            if (!compressorNames.contains(compressor.getName()) || !compressor.matches(signature, signatureLength)) continue;
            return compressor.getName();
        }
        throw new CompressorException("No Compressor found for the stream signature.");
    }

    private static String toKey(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public CompressorStreamFactory() {
        this(false);
    }

    public CompressorStreamFactory(boolean decompressUntilEOF) {
        this(decompressUntilEOF, -1);
    }

    public CompressorStreamFactory(boolean decompressUntilEOF, int memoryLimitInKb) {
        this.decompressConcatenated = decompressUntilEOF;
        this.memoryLimitInKb = memoryLimitInKb;
    }

    public CompressorInputStream createCompressorInputStream(InputStream in) throws CompressorException {
        return this.createCompressorInputStream(CompressorStreamFactory.detect(in), in);
    }

    public CompressorInputStream createCompressorInputStream(InputStream in, Set<String> compressorNames) throws CompressorException {
        return this.createCompressorInputStream(CompressorStreamFactory.detect(in, compressorNames), in);
    }

    public CompressorInputStream createCompressorInputStream(String name, InputStream in) throws CompressorException {
        return this.createCompressorInputStream(name, in, this.decompressConcatenated);
    }

    @Override
    public CompressorInputStream createCompressorInputStream(String name, InputStream in, boolean actualDecompressConcatenated) throws CompressorException {
        if (name == null || in == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        for (BuiltinCompressor compressor : BUILTIN_COMPRESSORS) {
            if (!compressor.getName().equalsIgnoreCase(name)) continue;
            return compressor.createCompressorInputStream(in, actualDecompressConcatenated, this.memoryLimitInKb);
        }
        CompressorStreamProvider compressorStreamProvider = (CompressorStreamProvider)this.compressorInputStreamProviders.get(CompressorStreamFactory.toKey(name));
        if (compressorStreamProvider != null) {
            return compressorStreamProvider.createCompressorInputStream(name, in, actualDecompressConcatenated);
        }
        throw new CompressorException("Compressor: " + name + " not found.");
    }

    @Override
    public CompressorOutputStream<?> createCompressorOutputStream(String name, OutputStream out) throws CompressorException {
        CompressorStreamProvider compressorStreamProvider;
        if (name == null || out == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        boolean found = false;
        for (BuiltinCompressor compressor : BUILTIN_COMPRESSORS) {
            if (!compressor.getName().equalsIgnoreCase(name)) continue;
            found = true;
            if (!compressor.isOutputAvailable()) break;
            return compressor.createCompressorOutputStream(out);
        }
        if ((compressorStreamProvider = (CompressorStreamProvider)this.compressorOutputStreamProviders.get(CompressorStreamFactory.toKey(name))) != null) {
            return compressorStreamProvider.createCompressorOutputStream(name, out);
        }
        if (found) {
            throw new CompressorException("Compressor: " + name + " currently only supports decompression.");
        }
        throw new CompressorException("Compressor: " + name + " not found.");
    }

    public boolean getDecompressConcatenated() {
        return this.decompressConcatenated;
    }

    @Override
    public Set<String> getInputStreamCompressorNames() {
        return Collections.unmodifiableSet(this.inputStreamCompressorNames);
    }

    @Override
    public Set<String> getOutputStreamCompressorNames() {
        return Collections.unmodifiableSet(this.outputStreamCompressorNames);
    }

    @ApiStatus.Experimental
    public CompressorStreamFactory withInstalledProviders() {
        return this.withProviders(ServiceLoader.load(CompressorStreamProvider.class));
    }

    @ApiStatus.Experimental
    public CompressorStreamFactory withInstalledProviders(ClassLoader classLoader) {
        return this.withProviders(ServiceLoader.load(CompressorStreamProvider.class, classLoader));
    }

    @ApiStatus.Experimental
    public CompressorStreamFactory withProviders(Iterable<? extends CompressorStreamProvider> providers) {
        CompressorStreamFactory result = new CompressorStreamFactory(this.decompressConcatenated, this.memoryLimitInKb);
        for (CompressorStreamProvider compressorStreamProvider : providers) {
            for (String name : compressorStreamProvider.getInputStreamCompressorNames()) {
                result.compressorInputStreamProviders.put(CompressorStreamFactory.toKey(name), compressorStreamProvider);
                result.inputStreamCompressorNames.add(name);
            }
            for (String name : compressorStreamProvider.getOutputStreamCompressorNames()) {
                result.compressorOutputStreamProviders.put(CompressorStreamFactory.toKey(name), compressorStreamProvider);
                result.outputStreamCompressorNames.add(name);
            }
        }
        return result;
    }

    static {
        String className = CompressorStreamFactory.class.getName();
        String packagePrefix = className.substring(0, className.lastIndexOf(".") + 1);
        String[] builtinCompressorClasses = new String[]{"brotli.BrotliCompressor", "bzip2.BZip2Compressor", "deflate.DeflateCompressor", "deflate64.Deflate64Compressor", "gzip.GzipCompressor", "lz4.BlockLZ4Compressor", "lz4.FramedLZ4Compressor", "lzma.LZMACompressor", "pack200.Pack200Compressor", "snappy.FramedSnappyCompressor", "snappy.SnappyCompressor", "xz.XZCompressor", "z.ZCompressor", "zstandard.ZstdCompressor"};
        ArrayList<BuiltinCompressor> compressors = new ArrayList<BuiltinCompressor>();
        HashSet<String> compressorNames = new HashSet<String>();
        HashSet<String> outputCompressorNames = new HashSet<String>();
        for (String cls : builtinCompressorClasses) {
            Class<?> clazz;
            try {
                clazz = Class.forName(packagePrefix + cls);
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            if (!BuiltinCompressor.class.isAssignableFrom(clazz)) {
                throw new LinkageError(clazz + " is not a subclass of BuiltinCompressor");
            }
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                BuiltinCompressor compressor = (BuiltinCompressor)constructor.newInstance(new Object[0]);
                compressors.add(compressor);
                compressorNames.add(compressor.getName());
                if (!compressor.isOutputAvailable()) continue;
                outputCompressorNames.add(compressor.getName());
            }
            catch (Throwable e) {
                throw new LinkageError(null, e);
            }
        }
        BUILTIN_COMPRESSORS = compressors.toArray(new BuiltinCompressor[0]);
        ALL_NAMES = Collections.unmodifiableSet(compressorNames);
        OUTPUT_NAMES = Collections.unmodifiableSet(outputCompressorNames);
        DEFAULT = new CompressorStreamFactory();
    }

    @ApiStatus.Internal
    public static abstract class BuiltinCompressor {
        private final String name;
        private final String unavailablePrompt;

        protected BuiltinCompressor(String name) {
            this.name = name;
            this.unavailablePrompt = "";
        }

        protected BuiltinCompressor(String name, String dependencyName, String url) {
            this.name = name;
            this.unavailablePrompt = " In addition to Apache Commons Compress you need the " + dependencyName + " library - see " + url;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCompressionAvailable() {
            return true;
        }

        public boolean isOutputAvailable() {
            return false;
        }

        public boolean matches(byte[] signature, int length) {
            return false;
        }

        protected abstract CompressorInputStream createCompressorInputStreamImpl(InputStream var1, boolean var2, int var3) throws IOException, CompressorException;

        protected CompressorOutputStream<?> createCompressorOutputImpl(OutputStream out) throws IOException {
            throw new CompressorException("Currently " + this + " does not support compression");
        }

        public final CompressorInputStream createCompressorInputStream(InputStream in, boolean decompressUntilEOF, int memoryLimitInKb) throws CompressorException {
            if (!this.isCompressionAvailable()) {
                throw new CompressorException(this + " is not available." + this.unavailablePrompt);
            }
            try {
                return this.createCompressorInputStreamImpl(in, decompressUntilEOF, memoryLimitInKb);
            }
            catch (IOException e) {
                throw new CompressorException("Could not create CompressorInputStream", e);
            }
        }

        public final CompressorOutputStream<?> createCompressorOutputStream(OutputStream out) throws CompressorException {
            if (!this.isCompressionAvailable()) {
                throw new CompressorException(this + " is not available." + this.unavailablePrompt);
            }
            try {
                return this.createCompressorOutputImpl(out);
            }
            catch (IOException e) {
                throw new CompressorException("Could not create CompressorOutputStream", e);
            }
        }

        public String toString() {
            return this.name + " compressor";
        }
    }
}

