/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.color.DiscreteAlphaIndexColorModel;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.Int16ImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.UInt32ImageTypeSpecifier;
import com.twelvemonkeys.lang.Validate;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.imageio.ImageTypeSpecifier;

public final class ImageTypeSpecifiers {
    private static final ImageTypeSpecifier TYPE_INT_RGB = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, 3, false);
    private static final ImageTypeSpecifier TYPE_INT_BGR = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 24, 255, 65280, 0xFF0000, 0, 3, false);
    private static final ImageTypeSpecifier TYPE_USHORT_565_RGB = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 16, 63488, 2016, 31, 0, 1, false);
    private static final ImageTypeSpecifier TYPE_USHORT_555_RGB = ImageTypeSpecifiers.createPackedOddBits(ColorSpace.getInstance(1000), 15, 31744, 992, 31, 0, 1, false);

    private ImageTypeSpecifiers() {
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n) {
        switch (n) {
            case 1: {
                return TYPE_INT_RGB;
            }
            case 4: {
                return TYPE_INT_BGR;
            }
            case 8: {
                return TYPE_USHORT_565_RGB;
            }
            case 9: {
                return TYPE_USHORT_555_RGB;
            }
        }
        return ImageTypeSpecifier.createFromBufferedImageType(n);
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = ImageTypeSpecifiers.calculateRequiredBits(n | n2 | n3 | n4);
        if (n6 != 32) {
            return ImageTypeSpecifiers.createPackedOddBits(colorSpace, n6, n, n2, n3, n4, n5, bl);
        }
        return ImageTypeSpecifier.createPacked(colorSpace, n, n2, n3, n4, n5, bl);
    }

    private static int calculateRequiredBits(int n) {
        int n2 = 1;
        while ((n >>>= 1) != 0) {
            ++n2;
        }
        return n2;
    }

    static ImageTypeSpecifier createPackedOddBits(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Validate.notNull(colorSpace, "colorSpace");
        Validate.isTrue(colorSpace.getType() == 5, colorSpace, "ColorSpace must be TYPE_RGB");
        Validate.isTrue(n2 != 0 || n3 != 0 || n4 != 0 || n5 != 0, "No mask has at least 1 bit set");
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, n, n2, n3, n4, n5, bl, n6);
        return new ImageTypeSpecifier(directColorModel, ((ColorModel)directColorModel).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
        if (n == 3) {
            return UInt32ImageTypeSpecifier.createInterleaved(colorSpace, nArray, bl, bl2);
        }
        return ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n, bl, bl2);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        if (n == 3) {
            return UInt32ImageTypeSpecifier.createBanded(colorSpace, nArray, nArray2, bl, bl2);
        }
        return ImageTypeSpecifier.createBanded(colorSpace, nArray, nArray2, n, bl, bl2);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2) {
        if (n == 16 && n2 == 2) {
            return new Int16ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0}, false, false);
        }
        if (n == 32 && n2 == 3) {
            return UInt32ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0}, false, false);
        }
        if (n2 == 4 || n2 == 5) {
            return ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0}, n2, false, false);
        }
        return ImageTypeSpecifier.createGrayscale(n, n2, false);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl) {
        if (n == 16 && n2 == 2) {
            return new Int16ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0, 1}, true, bl);
        }
        if (n == 32 && n2 == 3) {
            return UInt32ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0, 1}, true, bl);
        }
        if (n2 == 4 || n2 == 5) {
            return ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1003), new int[]{0, 1}, n2, true, bl);
        }
        return ImageTypeSpecifier.createGrayscale(n, n2, false, bl);
    }

    public static ImageTypeSpecifier createPackedGrayscale(ColorSpace colorSpace, int n, int n2) {
        IndexColorModel indexColorModel;
        Object object;
        Validate.notNull(colorSpace, "colorSpace");
        Validate.isTrue(colorSpace.getType() == 6, colorSpace, "ColorSpace must be TYPE_GRAY");
        Validate.isTrue(n == 1 || n == 2 || n == 4, n, "bits must be 1, 2, or 4: %s");
        Validate.isTrue(n2 == 0, n2, "dataType must be TYPE_BYTE: %s");
        int n3 = 1 << n;
        if (ColorSpace.getInstance(1003).equals(colorSpace)) {
            object = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                object[i] = (byte)(i * 255 / (n3 - 1));
            }
            indexColorModel = new IndexColorModel(n, n3, (byte[])object, (byte[])object, (byte[])object);
        } else {
            object = new byte[n3];
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                float[] fArray = new float[]{(float)i / (float)(n3 - 1)};
                float[] fArray2 = colorSpace.toRGB(fArray);
                object[i] = (byte)Math.round(fArray2[0] * 255.0f);
                byArray[i] = (byte)Math.round(fArray2[1] * 255.0f);
                byArray2[i] = (byte)Math.round(fArray2[2] * 255.0f);
            }
            indexColorModel = new IndexColorModel(n, n3, (byte[])object, byArray, byArray2);
        }
        object = new MultiPixelPackedSampleModel(n2, 1, 1, n);
        return new ImageTypeSpecifier(indexColorModel, (SampleModel)object);
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
        return ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, n, n2);
    }

    public static ImageTypeSpecifier createIndexed(int[] nArray, boolean bl, int n, int n2, int n3) {
        return ImageTypeSpecifiers.createFromIndexColorModel(new IndexColorModel(n2, nArray.length, nArray, 0, bl, n, n3));
    }

    public static ImageTypeSpecifier createFromIndexColorModel(IndexColorModel indexColorModel) {
        return new IndexedImageTypeSpecifier(indexColorModel);
    }

    public static ImageTypeSpecifier createDiscreteAlphaIndexedFromIndexColorModel(IndexColorModel indexColorModel) {
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        return new ImageTypeSpecifier(discreteAlphaIndexColorModel, ((ColorModel)discreteAlphaIndexColorModel).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createDiscreteExtraSamplesIndexedFromIndexColorModel(IndexColorModel indexColorModel, int n, boolean bl) {
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel, n, bl);
        return new ImageTypeSpecifier(discreteAlphaIndexColorModel, ((ColorModel)discreteAlphaIndexColorModel).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        int n;
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (renderedImage instanceof BufferedImage && (n = ((BufferedImage)renderedImage).getType()) != 0 && n != 12 && n != 13) {
            return ImageTypeSpecifiers.createFromBufferedImageType(n);
        }
        return new ImageTypeSpecifier(renderedImage);
    }
}

