/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.NativeUtils;
import org.jackhuang.hmcl.util.platform.windows.Advapi32;

public abstract class WinReg {
    public static final WinReg INSTANCE = NativeUtils.USE_JNA && Advapi32.INSTANCE != null ? new JNAWinReg(Advapi32.INSTANCE) : null;

    public abstract boolean exists(HKEY var1, String var2);

    public abstract Object queryValue(HKEY var1, String var2, String var3);

    public abstract List<String> querySubKeyNames(HKEY var1, String var2);

    public List<String> querySubKeys(HKEY root, String key) {
        List<String> list = this.querySubKeyNames(root, key);
        if (list.isEmpty()) {
            return list;
        }
        if (!(list instanceof ArrayList)) {
            list = new ArrayList<String>(list);
        }
        Object prefix = key.endsWith("\\") ? key : key + "\\";
        list.replaceAll(arg_0 -> WinReg.lambda$querySubKeys$0((String)prefix, arg_0));
        return list;
    }

    private static /* synthetic */ String lambda$querySubKeys$0(String prefix, String str) {
        return prefix + str;
    }

    public static enum HKEY {
        HKEY_CLASSES_ROOT(Integer.MIN_VALUE),
        HKEY_CURRENT_USER(-2147483647),
        HKEY_LOCAL_MACHINE(-2147483646),
        HKEY_USERS(-2147483645),
        HKEY_PERFORMANCE_DATA(-2147483644),
        HKEY_PERFORMANCE_TEXT(-2147483568),
        HKEY_PERFORMANCE_NLSTEXT(-2147483552),
        HKEY_CURRENT_CONFIG(-2147483643),
        HKEY_DYN_DATA(-2147483642),
        HKEY_CURRENT_USER_LOCAL_SETTINGS(-2147483641);

        private final int value;

        private HKEY(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Pointer toPointer() {
            return Pointer.createConstant((long)this.value);
        }
    }

    private static final class JNAWinReg
    extends WinReg {
        private final Advapi32 advapi32;

        JNAWinReg(Advapi32 advapi32) {
            this.advapi32 = advapi32;
        }

        @Override
        public boolean exists(HKEY root, String key) {
            PointerByReference phkKey = new PointerByReference();
            int status = this.advapi32.RegOpenKeyExW(root.toPointer(), new WString(key), 0, 131097, phkKey);
            if (status == 0) {
                this.advapi32.RegCloseKey(phkKey.getValue());
                return true;
            }
            return false;
        }

        private static void checkLength(int expected, int actual) {
            if (expected != actual) {
                throw new IllegalStateException("Expected " + expected + " bytes, but got " + actual);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public Object queryValue(HKEY root, String key, String valueName) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 17[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> querySubKeyNames(HKEY root, String key) {
            PointerByReference phkKey = new PointerByReference();
            if (this.advapi32.RegOpenKeyExW(root.toPointer(), new WString(key), 0, 131097, phkKey) != 0) {
                return Collections.emptyList();
            }
            Pointer hkey = phkKey.getValue();
            try {
                ArrayList<String> res = new ArrayList<String>();
                int maxKeyLength = 256;
                try (Memory lpName = new Memory(maxKeyLength * 2);){
                    int status;
                    IntByReference lpcchName = new IntByReference();
                    int i = 0;
                    while (true) {
                        lpcchName.setValue(maxKeyLength);
                        status = this.advapi32.RegEnumKeyExW(hkey, i, lpName, lpcchName, null, null, null, null);
                        if (status != 0) break;
                        res.add(lpName.getWideString(0L));
                        ++i;
                    }
                    if (status != 259) {
                        Logger.LOG.warning("Failed to enum key: " + status);
                    }
                }
                ArrayList<String> arrayList = res;
                return arrayList;
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to query keys", e);
            }
            finally {
                this.advapi32.RegCloseKey(hkey);
            }
            return Collections.emptyList();
        }
    }
}

