/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.Collections;
import java.util.Map;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class NativeUtils {
    public static final boolean USE_JNA = NativeUtils.useJNA();

    @Nullable
    public static <T extends Library> T load(String name, Class<T> interfaceClass) {
        return NativeUtils.load(name, interfaceClass, Collections.emptyMap());
    }

    @Nullable
    public static <T extends Library> T load(String name, Class<T> interfaceClass, Map<String, ?> options) {
        if (USE_JNA) {
            try {
                return Native.load(name, interfaceClass, options);
            }
            catch (UnsatisfiedLinkError e) {
                Logger.LOG.warning("Failed to load native library: " + name, e);
            }
        }
        return null;
    }

    private static boolean useJNA() {
        String backend = System.getProperty("hmcl.native.backend");
        if (backend == null || "auto".equalsIgnoreCase(backend)) {
            try {
                if (Platform.isWindows()) {
                    String osVersion = System.getProperty("os.version");
                    if (osVersion == null || osVersion.startsWith("5.") || osVersion.equals("6.0")) {
                        return false;
                    }
                    Native.getDefaultStringEncoding();
                    return true;
                }
                return false;
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        if ("jna".equalsIgnoreCase(backend)) {
            Native.getDefaultStringEncoding();
            return true;
        }
        if ("none".equalsIgnoreCase(backend)) {
            return false;
        }
        throw new Error("Unsupported native backend: " + backend);
    }

    private NativeUtils() {
    }
}

