/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.nio.file.Path;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.game.WorldLockedException;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.versions.WorldExportPage;
import org.jackhuang.hmcl.ui.versions.WorldListItemSkin;
import org.jackhuang.hmcl.ui.versions.WorldListPage;
import org.jackhuang.hmcl.ui.versions.WorldManagePage;
import org.jackhuang.hmcl.ui.wizard.SinglePageWizardProvider;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class WorldListItem
extends Control {
    private final World world;
    private final Path backupsDir;
    private final WorldListPage parent;
    private final Profile profile;
    private final String id;

    public WorldListItem(WorldListPage parent, World world, Path backupsDir, Profile profile, String id) {
        this.world = world;
        this.backupsDir = backupsDir;
        this.parent = parent;
        this.profile = profile;
        this.id = id;
    }

    protected Skin<?> createDefaultSkin() {
        return new WorldListItemSkin(this);
    }

    public World getWorld() {
        return this.world;
    }

    public void export() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("world.export.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("world"), new String[]{"*.zip"}));
        fileChooser.setInitialFileName(this.world.getWorldName());
        Path file = FileUtils.toPath(fileChooser.showSaveDialog((Window)Controllers.getStage()));
        if (file == null) {
            return;
        }
        Controllers.getDecorator().startWizard(new SinglePageWizardProvider(controller -> new WorldExportPage(this.world, file, controller::onFinish)));
    }

    public void delete() {
        Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("world.delete"), () -> Task.runAsync(this.world::delete).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.parent.remove(this);
            } else if (exception instanceof WorldLockedException) {
                Controllers.dialog(I18n.i18n("world.locked.failed"), null, MessageDialogPane.MessageType.WARNING);
            } else {
                Controllers.dialog(I18n.i18n("world.delete.failed", StringUtils.getStackTrace(exception)), null, MessageDialogPane.MessageType.WARNING);
            }
        }).start(), null);
    }

    public void reveal() {
        FXUtils.openFolder(this.world.getFile());
    }

    public void showManagePage() {
        Controllers.navigate((Node)new WorldManagePage(this.world, this.backupsDir, this.profile, this.id));
    }

    public void launch() {
        Versions.launchAndEnterWorld(this.profile, this.id, this.world.getFileName());
    }

    public void generateLaunchScript() {
        Versions.generateLaunchScriptForQuickEnterWorld(this.profile, this.id, this.world.getFileName());
    }
}

