/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXProgressBar;
import java.util.function.Consumer;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.ClassicAccount;
import org.jackhuang.hmcl.auth.NoSelectedCharacterException;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public class ClassicAccountLoginDialog
extends StackPane {
    private final ClassicAccount oldAccount;
    private final Consumer<AuthInfo> success;
    private final Runnable failed;
    private final JFXPasswordField txtPassword;
    private final Label lblCreationWarning = new Label();
    private final JFXProgressBar progressBar;

    public ClassicAccountLoginDialog(ClassicAccount oldAccount, Consumer<AuthInfo> success, Runnable failed) {
        this.oldAccount = oldAccount;
        this.success = success;
        this.failed = failed;
        this.progressBar = new JFXProgressBar();
        StackPane.setAlignment((Node)this.progressBar, (Pos)Pos.TOP_CENTER);
        this.progressBar.setVisible(false);
        JFXDialogLayout dialogLayout = new JFXDialogLayout();
        dialogLayout.setHeading(new Node[]{new Label(I18n.i18n("login.enter_password"))});
        VBox body = new VBox(15.0);
        body.setPadding(new Insets(15.0, 0.0, 0.0, 0.0));
        Label usernameLabel = new Label(oldAccount.getUsername());
        this.txtPassword = new JFXPasswordField();
        this.txtPassword.setOnAction(e -> this.onAccept());
        this.txtPassword.getValidators().add((Object)new RequiredValidator());
        this.txtPassword.setLabelFloat(true);
        this.txtPassword.setPromptText(I18n.i18n("account.password"));
        body.getChildren().setAll((Object[])new Node[]{usernameLabel, this.txtPassword});
        dialogLayout.setBody(new Node[]{body});
        JFXButton acceptButton = new JFXButton(I18n.i18n("button.ok"));
        acceptButton.setOnAction(e -> this.onAccept());
        acceptButton.getStyleClass().add((Object)"dialog-accept");
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.setOnAction(e -> this.onCancel());
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        dialogLayout.setActions(new Node[]{this.lblCreationWarning, acceptButton, cancelButton});
        this.getChildren().setAll((Object[])new Node[]{dialogLayout});
        FXUtils.onEscPressed((Node)this, this::onCancel);
    }

    private void onAccept() {
        String password = this.txtPassword.getText();
        this.progressBar.setVisible(true);
        this.lblCreationWarning.setText("");
        Task.supplyAsync(() -> this.oldAccount.logInWithPassword(password)).whenComplete(Schedulers.javafx(), authInfo -> {
            this.success.accept((AuthInfo)authInfo);
            this.fireEvent(new DialogCloseEvent());
            this.progressBar.setVisible(false);
        }, e -> {
            Logger.LOG.info("Failed to login with password: " + String.valueOf(this.oldAccount), (Throwable)e);
            if (e instanceof NoSelectedCharacterException) {
                this.fireEvent(new DialogCloseEvent());
            } else {
                this.lblCreationWarning.setText(Accounts.localizeErrorMessage(e));
            }
            this.progressBar.setVisible(false);
        }).start();
    }

    private void onCancel() {
        this.failed.run();
        this.fireEvent(new DialogCloseEvent());
    }
}

