/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.HTMLRenderer;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public final class WebPage
extends SpinnerPane
implements DecoratorPage {
    private final ObjectProperty<DecoratorPage.State> stateProperty;

    public WebPage(String title, String content) {
        this.stateProperty = new SimpleObjectProperty((Object)DecoratorPage.State.fromTitle(title));
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        Task.supplyAsync(() -> {
            Document document = Jsoup.parseBodyFragment(content);
            HTMLRenderer renderer = new HTMLRenderer(uri -> Controllers.confirm(I18n.i18n("web.open_in_browser", uri), I18n.i18n("message.confirm"), () -> FXUtils.openLink(uri.toString()), null));
            renderer.appendNode(document);
            renderer.mergeLineBreaks();
            return renderer.render();
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                ScrollPane scrollPane = new ScrollPane();
                scrollPane.setFitToWidth(true);
                scrollPane.setContent((Node)result);
                this.setContent((Node)scrollPane);
                this.setFailedReason(null);
            } else {
                Logger.LOG.warning("Failed to load content", exception);
                this.setFailedReason(I18n.i18n("web.failed"));
            }
        }).start();
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.stateProperty;
    }
}

