/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.List;
import java.util.concurrent.CancellationException;
import kala.compress.archivers.tar.TarArchiveEntry;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.tree.TarFileTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TerracottaNative {
    private final List<URI> links;
    private final FileDownloadTask.IntegrityCheck checking;
    private final Path path;

    public TerracottaNative(List<URI> links, Path path, FileDownloadTask.IntegrityCheck checking) {
        this.links = links;
        this.path = path;
        this.checking = checking;
    }

    public Path getPath() {
        return this.path;
    }

    public Task<?> install(final ITerracottaProvider.Context context, @Nullable TarFileTree tree) {
        if (tree == null) {
            return new FileDownloadTask(this.links, this.path, this.checking){

                @Override
                protected FetchTask.Context getContext(HttpResponse<?> response, boolean checkETag, String bmclapiHash) throws IOException {
                    final FetchTask.Context delegate = super.getContext(response, checkETag, bmclapiHash);
                    return new FetchTask.Context(){

                        @Override
                        public void withResult(boolean success) {
                            delegate.withResult(success);
                        }

                        @Override
                        public void write(byte[] buffer, int offset, int len) throws IOException {
                            if (!context.hasInstallFence()) {
                                throw new CancellationException("User has installed terracotta from local archives.");
                            }
                            delegate.write(buffer, offset, len);
                        }

                        @Override
                        public void close() throws IOException {
                            if (this.isSuccess() && !context.requestInstallFence()) {
                                throw new CancellationException();
                            }
                            delegate.close();
                        }
                    };
                }
            };
        }
        return Task.runAsync(() -> {
            String name = FileUtils.getName(this.path);
            TarArchiveEntry entry = (TarArchiveEntry)tree.getRoot().getFiles().get(name);
            if (entry == null) {
                throw new ITerracottaProvider.ArchiveFileMissingException("Cannot exact entry: " + name);
            }
            if (!context.requestInstallFence()) {
                throw new CancellationException();
            }
            Files.createDirectories(this.path.toAbsolutePath().getParent(), new FileAttribute[0]);
            final MessageDigest digest = DigestUtils.getDigest(this.checking.getAlgorithm());
            try (InputStream stream = tree.getInputStream(entry);
                 final OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
                stream.transferTo(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        os.write(b);
                        digest.update((byte)b);
                    }

                    @Override
                    public void write(byte @NotNull [] buffer, int offset, int len) throws IOException {
                        os.write(buffer, offset, len);
                        digest.update(buffer, offset, len);
                    }
                });
            }
            String checksum = HexFormat.of().formatHex(digest.digest());
            if (!checksum.equalsIgnoreCase(this.checking.getChecksum())) {
                Files.delete(this.path);
                throw new ITerracottaProvider.ArchiveFileMissingException("Incorrect checksum (" + this.checking.getAlgorithm() + "), expected: " + this.checking.getChecksum() + ", actual: " + checksum);
            }
        });
    }

    public ITerracottaProvider.Status status() throws IOException {
        if (Files.exists(this.path, new LinkOption[0]) && DigestUtils.digestToString(this.checking.getAlgorithm(), this.path).equalsIgnoreCase(this.checking.getChecksum())) {
            return ITerracottaProvider.Status.READY;
        }
        try {
            if (TerracottaMetadata.hasLegacyVersionFiles()) {
                return ITerracottaProvider.Status.LEGACY_VERSION;
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Cannot determine whether legacy versions exist.");
        }
        return ITerracottaProvider.Status.NOT_EXIST;
    }
}

