/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.FileNotFoundException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javafx.beans.InvalidationListener;
import javax.net.ssl.SSLHandshakeException;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.AutoDownloadProvider;
import org.jackhuang.hmcl.download.BMCLAPIDownloadProvider;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.DownloadProviderWrapper;
import org.jackhuang.hmcl.download.MojangDownloadProvider;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;

public final class DownloadProviders {
    public static final String DEFAULT_AUTO_PROVIDER_ID = "balanced";
    public static final String DEFAULT_DIRECT_PROVIDER_ID = "mojang";
    private static final DownloadProviderWrapper PROVIDER_WRAPPER;
    private static final DownloadProvider DEFAULT_PROVIDER;
    public static final Map<String, DownloadProvider> DIRECT_PROVIDERS;
    public static final Map<String, DownloadProvider> AUTO_PROVIDERS;

    private DownloadProviders() {
    }

    static void init() {
        InvalidationListener onChangeDownloadThreads = observable -> FetchTask.setDownloadExecutorConcurrency(ConfigHolder.config().getAutoDownloadThreads() ? FetchTask.DEFAULT_CONCURRENCY : ConfigHolder.config().getDownloadThreads());
        ConfigHolder.config().autoDownloadThreadsProperty().addListener(onChangeDownloadThreads);
        ConfigHolder.config().downloadThreadsProperty().addListener(onChangeDownloadThreads);
        onChangeDownloadThreads.invalidated(null);
        InvalidationListener onChangeDownloadSource = observable -> {
            if (ConfigHolder.config().isAutoChooseDownloadType()) {
                String versionListSource = ConfigHolder.config().getVersionListSource();
                DownloadProvider downloadProvider = versionListSource != null ? AUTO_PROVIDERS.getOrDefault(versionListSource, DEFAULT_PROVIDER) : DEFAULT_PROVIDER;
                PROVIDER_WRAPPER.setProvider(downloadProvider);
            } else {
                String downloadType = ConfigHolder.config().getDownloadType();
                PROVIDER_WRAPPER.setProvider(downloadType != null ? DIRECT_PROVIDERS.getOrDefault(downloadType, DEFAULT_PROVIDER) : DEFAULT_PROVIDER);
            }
        };
        ConfigHolder.config().versionListSourceProperty().addListener(onChangeDownloadSource);
        ConfigHolder.config().autoChooseDownloadTypeProperty().addListener(onChangeDownloadSource);
        ConfigHolder.config().downloadTypeProperty().addListener(onChangeDownloadSource);
        onChangeDownloadSource.invalidated(null);
    }

    public static DownloadProvider getDownloadProvider() {
        return PROVIDER_WRAPPER;
    }

    public static String localizeErrorMessage(Throwable exception) {
        if (exception instanceof DownloadException) {
            URI uri = ((DownloadException)exception).getUri();
            if (exception.getCause() instanceof SocketTimeoutException) {
                return I18n.i18n("install.failed.downloading.timeout", uri);
            }
            if (exception.getCause() instanceof ResponseCodeException) {
                ResponseCodeException responseCodeException = (ResponseCodeException)exception.getCause();
                if (I18n.hasKey("download.code." + responseCodeException.getResponseCode())) {
                    return I18n.i18n("download.code." + responseCodeException.getResponseCode(), uri);
                }
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(exception.getCause());
            }
            if (exception.getCause() instanceof FileNotFoundException) {
                return I18n.i18n("download.code.404", uri);
            }
            if (exception.getCause() instanceof AccessDeniedException) {
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + I18n.i18n("exception.access_denied", ((AccessDeniedException)exception.getCause()).getFile());
            }
            if (exception.getCause() instanceof ArtifactMalformedException) {
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + I18n.i18n("exception.artifact_malformed");
            }
            if (exception.getCause() instanceof SSLHandshakeException) {
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + I18n.i18n("exception.ssl_handshake");
            }
            return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(exception.getCause());
        }
        if (exception instanceof ArtifactMalformedException) {
            return I18n.i18n("exception.artifact_malformed");
        }
        if (exception instanceof CancellationException) {
            return I18n.i18n("message.cancelled");
        }
        return StringUtils.getStackTrace(exception);
    }

    static {
        String bmclapiRoot = System.getProperty("hmcl.bmclapi.override", "https://bmclapi2.bangbang93.com");
        BMCLAPIDownloadProvider bmclapiRaw = new BMCLAPIDownloadProvider(bmclapiRoot);
        MojangDownloadProvider mojang = new MojangDownloadProvider();
        AutoDownloadProvider bmclapi = new AutoDownloadProvider(bmclapiRaw, mojang);
        DEFAULT_PROVIDER = mojang;
        DIRECT_PROVIDERS = Lang.mapOf(Pair.pair(DEFAULT_DIRECT_PROVIDER_ID, mojang), Pair.pair("bmclapi", bmclapi));
        AUTO_PROVIDERS = Lang.mapOf(Pair.pair(DEFAULT_AUTO_PROVIDER_ID, LocaleUtils.IS_CHINA_MAINLAND ? bmclapi : mojang), Pair.pair("official", LocaleUtils.IS_CHINA_MAINLAND ? new AutoDownloadProvider(List.of(mojang, bmclapiRaw), List.of(bmclapiRaw, mojang)) : mojang), Pair.pair("mirror", bmclapi));
        PROVIDER_WRAPPER = new DownloadProviderWrapper(DEFAULT_PROVIDER);
    }
}

