/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.Arrays;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.logging.Logger;

public class MultipleSourceVersionList
extends VersionList<RemoteVersion> {
    private final VersionList<?>[] backends;

    MultipleSourceVersionList(VersionList<?>[] backends) {
        this.backends = backends;
        assert (backends.length >= 1);
    }

    @Override
    public boolean hasType() {
        boolean hasType = this.backends[0].hasType();
        assert (Arrays.stream(this.backends).allMatch(versionList -> versionList.hasType() == hasType));
        return hasType;
    }

    @Override
    public Task<?> refreshAsync() {
        throw new UnsupportedOperationException("MultipleSourceVersionList does not support loading the entire remote version list.");
    }

    private Task<?> refreshAsync(String gameVersion, int sourceIndex) {
        VersionList<?> versionList = this.backends[sourceIndex];
        return versionList.refreshAsync(gameVersion).thenComposeAsync(() -> {
            this.lock.writeLock().lock();
            try {
                this.versions.putAll(gameVersion, versionList.getVersions(gameVersion));
            }
            catch (Exception e) {
                if (sourceIndex == this.backends.length - 1) {
                    Logger.LOG.warning("Failed to fetch versions list from all sources", e);
                    throw e;
                }
                Logger.LOG.warning("Failed to fetch versions list and try to fetch from other source", e);
                Task<?> task = this.refreshAsync(gameVersion, sourceIndex + 1);
                return task;
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return null;
        });
    }

    @Override
    public Task<?> refreshAsync(String gameVersion) {
        this.versions.clear(gameVersion);
        return this.refreshAsync(gameVersion, 0);
    }
}

