/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.archivers.zip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import kala.compress.archivers.zip.AsiExtraField;
import kala.compress.archivers.zip.ExtraFieldParsingBehavior;
import kala.compress.archivers.zip.JarMarker;
import kala.compress.archivers.zip.ResourceAlignmentExtraField;
import kala.compress.archivers.zip.UnicodeCommentExtraField;
import kala.compress.archivers.zip.UnicodePathExtraField;
import kala.compress.archivers.zip.UnparseableExtraFieldBehavior;
import kala.compress.archivers.zip.UnparseableExtraFieldData;
import kala.compress.archivers.zip.UnrecognizedExtraField;
import kala.compress.archivers.zip.X000A_NTFS;
import kala.compress.archivers.zip.X0014_X509Certificates;
import kala.compress.archivers.zip.X0015_CertificateIdForFile;
import kala.compress.archivers.zip.X0016_CertificateIdForCentralDirectory;
import kala.compress.archivers.zip.X0017_StrongEncryptionHeader;
import kala.compress.archivers.zip.X0019_EncryptionRecipientCertificateList;
import kala.compress.archivers.zip.X5455_ExtendedTimestamp;
import kala.compress.archivers.zip.X7875_NewUnix;
import kala.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import kala.compress.archivers.zip.ZipExtraField;
import kala.compress.archivers.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static final HashMap<ZipShort, Supplier<ZipExtraField>> IMPLEMENTATIONS = new HashMap();
    static final ZipExtraField[] EMPTY_ZIP_EXTRA_FIELD_ARRAY;

    public static ZipExtraField createExtraField(ZipShort headerId) {
        ZipExtraField field = ExtraFieldUtils.createExtraFieldNoDefault(headerId);
        if (field != null) {
            return field;
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static ZipExtraField createExtraFieldNoDefault(ZipShort headerId) {
        Supplier<ZipExtraField> provider = IMPLEMENTATIONS.get(headerId);
        return provider != null ? provider.get() : null;
    }

    public static ZipExtraField fillExtraField(ZipExtraField ze, byte[] data, int off, int len, boolean local) throws ZipException {
        try {
            if (local) {
                ze.parseFromLocalFileData(data, off, len);
            } else {
                ze.parseFromCentralDirectoryData(data, off, len);
            }
            return ze;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw (ZipException)new ZipException("Failed to parse corrupt ZIP extra field of type " + Integer.toHexString(ze.getHeaderId().getValue())).initCause(e);
        }
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        byte[] central;
        int dataLength = data.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getCentralDirectoryLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data[i].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i].getCentralDirectoryLength().getBytes(), 0, result, start + 2, 2);
            start += 4;
            byte[] central2 = data[i].getCentralDirectoryData();
            if (central2 == null) continue;
            System.arraycopy(central2, 0, result, start, central2.length);
            start += central2.length;
        }
        if (lastIsUnparseableHolder && (central = data[dataLength - 1].getCentralDirectoryData()) != null) {
            System.arraycopy(central, 0, result, start, central.length);
        }
        return result;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        byte[] local;
        int dataLength = data.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getLocalFileDataLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data[i].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i].getLocalFileDataLength().getBytes(), 0, result, start + 2, 2);
            start += 4;
            byte[] local2 = data[i].getLocalFileDataData();
            if (local2 == null) continue;
            System.arraycopy(local2, 0, result, start, local2.length);
            start += local2.length;
        }
        if (lastIsUnparseableHolder && (local = data[dataLength - 1].getLocalFileDataData()) != null) {
            System.arraycopy(local, 0, result, start, local.length);
        }
        return result;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        return ExtraFieldUtils.parse(data, true, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local) throws ZipException {
        return ExtraFieldUtils.parse(data, local, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local, ExtraFieldParsingBehavior parsingBehavior) throws ZipException {
        int length;
        ArrayList<ZipExtraField> v = new ArrayList<ZipExtraField>();
        int dataLength = data.length;
        for (int start = 0; start <= dataLength - 4; start += length + 4) {
            ZipShort headerId = new ZipShort(data, start);
            length = new ZipShort(data, start + 2).getValue();
            if (start + 4 + length > dataLength) {
                ZipExtraField field = parsingBehavior.onUnparseableExtraField(data, start, dataLength - start, local, length);
                if (field == null) break;
                v.add(field);
                break;
            }
            try {
                ZipExtraField ze = Objects.requireNonNull(parsingBehavior.createExtraField(headerId), "createExtraField must not return null");
                v.add(Objects.requireNonNull(parsingBehavior.fill(ze, data, start + 4, length, local), "fill must not return null"));
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw (ZipException)new ZipException(e.getMessage()).initCause(e);
            }
        }
        return v.toArray(EMPTY_ZIP_EXTRA_FIELD_ARRAY);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local, final UnparseableExtraField onUnparseableData) throws ZipException {
        return ExtraFieldUtils.parse(data, local, new ExtraFieldParsingBehavior(){

            @Override
            public ZipExtraField createExtraField(ZipShort headerId) {
                return ExtraFieldUtils.createExtraField(headerId);
            }

            @Override
            public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) throws ZipException {
                return ExtraFieldUtils.fillExtraField(field, data, off, len, local);
            }

            @Override
            public ZipExtraField onUnparseableExtraField(byte[] data, int off, int len, boolean local, int claimedLength) throws ZipException {
                return onUnparseableData.onUnparseableExtraField(data, off, len, local, claimedLength);
            }
        });
    }

    static {
        IMPLEMENTATIONS.put(AsiExtraField.HEADER_ID, AsiExtraField::new);
        IMPLEMENTATIONS.put(X5455_ExtendedTimestamp.HEADER_ID, X5455_ExtendedTimestamp::new);
        IMPLEMENTATIONS.put(X7875_NewUnix.HEADER_ID, X7875_NewUnix::new);
        IMPLEMENTATIONS.put(JarMarker.ID, JarMarker::new);
        IMPLEMENTATIONS.put(UnicodePathExtraField.UPATH_ID, UnicodePathExtraField::new);
        IMPLEMENTATIONS.put(UnicodeCommentExtraField.UCOM_ID, UnicodeCommentExtraField::new);
        IMPLEMENTATIONS.put(Zip64ExtendedInformationExtraField.HEADER_ID, Zip64ExtendedInformationExtraField::new);
        IMPLEMENTATIONS.put(X000A_NTFS.HEADER_ID, X000A_NTFS::new);
        IMPLEMENTATIONS.put(X0014_X509Certificates.HEADER_ID, X0014_X509Certificates::new);
        IMPLEMENTATIONS.put(X0015_CertificateIdForFile.HEADER_ID, X0015_CertificateIdForFile::new);
        IMPLEMENTATIONS.put(X0016_CertificateIdForCentralDirectory.HEADER_ID, X0016_CertificateIdForCentralDirectory::new);
        IMPLEMENTATIONS.put(X0017_StrongEncryptionHeader.HEADER_ID, X0017_StrongEncryptionHeader::new);
        IMPLEMENTATIONS.put(X0019_EncryptionRecipientCertificateList.HEADER_ID, X0019_EncryptionRecipientCertificateList::new);
        IMPLEMENTATIONS.put(ResourceAlignmentExtraField.ID, ResourceAlignmentExtraField::new);
        EMPTY_ZIP_EXTRA_FIELD_ARRAY = new ZipExtraField[0];
    }

    public static final class UnparseableExtraField
    implements UnparseableExtraFieldBehavior {
        public static final int THROW_KEY = 0;
        public static final int SKIP_KEY = 1;
        public static final int READ_KEY = 2;
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int k) {
            this.key = k;
        }

        public int getKey() {
            return this.key;
        }

        @Override
        public ZipExtraField onUnparseableExtraField(byte[] data, int off, int len, boolean local, int claimedLength) throws ZipException {
            switch (this.key) {
                case 0: {
                    throw new ZipException("Bad extra field starting at " + off + ".  Block length of " + claimedLength + " bytes exceeds remaining data of " + (len - 4) + " bytes.");
                }
                case 2: {
                    UnparseableExtraFieldData field = new UnparseableExtraFieldData();
                    if (local) {
                        field.parseFromLocalFileData(data, off, len);
                    } else {
                        field.parseFromCentralDirectoryData(data, off, len);
                    }
                    return field;
                }
                case 1: {
                    return null;
                }
            }
            throw new ZipException("Unknown UnparseableExtraField key: " + this.key);
        }
    }
}

