/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.jackhuang.hmcl.util.io.FileUtils;

final class DirectoryStructurePrinter {
    private DirectoryStructurePrinter() {
    }

    public static String list(Path path, int maxDepth) throws IOException {
        StringBuilder output = new StringBuilder(128);
        DirectoryStructurePrinter.list(path, maxDepth, output);
        output.setLength(output.length() - 1);
        return output.toString();
    }

    private static void list(Path path, final int maxDepth, final StringBuilder output) throws IOException {
        output.append("Filesystem structure of: ").append(path).append('\n');
        if (!Files.exists(path, new LinkOption[0])) {
            DirectoryStructurePrinter.pushMessage(output, "nonexistent path", 1);
            return;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            DirectoryStructurePrinter.pushMessage(output, "regular file path", 1);
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                private boolean isFolderEmpty;
                private int depth = 1;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    this.isFolderEmpty = true;
                    DirectoryStructurePrinter.pushFile(output, dir, this.depth);
                    if (this.depth == maxDepth) {
                        DirectoryStructurePrinter.pushMessage(output, "too deep", this.depth);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    ++this.depth;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    this.isFolderEmpty = false;
                    DirectoryStructurePrinter.pushFile(output, file, this.depth);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    this.visitFile(file, (BasicFileAttributes)null);
                    DirectoryStructurePrinter.pushMessage(output, exc.toString(), this.depth);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (this.isFolderEmpty) {
                        DirectoryStructurePrinter.pushMessage(output, "empty directory", this.depth);
                    }
                    --this.depth;
                    return FileVisitResult.CONTINUE;
                }
            });
            return;
        }
        DirectoryStructurePrinter.pushMessage(output, "unknown file type", 1);
    }

    private static void pushFile(StringBuilder output, Path file, int depth) {
        output.append("|");
        for (int i = 1; i < depth; ++i) {
            output.append("  |");
        }
        output.append("-> ").append(FileUtils.getName(file)).append('\n');
    }

    private static void pushMessage(StringBuilder output, String message, int depth) {
        output.append("| ");
        for (int i = 1; i < depth; ++i) {
            output.append(" | ");
        }
        output.append('<').append(message).append(">\n");
    }
}

